/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ao.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.service.CustomPermissionConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V101ManagerLocationUpdate
implements ActiveObjectsUpgradeTask {
    static final Logger LOG = LoggerFactory.getLogger(V101ManagerLocationUpdate.class);
    static final ModelVersion VERSION = ModelVersion.valueOf((String)"101");

    public ModelVersion getModelVersion() {
        return VERSION;
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        if (currentVersion.isNewerThan(VERSION)) {
            return;
        }
        ao.migrate(new Class[]{CSUMConfigEntity.class});
        LOG.info("Setting user manager location to Confluence");
        try {
            CSUMConfigEntity[] allConfigs;
            for (CSUMConfigEntity aConfig : allConfigs = (CSUMConfigEntity[])ao.find(CSUMConfigEntity.class)) {
                aConfig.setUserManagerLocation(CustomPermissionConstants.MANAGER_LOCATIONS.Confluence.name());
                aConfig.save();
            }
        }
        catch (Exception e) {
            LOG.error("Upgrade problem: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

