/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.publicapi.rest;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.impl.EntityMissingException;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/public/group")
@PublicApi
public class PublicCSUMGroupResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(PublicCSUMGroupResource.class);
    ICSUMActiveObjectService fAos;
    private final ICSUMCacheManager fCacheManager;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final PluginAccessor fPluginAccessor;
    private final I18nResolver fI18n;
    private static final String EMPTY_STRING = "";

    public PublicCSUMGroupResource(@ComponentImport SpaceManager spaceManager, ICSUMCacheManager cacheManager, ICSUMActiveObjectService aos, SpaceGroupUtil grpUtil, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport I18nResolver i18n) {
        super(spaceManager, permissionUtil, tokenService, permissionManager, cacheManager);
        this.fCacheManager = cacheManager;
        this.fAos = aos;
        this.fSpaceGroupUtil = grpUtil;
        this.fPluginAccessor = pluginAccessor;
        this.fI18n = i18n;
    }

    @POST
    @RequiresXsrfCheck
    @Path(value="/create")
    @Produces(value={"application/json"})
    public int createGroupFromName(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String groupName) {
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build().getStatus();
        }
        boolean isPermitted = this.isPermitted(validSpace);
        if (!isPermitted) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build().getStatus();
        }
        Response response = groupName != null ? (!this.fCacheManager.getCachedConfig().isGroupActionsPermitted() ? Response.ok().status(Response.Status.UNAUTHORIZED).build() : this.createGroup(validSpace, groupName)) : Response.noContent().status(Response.Status.NO_CONTENT).build();
        return response.getStatus();
    }

    @DELETE
    @RequiresXsrfCheck
    @Path(value="/delete")
    @Produces(value={"application/json"})
    public int deleteSpaceGroup(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="groupName") String groupNameStr) {
        Response response;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        String groupName = groupNameStr != null ? groupNameStr : EMPTY_STRING;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build().getStatus();
        }
        boolean isPermitted = this.isPermitted(validSpace);
        if (!isPermitted) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build().getStatus();
        }
        try {
            response = this.fSpaceGroupUtil.deleteSpaceGroup(validSpace, groupName) ? Response.ok().build() : Response.notModified().build();
        }
        catch (EntityMissingException e) {
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + " not authorised for this action", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (GroupActionNotPermittedException e) {
            LOG.error("Group actions disabled in CSUM config for space: " + spaceKey, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (SpaceGroupPatternMismatchException e) {
            LOG.error("SpaceKey: " + spaceKey + " is not associated with group: " + groupName, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error occurred when deleting space group: " + groupName, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response.getStatus();
    }

    @PUT
    @RequiresXsrfCheck
    @Path(value="/addusers")
    @Produces(value={"application/json"})
    public Response addUsersToGroups(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="spaceGroups") String spaceGroupsStr, @QueryParam(value="spaceUsers") String spaceUsersStr, @QueryParam(value="importViaGroups") String importViaGroupsStr) {
        Response response;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        String spaceGroups = spaceGroupsStr != null ? spaceGroupsStr : EMPTY_STRING;
        String spaceUsers = spaceUsersStr != null ? spaceUsersStr : EMPTY_STRING;
        String importViaGroups = importViaGroupsStr != null ? importViaGroupsStr : EMPTY_STRING;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        boolean isPermitted = this.isPermitted(validSpace);
        if (!isPermitted) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (spaceUsers.trim().isEmpty() && importViaGroups.trim().isEmpty() || spaceGroups.trim().isEmpty()) {
            LOG.error("No groups or users specified: spaceGroups=" + spaceGroups + ", importViaGroups = " + null + ", spaceUsers=" + null);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        try {
            Pair<Map<String, String>, Map<String, String>> invalidUsersAndGroups = this.fSpaceGroupUtil.addUsersToGroups(validSpace, spaceGroups, spaceUsers, importViaGroups);
            response = Response.ok((Object)invalidUsersAndGroups.left()).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + "Not authorised for this action");
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exceptionBean).build();
        }
        catch (EntityException e) {
            LOG.error("Unable to get group/user for : " + spaceGroups, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (SpaceGroupPatternMismatchException e) {
            LOG.error("Spacekey: " + spaceKey + " not associated with this group", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error when adding users: " + spaceUsers + " to groups: " + spaceGroups, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    @DELETE
    @RequiresXsrfCheck
    @Path(value="/removeusers")
    @Produces(value={"application/json"})
    public Response removeUsersFromGroups(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="spaceGroups") String spaceGroupsStr, @QueryParam(value="spaceUsers") String spaceUsersStr, @QueryParam(value="importViaGroups") String importViaGroupsStr) {
        Response response;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        String spaceGroups = spaceGroupsStr != null ? spaceGroupsStr : EMPTY_STRING;
        String spaceUsers = spaceUsersStr != null ? spaceUsersStr : EMPTY_STRING;
        String importViaGroups = importViaGroupsStr != null ? importViaGroupsStr : EMPTY_STRING;
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
        }
        boolean isPermitted = this.isPermitted(validSpace);
        if (!isPermitted) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (spaceGroups.trim().isEmpty() || spaceUsers.trim().isEmpty() && importViaGroups.trim().isEmpty()) {
            LOG.error("Insufficient data: spaceKey=" + spaceKey + ", spaceGroups=" + spaceGroups + ", spaceGroupMembers=" + spaceUsers + "}, importViaGroups=" + importViaGroups);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.fI18n.getText("space.not.found", new Serializable[]{spaceKey})).build();
        }
        try {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (currentUser == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            this.fSpaceGroupUtil.removeGroupMembers(validSpace, spaceGroups, spaceUsers, importViaGroups, currentUser);
            response = Response.ok().build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + " not authorised for this action.", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (SpaceGroupPatternMismatchException e) {
            LOG.error("Problem with spacekey: " + spaceKey, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        catch (EntityException e) {
            LOG.error("Could not find users/groups: " + spaceGroups + ", " + spaceUsers, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (Exception e) {
            LOG.error("Could not remove " + spaceUsers + " from group: " + spaceGroups, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    private Response createGroup(Space space, String groupName) {
        Response response;
        try {
            Group createdGroup;
            response = space != null ? ((createdGroup = this.fSpaceGroupUtil.createSpaceGroup(space, groupName)) != null ? Response.ok().build() : Response.serverError().build()) : Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (DuplicateException e) {
            LOG.error("space group " + groupName + " already exists", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + " not authorized.", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (GroupActionNotPermittedException e) {
            LOG.error("Group actions disabled in CSUM config for space: " + space.getKey(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (EntityException e) {
            LOG.error("Error fetching existing space groups", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error occurred when creating space group: " + groupName, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).build();
        }
        return response;
    }

    private Space getValidSpaceFromSpaceKey(@QueryParam(value="spaceKey") String spaceKey) {
        Space validSpace = null;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
        }
        return validSpace;
    }
}

