/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.pluginpeople.confluence.csum.ao.CSUMActiveObjectServiceImpl;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.api.ITSpaceGroupUtil;
import com.pluginpeople.confluence.csum.api.ITTaskManager;
import com.pluginpeople.confluence.csum.task.TaskManager;
import com.pluginpeople.confluence.csum.task.TaskType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITTaskManagerImpl
implements ITTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(ITTaskManagerImpl.class);
    public static final String TEST = "test";
    private static final String STATUS = "status";
    private static final String FAILEDCSVPROCESS = "Failed to process CSV: ";
    private final TransactionTemplate fTxTemplate;
    private final CSUMActiveObjectServiceImpl fAos;
    private final SpaceManager fSpaceManager;
    private final TaskManager fTaskManager;
    private final BootstrapManager fBootstrapManager;
    private final ITSpaceGroupUtil fSpaceGroupUtil;

    @Autowired
    public ITTaskManagerImpl(@ComponentImport TransactionTemplate txTemplate, CSUMActiveObjectServiceImpl activeObjectService, @ComponentImport SpaceManager spaceManager, TaskManager taskManager, @ComponentImport BootstrapManager bm, ITSpaceGroupUtil spaceGroupUtil) {
        this.fSpaceManager = spaceManager;
        this.fTxTemplate = txTemplate;
        this.fAos = activeObjectService;
        this.fTaskManager = taskManager;
        this.fBootstrapManager = bm;
        this.fSpaceGroupUtil = spaceGroupUtil;
    }

    public Integer processCsv(InputStream inputStream, boolean addUsers, char delimiter, String spaceKey) {
        return (Integer)this.fTxTemplate.execute(() -> {
            try {
                Space space = this.fSpaceManager.getSpace(spaceKey);
                TaskType type = addUsers ? TaskType.ADD_GROUP_MEMBERS : TaskType.REMOVE_GROUP_MEMBERS;
                ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                CSUMTaskEntity taskEntity = this.fAos.createTaskEntity(type, space.getKey(), currentUser.getName());
                taskEntity.setStatus("uploading");
                taskEntity.save();
                this.storeFileFromStream(inputStream, taskEntity);
                return this.fTaskManager.processTask(type, space, delimiter, false, taskEntity);
            }
            catch (Exception e) {
                LOG.error(FAILEDCSVPROCESS + e.getLocalizedMessage());
                return 0;
            }
        });
    }

    public String getStatus(int id) {
        return (String)this.fTxTemplate.execute(() -> {
            LOG.debug("Gathering task status. Task id: " + id);
            Object status = "";
            Map<String, Object> task = this.fTaskManager.getTaskInfo(id);
            if (task != null) {
                status = this.fTaskManager.getTaskInfo(id).get(STATUS);
            }
            for (int counter = 0; (status.equals("running") || status.equals("uploading") || status.equals("queued")) && counter < 30; ++counter) {
                try {
                    this.fAos.flush(CSUMTaskEntity.class, id);
                    Thread.sleep(2000L);
                    LOG.debug("Waiting 2 seconds before checking status again as status is currently: " + status);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted exception when sleeping before checking task status again. Exception: " + e);
                }
                status = this.fTaskManager.getTaskInfo(id).get(STATUS);
            }
            LOG.debug("After waiting a minute, status is: " + status);
            return status.toString();
        });
    }

    public int getSuccesses(int id) {
        return (Integer)this.fTxTemplate.execute(() -> {
            Object status = this.fTaskManager.getTaskInfo(id).get(STATUS);
            long initialTime = System.currentTimeMillis();
            long totalTime = 0L;
            while ((status.equals("running") || status.equals("uploading") || status.equals("queued")) && totalTime < 30000L) {
                totalTime = System.currentTimeMillis() - initialTime;
                status = this.fTaskManager.getTaskInfo(id).get(STATUS);
            }
            return (Integer)(this.fTaskManager.getTaskInfo(id) != null ? this.fTaskManager.getTaskInfo(id).get("successful") : Integer.valueOf(0));
        });
    }

    public void storeFileFromStream(InputStream is, CSUMTaskEntity taskEntity) throws IOException {
        File storedFile = new File(this.getFileStorageDirectory(), String.valueOf(taskEntity.getID()));
        try (FileOutputStream outputStream = new FileOutputStream(storedFile, false);){
            int read;
            byte[] bytes = new byte[8192];
            while ((read = is.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        taskEntity.setFilename(String.valueOf(taskEntity.getID()));
        taskEntity.setFilePath(storedFile.getAbsolutePath());
    }

    public File getFileStorageDirectory() throws IOException {
        File location = new File(this.fBootstrapManager.getSharedHome(), "CSUM");
        if (!location.exists()) {
            Files.createDirectory(location.toPath(), new FileAttribute[0]);
        }
        return location;
    }

    public Integer processRenameGroup(Space space, String originalGroupName, String newGroupName) {
        return (Integer)this.fTxTemplate.execute(() -> {
            try {
                boolean renamedValid = this.fSpaceGroupUtil.renameGroup(space, originalGroupName);
                if (renamedValid) {
                    this.fTaskManager.getActiveRenameTaskWithEitherGroup(space, originalGroupName, newGroupName);
                    ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                    CSUMTaskEntity taskEntity = this.fAos.createTaskEntity(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER, space.getKey(), currentUser.getName());
                    taskEntity.setOriginalGroupName(originalGroupName);
                    taskEntity.setNewGroupName(newGroupName);
                    taskEntity.setStatus("queued");
                    taskEntity.save();
                    return this.fTaskManager.processTask(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER, space, originalGroupName, taskEntity, newGroupName, currentUser);
                }
                return 0;
            }
            catch (Exception e) {
                LOG.error(FAILEDCSVPROCESS + e.getLocalizedMessage());
                return 0;
            }
        });
    }

    public int createDummyRenameGroupTask(String spaceKey, String username, String originalGroupName, String newGroupName) {
        return (Integer)this.fTxTemplate.execute(() -> {
            try {
                CSUMTaskEntity taskEntity = this.fAos.createTaskEntity(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER, spaceKey, username);
                taskEntity.setOriginalGroupName(originalGroupName);
                taskEntity.setNewGroupName(newGroupName);
                taskEntity.setStatus("running");
                long twentyMinsAgo = System.currentTimeMillis() - 1200000L;
                Timestamp twentyMinsAgoTimestamp = new Timestamp(twentyMinsAgo);
                this.setTaskLastActivity(taskEntity.getID(), twentyMinsAgoTimestamp);
                taskEntity.save();
                return taskEntity.getID();
            }
            catch (Exception e) {
                LOG.error(FAILEDCSVPROCESS + e.getLocalizedMessage());
                return 0;
            }
        });
    }

    public boolean setTaskLastActivity(Integer taskId, Timestamp lastActivity) {
        CSUMTaskEntity task = this.fAos.getTaskEntity(taskId);
        if (task != null) {
            return (Boolean)this.fTxTemplate.execute(() -> {
                try {
                    CSUMTaskEntity taskInTransaction = this.fAos.getTaskEntity(taskId);
                    taskInTransaction.setLatestActivity(lastActivity);
                    taskInTransaction.save();
                    return true;
                }
                catch (Exception e) {
                    LOG.error(FAILEDCSVPROCESS + e.getLocalizedMessage());
                    return false;
                }
            });
        }
        return true;
    }

    public void clearAllTasksForSpace() {
        this.fAos.deleteTasksSubmittedBefore(LocalDateTime.now());
    }
}

