/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.ITPublicCSUMSpaceGroupManager;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.publicapi.components.PublicCSUMSpaceGroupUtil;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITPublicApiSpaceManagerImpl
implements ITPublicCSUMSpaceGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(ITPublicApiSpaceManagerImpl.class);
    private final PublicCSUMSpaceGroupUtil fSpaceUtil;
    private final TransactionTemplate fTxTemplate;
    private static final String IN_SPACE = " in space: ";

    @Autowired
    public ITPublicApiSpaceManagerImpl(PublicCSUMSpaceGroupUtil util, @ComponentImport TransactionTemplate txTemplate) {
        this.fSpaceUtil = util;
        this.fTxTemplate = txTemplate;
    }

    public Group createSpaceGroup(Space space, String groupName) throws AuthorizationException, GroupActionNotPermittedException, DuplicateException, EntityException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right((Object)this.fSpaceUtil.createSpaceGroup(space, groupName));
            }
            catch (EntityException | AuthorizationException | DuplicateException | GroupActionNotPermittedException e) {
                LOG.error("Could not create space group: " + (groupName != null ? groupName : "null") + IN_SPACE + (space != null ? space : "null"), e);
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception ex = (Exception)result.left().get();
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof DuplicateException) {
                throw (DuplicateException)((Object)ex);
            }
            if (ex instanceof GroupActionNotPermittedException) {
                throw (GroupActionNotPermittedException)((Object)ex);
            }
            if (ex instanceof EntityException) {
                throw (EntityException)((Object)ex);
            }
        }
        return (Group)result.getOrNull();
    }

    public boolean deleteSpaceGroup(Space space, String groupName) throws AuthorizationException, SpaceGroupPatternMismatchException, GroupActionNotPermittedException, EntityException, DuplicateException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right((Object)this.fSpaceUtil.deleteSpaceGroup(space, groupName));
            }
            catch (EntityException | AuthorizationException | GroupActionNotPermittedException | SpaceGroupPatternMismatchException e) {
                LOG.error("Could not delete space group: " + (groupName != null ? groupName : "null") + IN_SPACE + (space != null ? space : "null"), e);
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception ex = (Exception)result.left().get();
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof DuplicateException) {
                throw (DuplicateException)((Object)ex);
            }
            if (ex instanceof GroupActionNotPermittedException) {
                throw (GroupActionNotPermittedException)((Object)ex);
            }
            if (ex instanceof EntityException) {
                throw (EntityException)((Object)ex);
            }
        }
        return (Boolean)result.getOrNull();
    }

    public Pair<List<String>, List<String>> addUsersToGroups(Space space, String spaceGroups, String spaceUsers, String importViaGroups) throws AuthorizationException, EntityException, DuplicateException, GroupActionNotPermittedException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right(this.fSpaceUtil.addUsersToGroups(space, spaceGroups, spaceUsers, importViaGroups));
            }
            catch (EntityException | AuthorizationException | SpaceGroupPatternMismatchException e) {
                LOG.error("Could not add users/groups to space group(s): " + (spaceGroups != null ? spaceGroups : "null") + IN_SPACE + (space != null ? space : "null"), e);
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception ex = (Exception)result.left().get();
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof DuplicateException) {
                throw (DuplicateException)((Object)ex);
            }
            if (ex instanceof GroupActionNotPermittedException) {
                throw (GroupActionNotPermittedException)((Object)ex);
            }
            if (ex instanceof EntityException) {
                throw (EntityException)((Object)ex);
            }
        }
        return (Pair)result.getOrNull();
    }

    public void removeGroupMembers(Space space, @Nonnull String spaceGroupCsv, String userNameCsv, String membershipGroupsCsv) throws AuthorizationException, SpaceGroupPatternMismatchException, EntityException, GroupActionNotPermittedException, DuplicateException {
        Exception errorsFound = (Exception)this.fTxTemplate.execute(() -> {
            try {
                this.fSpaceUtil.removeGroupMembers(space, spaceGroupCsv, userNameCsv, membershipGroupsCsv);
                return null;
            }
            catch (EntityException | AuthorizationException | SpaceGroupPatternMismatchException e) {
                LOG.error("Could not remove user(s)/group(s) from group(s): " + spaceGroupCsv + IN_SPACE + (space != null ? space : "null"), e);
                return e;
            }
        });
        if (errorsFound != null) {
            if (errorsFound instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)errorsFound);
            }
            if (errorsFound instanceof DuplicateException) {
                throw (DuplicateException)((Object)errorsFound);
            }
            if (errorsFound instanceof GroupActionNotPermittedException) {
                throw (GroupActionNotPermittedException)((Object)errorsFound);
            }
            if (errorsFound instanceof EntityException) {
                throw (EntityException)((Object)errorsFound);
            }
        }
    }
}

