/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.publicapi.rest;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.AuditTableData;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.java.ao.Query;
import org.apache.log4j.Logger;

@Path(value="/public/audit")
@PublicApi
public class PublicCSUMAuditResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = Logger.getLogger(PublicCSUMAuditResource.class);
    ICSUMActiveObjectService fAos;
    private final UserAccessor fUserAccessor;
    private static final String EMPTY_STRING = "";
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private static final String SPACE = " ";
    private static final String CREATED_DATE = "CREATED_DATE";
    private static final String SPACE_KEY = "SPACE_KEY";
    private static final String CREATED_BY_USER_NAME = "CREATED_BY_USER_NAME";
    private static final String OPERATION_TYPE = "OPERATION_TYPE";
    private static final String GROUP_NAME = "GROUP_NAME";
    private static final String USER_NAME = "USER_NAME";
    private static final String EVENT_OUTCOME = "EVENT_OUTCOME";
    private static final String AUTH_GROUP = "AUTH_GROUP";

    public PublicCSUMAuditResource(@ComponentImport SpaceManager spaceManager, ICSUMActiveObjectService aos, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, PermissionManager permissionManager, UserAccessor userAccessor, ICSUMCacheManager cacheManager) {
        super(spaceManager, permissionUtil, tokenService, permissionManager, cacheManager);
        this.fAos = aos;
        this.fUserAccessor = userAccessor;
    }

    @POST
    @RequiresXsrfCheck
    @Path(value="records")
    @Produces(value={"application/json"})
    public Response getAuditRecords(@QueryParam(value="draw") int draw, @QueryParam(value="start") int start, @QueryParam(value="length") int length, @QueryParam(value="orderCol") int orderCol, @QueryParam(value="orderDir") String orderDirStr, @QueryParam(value="outcomeVal") String outcomeValStr, @QueryParam(value="opTypeVal") String opTypeValStr, @QueryParam(value="creatorVal") String creatorValStr, @QueryParam(value="groupVal") String groupValStr, @QueryParam(value="userVal") String userValStr, @QueryParam(value="spaceKey") String spaceKeyStr) {
        Response response;
        String orderDir = orderDirStr != null ? orderDirStr : EMPTY_STRING;
        String outcomeVal = outcomeValStr != null ? outcomeValStr : EMPTY_STRING;
        String opTypeVal = opTypeValStr != null ? opTypeValStr : EMPTY_STRING;
        String creatorVal = creatorValStr != null ? creatorValStr : EMPTY_STRING;
        String groupVal = groupValStr != null ? groupValStr : EMPTY_STRING;
        String userVal = userValStr != null ? userValStr : EMPTY_STRING;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        Space space = null;
        try {
            if (!spaceKey.equals(EMPTY_STRING)) {
                space = this.getValidSpaceFromKey(spaceKey);
            }
        }
        catch (InvalidSpaceException e) {
            LOG.error((Object)("Invalid Space, could not find Space using spacekey: " + spaceKey), (Throwable)e);
        }
        boolean isPermitted = this.isPermitted(space);
        if (!isPermitted) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            String creatorUserKey = this.getUserKey(creatorVal);
            String contextUserKey = this.getUserKey(userVal);
            Query filtered = this.fAos.getAuditEventQuery(space, creatorUserKey, opTypeVal, groupVal, contextUserKey, outcomeVal);
            Query unfiltered = this.fAos.getAuditEventQuery(space, null, null, null, null, null);
            int recordsTotal = this.fAos.getCountForQuery(CSUMAuditEntity.class, unfiltered);
            int recordsFiltered = this.fAos.getCountForQuery(CSUMAuditEntity.class, filtered);
            CSUMAuditEntity[] pagedEnts = this.fAos.getAuditEvents(filtered.order(this.getOrderClause(orderCol, orderDir)).offset(start).limit(length));
            AuditTableData data = new AuditTableData(pagedEnts, draw, recordsFiltered, recordsTotal, null, this.fUserAccessor);
            response = Response.ok((Object)data).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        return response;
    }

    private String getUserKey(String userName) {
        String ret = userName;
        ConfluenceUser user = this.fUserAccessor.getUserByName(userName);
        if (user != null) {
            ret = String.valueOf(user.getKey());
        }
        return ret;
    }

    private String getOrderClause(int colNumber, String dir) {
        String direction = DESC.equalsIgnoreCase(dir) ? DESC : ASC;
        String column = this.getColumnName(colNumber);
        return column + SPACE + direction;
    }

    private String getColumnName(int colNumber) {
        String column = colNumber == 0 ? CREATED_DATE : (colNumber == 1 ? SPACE_KEY : (colNumber == 2 ? CREATED_BY_USER_NAME : (colNumber == 3 ? OPERATION_TYPE : (colNumber == 4 ? GROUP_NAME : (colNumber == 5 ? USER_NAME : (colNumber == 6 ? EVENT_OUTCOME : AUTH_GROUP))))));
        return column;
    }
}

