/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.CSUMBadGroupEntity;
import com.pluginpeople.confluence.csum.ao.CSUMBadGroupToolStatus;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.CSUMDelegatedGroupEntity;
import com.pluginpeople.confluence.csum.ao.CSUMDlgGrpAuthGrpEntity;
import com.pluginpeople.confluence.csum.ao.CSUMDlgGrpAuthUsrEntity;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.api.beans.DlgGroupBean;
import com.pluginpeople.confluence.csum.ldap.DTObuilder;
import com.pluginpeople.confluence.csum.ldap.LdapItemBean;
import com.pluginpeople.confluence.csum.service.CustomPermissionConstants;
import com.pluginpeople.confluence.csum.service.cache.CSUMConfigCacheEntry;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import com.pluginpeople.confluence.csum.task.TaskType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CSUMActiveObjectServiceImpl
implements ICSUMActiveObjectService {
    public static final String VIA_EVENT_LISTENER = "via-event-listener";
    public static final String SYSTEM = "system";
    public static final String SPACE_KEY = "SPACE_KEY";
    public static final String GROUP_NAME = "GROUP_NAME";
    public static final String CREATED_DATE = "CREATED_DATE < ?";
    public static final String CREATED_DATE_DESC = "CREATED_DATE DESC";
    public static final String SPACE_KEY_QUERY = "SPACE_KEY = ?";
    public static final String GROUP_NAME_QUERY = "GROUP_NAME = ?";
    public static final String DELETED = "Deleted ";
    private static final Logger LOG = Logger.getLogger(CSUMActiveObjectServiceImpl.class);
    private final UserAccessor fUserAccessor;
    private final GroupManager fGm;
    private final ActiveObjects fAo;

    @Autowired
    public CSUMActiveObjectServiceImpl(@ComponentImport ActiveObjects ao, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager gm) {
        this.fAo = ao;
        this.fUserAccessor = userAccessor;
        this.fGm = gm;
        if (this.fAo == null) {
            LOG.error((Object)"CSUM not initialized with ActiveObjects");
        }
    }

    @Override
    public CSUMAuditEntity createAuditEntity(ICSUMActiveObjectService.CSUMOperationType type, ICSUMActiveObjectService.CSUMAuditEventOutcome outcome, Space space, String relatedGroupName, String contextUserKey, @Nonnull String adminUser, String summary, String comment, String authGroup) {
        ConfluenceUser user;
        String adminUserKey = !adminUser.equalsIgnoreCase(SYSTEM) ? ((user = this.fUserAccessor.getUserByName(adminUser)) != null ? user.getKey().getStringValue() : "null") : SYSTEM;
        return (CSUMAuditEntity)this.fAo.create(CSUMAuditEntity.class, new DBParam[]{new DBParam("OPERATION_TYPE", (Object)type.name()), new DBParam("EVENT_OUTCOME", (Object)outcome.name()), new DBParam(SPACE_KEY, (Object)(space != null ? space.getLowerKey() : null)), new DBParam(GROUP_NAME, (Object)relatedGroupName), new DBParam("CONTEXT_USER_KEY", (Object)contextUserKey), new DBParam("SUMMARY", (Object)summary), new DBParam("COMMENT", (Object)comment), new DBParam("CREATED_BY_USER_KEY", (Object)adminUserKey), new DBParam("CREATED_DATE", (Object)new Timestamp(System.currentTimeMillis())), new DBParam("AUTH_GROUP", (Object)authGroup)});
    }

    @Override
    public void deleteLatestAuditEntity(String groupName) {
        CSUMAuditEntity[] entities;
        ArrayList<Timestamp> timestamps = new ArrayList<Timestamp>();
        Query query = Query.select().where(GROUP_NAME_QUERY, new Object[]{groupName});
        for (CSUMAuditEntity csumAuditEntity : entities = this.getAuditEvents(query)) {
            timestamps.add(csumAuditEntity.getCreatedDate());
        }
        Timestamp latestTime = null;
        for (Timestamp timestamp : timestamps) {
            if (latestTime != null && !latestTime.after(timestamp)) continue;
            latestTime = timestamp;
        }
        Query timeQuery = Query.select().where("CREATED_DATE = ?", new Object[]{latestTime});
        this.fAo.delete((RawEntity[])this.getAuditEvents(timeQuery));
    }

    @Override
    public int deleteAuditEntities(Space space, int days) {
        int deleted = -1;
        if (this.getConfig().isAllowAdminDeleteAudits()) {
            deleted = 0;
            Timestamp since = new Timestamp(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(days));
            Query query = space != null ? Query.select().where("SPACE_KEY = ? AND CREATED_DATE < ?", new Object[]{space.getLowerKey(), since}) : Query.select().where(CREATED_DATE, new Object[]{since});
            int count = this.fAo.count(CSUMAuditEntity.class, query);
            if (count > 0) {
                int i;
                LOG.debug((Object)("Found " + count + " event records older than " + days + " to purge"));
                try {
                    LOG.info((Object)("Deleting old audit events for space [" + (space != null ? space.getLowerKey() : "") + "] using unquoted fields"));
                    i = this.fAo.deleteWithSQL(CSUMAuditEntity.class, CREATED_DATE, new Object[]{since});
                }
                catch (Exception e) {
                    LOG.info((Object)("That didnt work, so deleting old audit events for space [" + (space != null ? space.getLowerKey() : "") + "] using quoted fields"));
                    i = this.fAo.deleteWithSQL(CSUMAuditEntity.class, "\"CREATED_DATE\" < ?", new Object[]{since});
                }
                LOG.debug((Object)(DELETED + i + " audit events for space: " + (space != null ? space.getLowerKey() : "")));
                deleted = i;
            }
        }
        return deleted;
    }

    @Override
    public int deleteAllAuditEntities(int days) {
        int deleted = 0;
        Timestamp since = new Timestamp(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(days));
        Query hintQuery = Query.select().where(CREATED_DATE, new Object[]{since});
        int count = this.fAo.count(CSUMAuditEntity.class, hintQuery);
        if (count > 0) {
            int i;
            try {
                LOG.info((Object)"Deleting ALL old audit events using unquoted fields");
                i = this.fAo.deleteWithSQL(CSUMAuditEntity.class, CREATED_DATE, new Object[]{since});
            }
            catch (Exception e) {
                LOG.info((Object)"That didnt work, so deleting ALL old audit events using quoted fields");
                i = this.fAo.deleteWithSQL(CSUMAuditEntity.class, "\"CREATED_DATE\" < ?", new Object[]{since});
            }
            LOG.debug((Object)(DELETED + i + " audit events over all spaces"));
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteAllAuditEntitiesForSpace(Space space) {
        int eventDeletedCount = 0;
        Query hintQuery = Query.select().where(SPACE_KEY_QUERY, new Object[]{space.getLowerKey()});
        int count = this.fAo.count(CSUMAuditEntity.class, hintQuery);
        if (count > 0) {
            try {
                LOG.info((Object)("Deleting ALL audit events for Space: " + space.getLowerKey() + " using unquoted fields"));
                eventDeletedCount = this.fAo.deleteWithSQL(CSUMAuditEntity.class, SPACE_KEY_QUERY, new Object[]{space.getLowerKey()});
            }
            catch (Exception e) {
                LOG.info((Object)"Didn't work, attempting to delete using quoted fields");
                eventDeletedCount = this.fAo.deleteWithSQL(CSUMAuditEntity.class, "\"SPACE_KEY\"  = ?", new Object[]{space.getLowerKey()});
            }
            finally {
                if (eventDeletedCount > 0) {
                    LOG.info((Object)(DELETED + eventDeletedCount + " audit records for Space: " + space.getLowerKey()));
                } else {
                    LOG.info((Object)("No audit records found for Space: " + space.getLowerKey()));
                }
            }
        }
        return eventDeletedCount;
    }

    @Override
    public CSUMAuditEntity[] getAuditEvents(Space space, int days) {
        Timestamp since = new Timestamp(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(days));
        Query query = space != null && space.getLowerKey() != null ? Query.select().where("SPACE_KEY = ? AND CREATED_DATE > ?", new Object[]{space.getLowerKey(), since}).order(CREATED_DATE_DESC) : Query.select().where("CREATED_DATE > ?", new Object[]{since}).order(CREATED_DATE_DESC);
        CSUMAuditEntity[] ret = (CSUMAuditEntity[])this.fAo.find(CSUMAuditEntity.class, query);
        if (ret.length == 0) {
            ret = null;
        }
        return ret;
    }

    @Override
    public Query getAuditEventQuery(Space space, String creatorVal, String opTypeVal, String groupVal, String userVal, String outcomeVal) {
        Query query = Query.select();
        LinkedHashMap<String, String> wheres = new LinkedHashMap<String, String>();
        if (space != null) {
            wheres.put(SPACE_KEY_QUERY, space.getLowerKey());
        }
        if (creatorVal != null && !creatorVal.isEmpty()) {
            wheres.put("CREATED_BY_USER_KEY = ?", creatorVal);
        }
        if (opTypeVal != null && !opTypeVal.isEmpty()) {
            wheres.put("OPERATION_TYPE = ?", opTypeVal);
        }
        if (groupVal != null && !groupVal.isEmpty()) {
            wheres.put(GROUP_NAME_QUERY, groupVal);
        }
        if (userVal != null && !userVal.isEmpty()) {
            wheres.put("CONTEXT_USER_KEY = ?", userVal);
        }
        if (outcomeVal != null && !outcomeVal.isEmpty()) {
            wheres.put("EVENT_OUTCOME = ?", outcomeVal);
        }
        if (!wheres.isEmpty()) {
            String whereClause = String.join((CharSequence)" AND ", wheres.keySet());
            query = query.where(whereClause, wheres.values().toArray());
        }
        return query;
    }

    @Override
    public int getCountForQuery(Class<? extends RawEntity<Integer>> clazz, Query query) {
        return this.fAo.count(clazz, query);
    }

    @Override
    public CSUMAuditEntity[] getAuditEvents(Query query) {
        return (CSUMAuditEntity[])this.fAo.find(CSUMAuditEntity.class, query);
    }

    @Override
    public CSUMAuditEntity[] getAuditEvents(Space space) {
        Query query = Query.select().where(SPACE_KEY_QUERY, new Object[]{space.getLowerKey()}).order(CREATED_DATE_DESC);
        CSUMAuditEntity[] ret = (CSUMAuditEntity[])this.fAo.find(CSUMAuditEntity.class, query);
        if (ret.length == 0) {
            ret = null;
        }
        return ret;
    }

    @Override
    public CSUMConfigEntity getConfig() {
        CSUMConfigEntity config;
        CSUMConfigEntity[] all = (CSUMConfigEntity[])this.fAo.find(CSUMConfigEntity.class);
        if (all.length == 0) {
            config = this.createDefaultConfig();
        } else {
            config = all[0];
            boolean saveNeeded = false;
            if (config.getGroupFilter() == null) {
                config.setGroupFilter("none");
                saveNeeded = true;
            }
            if (config.getDisabledUserHandling() == null) {
                config.setDisabledUserHandling("show");
                saveNeeded = true;
            }
            if (saveNeeded) {
                config.save();
            }
        }
        return config;
    }

    private CSUMConfigEntity createDefaultConfig() {
        LOG.debug((Object)"Creating default config in ActiveObjects");
        CSUMConfigEntity config = (CSUMConfigEntity)this.fAo.create(CSUMConfigEntity.class, new DBParam[0]);
        config.setPluginDown(true);
        config.setPluginDownMsg("CSUM is down right now");
        config.setGroupActionsPermitted(true);
        config.setGroupAddRemovePermitted(true);
        config.setRemoveUserFromPermGrpPerm(false);
        config.setDlgGrpActPerm(false);
        config.setUserSearchEnabled(true);
        config.setMaxUserIDsLimit(0);
        config.setMaxGroupIDsLimit(0);
        config.setAllowAdminDeleteAudits(true);
        config.setUserManagerLocation(CustomPermissionConstants.MANAGER_LOCATIONS.Confluence.name());
        config.setGroupPrefixPattern("SPACEKEY-");
        config.setGroupSuffixPattern("");
        config.setPersonalSpaceAllowed(false);
        config.setJiraRestUrl(null);
        config.setJiraRestUrl(null);
        config.setJiraRestUsername(null);
        config.setAutoJoinGroups(null);
        config.setDisabledUserHandling("show");
        config.setGroupFilter("none");
        config.setGroupFilterBehavior(false);
        config.save();
        this.fAo.flushAll();
        return config;
    }

    @Override
    public ICachedConfig getCachedConfig() {
        CSUMConfigEntity entity = this.getConfig();
        CSUMConfigCacheEntry cachedConfig = new CSUMConfigCacheEntry();
        cachedConfig.setGroupActionsPermitted(entity.isGroupActionsPermitted());
        cachedConfig.setGroupAddRemovePermitted(entity.isGroupAddRemovePermitted());
        cachedConfig.setRemoveUserFromPermGrpPerm(entity.isRemoveUserFromPermGrpPerm());
        cachedConfig.setDlgGrpActPerm(entity.isDlgGrpActPerm());
        cachedConfig.setGroupPrefixPattern(entity.getGroupPrefixPattern());
        cachedConfig.setGroupSuffixPattern(entity.getGroupSuffixPattern());
        cachedConfig.setJiraRestPassword(entity.getJiraRestPassword());
        cachedConfig.setJiraRestUrl(entity.getJiraRestUrl());
        cachedConfig.setJiraRestUsername(entity.getJiraRestUsername());
        cachedConfig.setMaxGroupIDsLimit(entity.getMaxGroupIDsLimit());
        cachedConfig.setMaxUserIDsLimit(entity.getMaxUserIDsLimit());
        cachedConfig.setPersonalSpaceAllowed(entity.isPersonalSpaceAllowed());
        cachedConfig.setPluginDown(entity.isPluginDown());
        cachedConfig.setPluginDownMsg(entity.getPluginDownMsg());
        cachedConfig.setProviderType(entity.getProviderType());
        cachedConfig.setUserSearchEnabled(entity.isUserSearchEnabled());
        cachedConfig.setCreateUsersEnabled(entity.isCreateUsersEnabled());
        cachedConfig.setUserManagerLocation(entity.getUserManagerLocation());
        cachedConfig.setAutoJoinGroups(entity.getAutoJoinGroups());
        cachedConfig.setSelectDirectories(entity.isSelectDirectories());
        cachedConfig.setUserDirectories(entity.getUserDirectories());
        cachedConfig.setExtLdapDirectories(entity.getExtLdapDirectories());
        cachedConfig.setDisabledUserHandling(entity.getDisabledUserHandling());
        cachedConfig.setGroupFilter(entity.getGroupFilter() != null ? entity.getGroupFilter() : "none");
        cachedConfig.setGroupFilterBehavior(entity.getGroupFilterBehavior());
        cachedConfig.setFullNameFormat(entity.getFullNameFormat());
        cachedConfig.setHideUserOperations(entity.isHideUserOperations());
        cachedConfig.setHideGroupOperations(entity.isHideGroupOperations());
        cachedConfig.setAllowAdminDeleteAudits(entity.isAllowAdminDeleteAudits());
        cachedConfig.setGroupPageProcessing(entity.isGroupPageProcessing());
        cachedConfig.setUserPageProcessing(entity.isUserPageProcessing());
        cachedConfig.setIgnorePermissionCheck(entity.isIgnorePermissionCheck());
        return cachedConfig;
    }

    @Override
    public CSUMBadGroupEntity createBadGroupEnt(String groupName, String spaceKey) {
        return (CSUMBadGroupEntity)this.fAo.create(CSUMBadGroupEntity.class, new DBParam[]{new DBParam(GROUP_NAME, (Object)groupName), new DBParam(SPACE_KEY, (Object)spaceKey)});
    }

    @Override
    public void deleteAllBadGroupEnts() {
        this.fAo.deleteWithSQL(CSUMBadGroupEntity.class, null, new Object[0]);
        this.fAo.flushAll();
    }

    @Override
    public int getBadGroupCount() {
        return this.fAo.count(CSUMBadGroupEntity.class);
    }

    @Override
    public void deleteBadGroupEnt(CSUMBadGroupEntity ent) {
        this.fAo.delete(new RawEntity[]{ent});
    }

    @Override
    public CSUMBadGroupEntity[] getBadGroupEnts(int size) {
        return (CSUMBadGroupEntity[])this.fAo.find(CSUMBadGroupEntity.class, Query.select().limit(size));
    }

    @Override
    public CSUMBadGroupEntity[] getAllBadGroupEnts() {
        return (CSUMBadGroupEntity[])this.fAo.find(CSUMBadGroupEntity.class);
    }

    @Override
    public CSUMBadGroupToolStatus getBadGroupToolStatus() {
        CSUMBadGroupToolStatus[] statusEnts = (CSUMBadGroupToolStatus[])this.fAo.find(CSUMBadGroupToolStatus.class);
        if (statusEnts.length > 0) {
            return statusEnts[0];
        }
        return (CSUMBadGroupToolStatus)this.fAo.create(CSUMBadGroupToolStatus.class, new DBParam[]{new DBParam("STATUS", (Object)"IDLE")});
    }

    @Override
    public CSUMTaskEntity createTaskEntity(TaskType taskType, String spaceKey, String user) {
        return (CSUMTaskEntity)this.fAo.create(CSUMTaskEntity.class, new DBParam[]{new DBParam("STATUS", (Object)"uploading"), new DBParam("TASK_TYPE", (Object)taskType.getName()), new DBParam(SPACE_KEY, (Object)spaceKey), new DBParam("INITIATING_USER", (Object)user), new DBParam("SUBMITTED", (Object)Timestamp.valueOf(LocalDateTime.now()))});
    }

    @Override
    public CSUMTaskEntity getTaskEntity(String filePath) {
        return null;
    }

    @Override
    public CSUMTaskEntity getTaskEntity(int id) {
        return (CSUMTaskEntity)this.fAo.get(CSUMTaskEntity.class, (Object)id);
    }

    @Override
    public CSUMTaskEntity[] getTaskEntitiesForSpace(String spaceKey) {
        Query query = Query.select().where(SPACE_KEY_QUERY, new Object[]{spaceKey});
        return (CSUMTaskEntity[])this.fAo.find(CSUMTaskEntity.class, query);
    }

    @Override
    public CSUMTaskEntity[] getTaskEntitiesForUser(String user) {
        Query query = Query.select().where("INITIATING_USER = ?", new Object[]{user});
        return (CSUMTaskEntity[])this.fAo.find(CSUMTaskEntity.class, query);
    }

    @Override
    public void delete(CSUMTaskEntity taskEntity) throws IOException {
        File related;
        String path = taskEntity.getFilePath();
        if (path != null && (related = new File(path)).exists()) {
            Files.delete(related.toPath());
        }
        this.fAo.delete(new RawEntity[]{taskEntity});
    }

    @Override
    public void delete(CSUMTaskEntity[] taskEntities) {
        for (CSUMTaskEntity taskEntity : taskEntities) {
            try {
                this.delete(taskEntity);
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }

    @Override
    public void deleteTasksSubmittedBefore(LocalDateTime time) {
        Timestamp since = Timestamp.valueOf(time);
        Query query = Query.select().where("SUBMITTED < ?", new Object[]{since});
        CSUMTaskEntity[] entities = (CSUMTaskEntity[])this.fAo.find(CSUMTaskEntity.class, query);
        if (entities.length > 0) {
            this.delete(entities);
        }
    }

    @Override
    public CSUMLdapConfigEntity createLdapConfig() {
        CSUMLdapConfigEntity[] o = (CSUMLdapConfigEntity[])this.fAo.find(CSUMLdapConfigEntity.class);
        if (o.length == 0) {
            CSUMLdapConfigEntity newConf = (CSUMLdapConfigEntity)this.fAo.create(CSUMLdapConfigEntity.class, new DBParam[0]);
            newConf.setHostname("activedirector");
            newConf.setBaseDN("DC=DEV,DC=PPL,DC=COM");
            newConf.setAdditionalUserDN("cn=Users");
            newConf.setObjectClass("user");
            newConf.setUsernameAttr("sAMAccountName");
            newConf.setUserFirstNameAttr("givenName");
            newConf.setUserLastNameAttr("sn");
            newConf.setUserDisplayNameAttr("displayName");
            newConf.setUserEmailAttr("mail");
            newConf.setObjectFilter("(mail=*)");
            newConf.setSearchTimeout(5000);
            newConf.setConnectionTimeout(1000);
            newConf.save();
            return newConf;
        }
        CSUMLdapConfigEntity newConf = o[0];
        return newConf;
    }

    @Override
    public CSUMLdapConfigEntity[] getLdapConfigs() {
        return (CSUMLdapConfigEntity[])this.fAo.find(CSUMLdapConfigEntity.class);
    }

    @Override
    public CSUMLdapConfigEntity getLdapConfigById(int id) {
        return (CSUMLdapConfigEntity)this.fAo.get(CSUMLdapConfigEntity.class, (Object)id);
    }

    @Override
    public void updateLdapConfig(int id, LdapItemBean conf) {
        CSUMLdapConfigEntity e = this.getLdapConfigById(id);
        e.setAdditionalGroupDN(conf.getAdditionalGroupDN());
        e.setAdditionalParams(conf.getAdditionalParams());
        e.setAdditionalUserDN(conf.getAdditionalUserDN());
        e.setBaseDN(conf.getBaseDN());
        e.setConnectionTimeout(conf.getConnectionTimeout());
        e.setGroupMembershipAttr(conf.getGroupMembershipAttr());
        e.setHostname(conf.getHostname());
        e.setLdapConfigName(conf.getLdapConfigName());
        e.setObjectClass(conf.getObjectClass());
        e.setObjectFilter(conf.getObjectFilter());
        e.setPassword(conf.getPassword());
        e.setPort(conf.getPort());
        e.setResultsPerPage(conf.getResultsPerPage());
        e.setSearchTimeout(conf.getSearchTimeout());
        e.setTestLookupUsername(conf.getTestLookupUsername());
        e.setUsePagedResults(conf.isUsePagedResults());
        e.setUsernameAttr(conf.getUsernameAttr());
        e.setUserDisplayNameAttr(conf.getUserDisplayNameAttr());
        e.setUserEmailAttr(conf.getUserEmailAttr());
        e.setUserFirstNameAttr(conf.getUserFirstNameAttr());
        e.setUserLastNameAttr(conf.getUserLastNameAttr());
        e.setUsername(conf.getUsername());
        e.setUserPasswordAttr(conf.getPassword());
        e.setUserRDNAttr(conf.getUserRDNAttr());
        e.setUseSSL(conf.isUseSSL());
        e.setValidateOnSave(conf.getValidateOnSave());
        e.save();
    }

    @Override
    public void delete(CSUMLdapConfigEntity e) {
        this.fAo.delete(new RawEntity[]{e});
    }

    @Override
    public LdapDetailsDTO getLdapDto(CSUMLdapConfigEntity configEntitiy) {
        LdapDetailsDTO dto = new LdapDetailsDTO();
        DTObuilder.updateDto(configEntitiy, dto);
        return dto;
    }

    @Override
    public CSUMLdapConfigEntity createLdapConfig(LdapItemBean ldapItemBean) {
        CSUMLdapConfigEntity e = (CSUMLdapConfigEntity)this.fAo.create(CSUMLdapConfigEntity.class, new DBParam[0]);
        e.setSortOrder(ldapItemBean.getSortOrder());
        e.setAdditionalGroupDN(ldapItemBean.getAdditionalGroupDN());
        e.setAdditionalParams(ldapItemBean.getAdditionalParams());
        e.setAdditionalUserDN(ldapItemBean.getAdditionalUserDN());
        e.setBaseDN(ldapItemBean.getBaseDN());
        e.setConnectionTimeout(ldapItemBean.getConnectionTimeout());
        e.setGroupMembershipAttr(ldapItemBean.getGroupMembershipAttr());
        e.setHostname(ldapItemBean.getHostname());
        e.setLdapConfigName(ldapItemBean.getLdapConfigName());
        e.setObjectClass(ldapItemBean.getObjectClass());
        e.setObjectFilter(ldapItemBean.getObjectFilter());
        e.setPassword(ldapItemBean.getPassword());
        e.setPort(ldapItemBean.getPort());
        e.setResultsPerPage(ldapItemBean.getResultsPerPage());
        e.setSearchTimeout(ldapItemBean.getSearchTimeout());
        e.setTestLookupUsername(ldapItemBean.getTestLookupUsername());
        e.setUsePagedResults(ldapItemBean.isUsePagedResults());
        e.setUsernameAttr(ldapItemBean.getUsernameAttr());
        e.setUserDisplayNameAttr(ldapItemBean.getUserDisplayNameAttr());
        e.setUserEmailAttr(ldapItemBean.getUserEmailAttr());
        e.setUserFirstNameAttr(ldapItemBean.getUserFirstNameAttr());
        e.setUserLastNameAttr(ldapItemBean.getUserLastNameAttr());
        e.setUsername(ldapItemBean.getUsername());
        e.setUserPasswordAttr(ldapItemBean.getPassword());
        e.setUserRDNAttr(ldapItemBean.getUserRDNAttr());
        e.setUseSSL(ldapItemBean.isUseSSL());
        e.setValidateOnSave(ldapItemBean.getValidateOnSave());
        e.save();
        return e;
    }

    @Override
    public CSUMLdapConfigEntity copyLdapConfig(int configId) {
        CSUMLdapConfigEntity toPopulate = null;
        CSUMLdapConfigEntity toCopy = this.getLdapConfigById(configId);
        if (toCopy != null) {
            toPopulate = (CSUMLdapConfigEntity)this.fAo.create(CSUMLdapConfigEntity.class, new DBParam[0]);
            toPopulate.setLdapConfigName("Copy of " + toCopy.getLdapConfigName());
            toPopulate.setHostname(toCopy.getHostname());
            toPopulate.setPort(toCopy.getPort());
            toPopulate.setUseSSL(toCopy.isUseSSL());
            toPopulate.setUsername(toCopy.getUsername());
            toPopulate.setPassword(toCopy.getPassword());
            toPopulate.setTestLookupUsername(toCopy.getTestLookupUsername());
            toPopulate.setBaseDN(toCopy.getBaseDN());
            toPopulate.setAdditionalUserDN(toCopy.getAdditionalUserDN());
            toPopulate.setAdditionalGroupDN(toCopy.getAdditionalGroupDN());
            toPopulate.setObjectClass(toCopy.getObjectClass());
            toPopulate.setObjectFilter(toCopy.getObjectFilter());
            toPopulate.setUsernameAttr(toCopy.getUsernameAttr());
            toPopulate.setGroupMembershipAttr(toCopy.getGroupMembershipAttr());
            toPopulate.setUserRDNAttr(toCopy.getUserRDNAttr());
            toPopulate.setUserFirstNameAttr(toCopy.getUserFirstNameAttr());
            toPopulate.setUserLastNameAttr(toCopy.getUserLastNameAttr());
            toPopulate.setUserDisplayNameAttr(toCopy.getUserDisplayNameAttr());
            toPopulate.setUserEmailAttr(toCopy.getUserEmailAttr());
            toPopulate.setUserPasswordAttr(toCopy.getUserPasswordAttr());
            toPopulate.setUsePagedResults(toCopy.getUsePagedResults());
            toPopulate.setResultsPerPage(toCopy.getResultsPerPage());
            toPopulate.setSearchTimeout(toCopy.getSearchTimeout());
            toPopulate.setConnectionTimeout(toCopy.getConnectionTimeout());
            toPopulate.setAdditionalParams(toCopy.getAdditionalParams());
            toPopulate.setValidateOnSave(toCopy.getValidateOnSave());
            toPopulate.save();
        }
        return toPopulate;
    }

    @Override
    public CSUMDelegatedGroupEntity createDelegatedGroup(String groupName) {
        return (CSUMDelegatedGroupEntity)this.fAo.create(CSUMDelegatedGroupEntity.class, new DBParam[]{new DBParam(GROUP_NAME, (Object)groupName)});
    }

    @Override
    public boolean deleteDelegatedGroup(CSUMDelegatedGroupEntity dlgGroup, ConfluenceUser authenticatedUser, String origin) {
        ICSUMActiveObjectService.CSUMOperationType removeDlgGroup;
        String msg;
        boolean deleted = false;
        String dlgGroupName = dlgGroup.getGroupName();
        CSUMDlgGrpAuthUsrEntity[] authorizedUsers = dlgGroup.getAuthUsers();
        CSUMDlgGrpAuthGrpEntity[] authorizedGroups = dlgGroup.getAuthGroups();
        for (CSUMDlgGrpAuthUsrEntity authUserEntity : authorizedUsers) {
            ICSUMActiveObjectService.CSUMOperationType deauthUserOperation;
            String authUserKey = authUserEntity.getUserKey();
            this.fAo.delete(new RawEntity[]{authUserEntity});
            if (origin.equalsIgnoreCase(VIA_EVENT_LISTENER)) {
                msg = "Authorized user de-authorized by system";
                deauthUserOperation = ICSUMActiveObjectService.CSUMOperationType.deauthUserBySystem;
            } else {
                msg = "Authorized user de-authorized";
                deauthUserOperation = ICSUMActiveObjectService.CSUMOperationType.deauthorizeUser;
            }
            this.createAuditEntity(deauthUserOperation, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, dlgGroupName, authUserKey, authenticatedUser.getName(), msg, null, null);
            LOG.debug((Object)msg);
        }
        for (CSUMDlgGrpAuthGrpEntity authGroupEntity : authorizedGroups) {
            ICSUMActiveObjectService.CSUMOperationType deauthGroupOperation;
            this.fAo.delete(new RawEntity[]{authGroupEntity});
            String groupName = authGroupEntity.getGroupName();
            if (origin.equalsIgnoreCase(VIA_EVENT_LISTENER)) {
                msg = "Group de-authorized by system: " + groupName + " from dlg group: " + dlgGroupName;
                deauthGroupOperation = ICSUMActiveObjectService.CSUMOperationType.deauthGroupBySystem;
            } else {
                msg = "Group de-authorized: " + groupName + " from dlg group: " + dlgGroupName;
                deauthGroupOperation = ICSUMActiveObjectService.CSUMOperationType.deauthorizeGroup;
            }
            this.createAuditEntity(deauthGroupOperation, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, dlgGroupName, null, authenticatedUser.getName(), msg, null, groupName);
            LOG.debug((Object)msg);
        }
        this.fAo.delete(new RawEntity[]{dlgGroup});
        String groupName = dlgGroup.getGroupName();
        if (origin.equalsIgnoreCase(VIA_EVENT_LISTENER)) {
            msg = "Delegated group removed by system: " + groupName;
            removeDlgGroup = ICSUMActiveObjectService.CSUMOperationType.removeDlgGroupBySys;
        } else {
            msg = "Delegated group removed: " + groupName;
            removeDlgGroup = ICSUMActiveObjectService.CSUMOperationType.removeDelegatedGroup;
        }
        this.createAuditEntity(removeDlgGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, groupName, null, authenticatedUser.getName(), msg, null, null);
        LOG.debug((Object)msg);
        if (this.getDelegatedGroup(dlgGroup.getID()) == null) {
            deleted = true;
        }
        return deleted;
    }

    @Override
    public boolean isDlgGroup(String groupName) throws DuplicateException {
        return this.getDelegatedGroup(groupName) != null;
    }

    @Override
    public CSUMDelegatedGroupEntity[] getDelegatedGroups() {
        return (CSUMDelegatedGroupEntity[])this.fAo.find(CSUMDelegatedGroupEntity.class);
    }

    @Override
    public CSUMDelegatedGroupEntity getDelegatedGroup(int dlgGroupId) {
        CSUMDelegatedGroupEntity matches = (CSUMDelegatedGroupEntity)this.fAo.get(CSUMDelegatedGroupEntity.class, (Object)dlgGroupId);
        CSUMDelegatedGroupEntity ret = null;
        if (matches != null) {
            ret = matches;
        }
        return ret;
    }

    @Override
    public CSUMDelegatedGroupEntity getDelegatedGroup(String name) throws DuplicateException {
        CSUMDelegatedGroupEntity entity = null;
        Query query = Query.select().where(GROUP_NAME_QUERY, new Object[]{name});
        CSUMDelegatedGroupEntity[] group = (CSUMDelegatedGroupEntity[])this.fAo.find(CSUMDelegatedGroupEntity.class, query);
        if (group.length == 1) {
            entity = group[0];
        } else if (group.length > 1) {
            for (CSUMDelegatedGroupEntity groupEntity : group) {
                this.deleteDelegatedGroup(groupEntity, AuthenticatedUserThreadLocal.get(), "");
            }
            throw new DuplicateException(DELETED + group.length + " duplicates of delegated group " + name);
        }
        return entity;
    }

    @Override
    public CSUMDlgGrpAuthUsrEntity createDlgGrpAuthUser(DlgGroupBean groupBean, String userKey) {
        CSUMDlgGrpAuthUsrEntity ret = (CSUMDlgGrpAuthUsrEntity)this.fAo.create(CSUMDlgGrpAuthUsrEntity.class, new DBParam[]{new DBParam("USER_KEY", (Object)userKey)});
        CSUMDelegatedGroupEntity groupEntity = this.getDelegatedGroup(groupBean.getDlgGroupEntityId());
        ret.setGroup(groupEntity);
        ret.save();
        return ret;
    }

    @Override
    public void deleteDlgGrpAuthUser(CSUMDlgGrpAuthUsrEntity entity) {
        this.fAo.delete(new RawEntity[]{entity});
    }

    @Override
    public CSUMDlgGrpAuthUsrEntity getDlgGrpAuthUserByKeyAndGroupId(UserKey userKey, int groupId) throws DuplicateException {
        String userKeyStr = userKey.getStringValue();
        Query query = Query.select().where("USER_KEY = ? AND GROUP_ID = ?", new Object[]{userKeyStr, groupId});
        CSUMDlgGrpAuthUsrEntity[] user = (CSUMDlgGrpAuthUsrEntity[])this.fAo.find(CSUMDlgGrpAuthUsrEntity.class, query);
        if (user.length > 1) {
            throw new DuplicateException(user[0] + "exists in the AUTH database more than once");
        }
        CSUMDlgGrpAuthUsrEntity ret = user.length == 0 ? null : user[0];
        return ret;
    }

    @Override
    public CSUMDlgGrpAuthUsrEntity[] getDupAuthUsersByKey(String userKey) {
        Query query = Query.select().where("USER_KEY = ?", new Object[]{userKey});
        return (CSUMDlgGrpAuthUsrEntity[])this.fAo.find(CSUMDlgGrpAuthUsrEntity.class, query);
    }

    @Override
    public void delete(CSUMDlgGrpAuthUsrEntity authUserEntity) {
        this.fAo.delete(new RawEntity[]{authUserEntity});
    }

    @Override
    public CSUMDlgGrpAuthGrpEntity createDlgGrpAuthGrp(String groupName, int dlgGroupId) {
        return (CSUMDlgGrpAuthGrpEntity)this.fAo.create(CSUMDlgGrpAuthGrpEntity.class, new DBParam[]{new DBParam(GROUP_NAME, (Object)groupName), new DBParam("GROUP_ID", (Object)dlgGroupId)});
    }

    @Override
    public void deleteDlgGrpAuthGrp(CSUMDlgGrpAuthGrpEntity entity) {
        this.fAo.delete(new RawEntity[]{entity});
    }

    @Override
    public CSUMDlgGrpAuthGrpEntity[] getDlgGrpAuthGrps(String dlgGroup) {
        CSUMDlgGrpAuthGrpEntity[] groups = null;
        Query query = Query.select().where(GROUP_NAME_QUERY, new Object[]{dlgGroup});
        CSUMDelegatedGroupEntity[] group = (CSUMDelegatedGroupEntity[])this.fAo.find(CSUMDelegatedGroupEntity.class, query);
        if (group.length > 0) {
            int groupId = group[0].getID();
            query = Query.select().where("GROUP_ID = ?", new Object[]{groupId});
            groups = (CSUMDlgGrpAuthGrpEntity[])this.fAo.find(CSUMDlgGrpAuthGrpEntity.class, query);
        }
        return groups;
    }

    @Override
    public CSUMDlgGrpAuthGrpEntity[] getDlgGrpAuthGrp(String authGroup, int dlgGroupId) throws DuplicateException {
        Query query = Query.select().where("GROUP_NAME = ? AND GROUP_ID = ?", new Object[]{authGroup, dlgGroupId});
        CSUMDlgGrpAuthGrpEntity[] group = (CSUMDlgGrpAuthGrpEntity[])this.fAo.find(CSUMDlgGrpAuthGrpEntity.class, query);
        if (group.length > 1) {
            throw new DuplicateException(group[0] + "exists in the AUTH database more than once");
        }
        return group;
    }

    @Override
    public void deleteAuthorizedGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.fAo.deleteWithSQL(CSUMDlgGrpAuthGrpEntity.class, GROUP_NAME_QUERY, new Object[]{groupName});
        String msg = "Group " + groupName + " was unauthorized by system";
        this.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.deauthGroupBySystem, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, groupName, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, groupName);
        LOG.debug((Object)msg);
    }

    @Override
    public CSUMDelegatedGroupEntity[] getDelegatedGroupsForUser(ConfluenceUser user) throws EntityException {
        CSUMDelegatedGroupEntity[] allDlgGroups;
        HashSet<CSUMDelegatedGroupEntity> matchedDelegatedGroups = new HashSet<CSUMDelegatedGroupEntity>();
        for (CSUMDelegatedGroupEntity dlgGroupEntity : allDlgGroups = this.getDelegatedGroups()) {
            CSUMDlgGrpAuthGrpEntity[] authGroups;
            CSUMDlgGrpAuthUsrEntity[] authUsers;
            for (CSUMDlgGrpAuthUsrEntity authUserEntity : authUsers = dlgGroupEntity.getAuthUsers()) {
                UserKey key = new UserKey(authUserEntity.getUserKey());
                if (!key.equals((Object)user.getKey())) continue;
                matchedDelegatedGroups.add(dlgGroupEntity);
            }
            for (CSUMDlgGrpAuthGrpEntity authGroupEntity : authGroups = dlgGroupEntity.getAuthGroups()) {
                Group group = this.fGm.getGroup(authGroupEntity.getGroupName());
                if (group == null || !this.fGm.hasMembership(group, (User)user)) continue;
                matchedDelegatedGroups.add(dlgGroupEntity);
            }
        }
        CSUMDelegatedGroupEntity[] groupEntityArr = new CSUMDelegatedGroupEntity[matchedDelegatedGroups.size()];
        matchedDelegatedGroups.toArray(groupEntityArr);
        return groupEntityArr;
    }

    @Override
    public int getDlgGroupId(String groupName) {
        Query query = Query.select().where(GROUP_NAME_QUERY, new Object[]{groupName});
        CSUMDelegatedGroupEntity[] group = (CSUMDelegatedGroupEntity[])this.fAo.find(CSUMDelegatedGroupEntity.class, query);
        return group[0].getID();
    }

    @Override
    public CSUMDlgGrpAuthUsrEntity[] getAllAuthUsers() {
        Query query = Query.select();
        return (CSUMDlgGrpAuthUsrEntity[])this.fAo.find(CSUMDlgGrpAuthUsrEntity.class, query);
    }

    @Override
    public CSUMDlgGrpAuthGrpEntity[] getAllAuthGroups() {
        Query query = Query.select();
        return (CSUMDlgGrpAuthGrpEntity[])this.fAo.find(CSUMDlgGrpAuthGrpEntity.class, query);
    }

    @Override
    public CSUMTaskEntity[] queryRenameTaskForGroup(String originalGroupName, String newGroupName, String spaceKey) {
        Query query = Query.select().where("SPACE_KEY = ? AND TASK_TYPE = ? AND ( STATUS = ? OR STATUS = ? OR STATUS = ? ) AND ( ORIGINAL_GROUP_NAME = ? OR ORIGINAL_GROUP_NAME = ? OR NEW_GROUP_NAME = ? OR NEW_GROUP_NAME = ? )", new Object[]{spaceKey, TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER.getName(), "running", "queued", "uploading", originalGroupName, newGroupName, originalGroupName, newGroupName});
        return (CSUMTaskEntity[])this.fAo.find(CSUMTaskEntity.class, query);
    }

    @Override
    public void flush(Class<CSUMTaskEntity> clazz, int id) {
        CSUMTaskEntity e = (CSUMTaskEntity)this.fAo.get(clazz, (Object)id);
        this.fAo.flush(new RawEntity[]{e});
    }

    @Override
    public void createAuditEntityForSpace(Space space) {
        this.fAo.create(CSUMAuditEntity.class, new DBParam[]{new DBParam("OPERATION_TYPE", (Object)ICSUMActiveObjectService.CSUMOperationType.systemConfigUpdated), new DBParam("EVENT_OUTCOME", (Object)"success"), new DBParam(SPACE_KEY, (Object)(space != null ? space.getLowerKey() : null)), new DBParam(GROUP_NAME, (Object)""), new DBParam("CONTEXT_USER_KEY", (Object)SYSTEM), new DBParam("SUMMARY", (Object)""), new DBParam("COMMENT", (Object)""), new DBParam("CREATED_BY_USER_KEY", (Object)SYSTEM), new DBParam("CREATED_DATE", (Object)System.currentTimeMillis()), new DBParam("AUTH_GROUP", (Object)"")});
    }

    @Override
    public void createOldAuditEntityForSpace(Space space) {
        Date currentdate = new Date();
        Date dateAYearAgo = new Date();
        dateAYearAgo.setYear(currentdate.getYear() - 1);
        this.fAo.create(CSUMAuditEntity.class, new DBParam[]{new DBParam("OPERATION_TYPE", (Object)ICSUMActiveObjectService.CSUMOperationType.systemConfigUpdated.name()), new DBParam("EVENT_OUTCOME", (Object)"success"), new DBParam(SPACE_KEY, (Object)(space != null ? space.getLowerKey() : null)), new DBParam(GROUP_NAME, (Object)""), new DBParam("CONTEXT_USER_KEY", (Object)SYSTEM), new DBParam("SUMMARY", (Object)""), new DBParam("COMMENT", (Object)""), new DBParam("CREATED_BY_USER_KEY", (Object)SYSTEM), new DBParam("CREATED_DATE", (Object)dateAYearAgo), new DBParam("AUTH_GROUP", (Object)"")});
    }
}

