/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.TwoTermBooleanQuery;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.CSUMDelegatedGroupEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.CSUMConfigCacheEntry;
import com.pluginpeople.confluence.csum.service.cache.CSUMDlgGroupCacheEntry;
import com.pluginpeople.confluence.csum.service.cache.CSUMSpaceGroupsEntry;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import com.pluginpeople.confluence.csum.service.cache.ICachedSpaceGroups;
import com.pluginpeople.confluence.csum.util.DlgEntryXmlStrConv;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultCSUMCacheManagerImpl
implements ICSUMCacheManager {
    private static final Logger LOG = Logger.getLogger(DefaultCSUMCacheManagerImpl.class);
    private static final int CONFIG_CACHE_DEFAULT_EXPIRY = 24;
    private static final int SPACE_CACHE_DEFAULT_EXPIRY = 12;
    private static final int AUTH_CACHE_DEFAULT_EXPIRY = 5;
    private static final int SYS_VAR_GROUP_MAX_DEFAULT = 1000;
    private static final String CACHE_EXTENSION_STRING = ".cache";
    private static final String SYS_VAR_GROUP_MAX = "csum.cache.group.max";
    private static final String VIEW_SPACE = "VIEWSPACE";
    private static Cache<String, ICachedConfig> configCache;
    private static Cache<String, ICachedSpaceGroups> spaceGroupCache;
    private static Cache<String, String[]> authUserCache;
    private final int fMaxGroupsPerCacheEntry;
    private final ICSUMActiveObjectService fCao;
    private final UserAccessor fUserAccessor;
    private final SpacePermissionManager fPermissionManager;
    private final SpaceManager fSpaceManager;

    @Autowired
    public DefaultCSUMCacheManagerImpl(ICSUMActiveObjectService aos, @ComponentImport CacheManager cacheManager, @ComponentImport UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, @ComponentImport SpaceManager spaceManager) {
        this.fCao = aos;
        this.fUserAccessor = userAccessor;
        this.fMaxGroupsPerCacheEntry = this.getCacheEntryGroupMaximum();
        this.fPermissionManager = spacePermissionManager;
        this.fSpaceManager = spaceManager;
        configCache = cacheManager.getCache(CSUMConfigCacheEntry.class.getName() + CACHE_EXTENSION_STRING, (CacheLoader)new CSUMConfigCacheLoader(), new CacheSettingsBuilder().remote().replicateViaCopy().replicateAsynchronously().expireAfterAccess(24L, TimeUnit.HOURS).flushable().maxEntries(1).build());
        spaceGroupCache = cacheManager.getCache(CSUMSpaceGroupsEntry.class.getName() + CACHE_EXTENSION_STRING, (CacheLoader)new CSUMSpaceGroupCacheLoader(), new CacheSettingsBuilder().remote().replicateViaCopy().replicateAsynchronously().expireAfterAccess(12L, TimeUnit.HOURS).flushable().maxEntries(1000).build());
        authUserCache = cacheManager.getCache(CSUMDlgGroupCacheEntry.class.getName() + CACHE_EXTENSION_STRING, (CacheLoader)new CSUMAuthUserCacheLoader(), new CacheSettingsBuilder().remote().replicateViaCopy().replicateAsynchronously().expireAfterWrite(5L, TimeUnit.MINUTES).flushable().maxEntries(1000).build());
    }

    @Override
    public int getCacheEntryGroupMaximum() {
        if (this.fMaxGroupsPerCacheEntry != 0) {
            return this.fMaxGroupsPerCacheEntry;
        }
        int ret = 1000;
        String envVar = null;
        String sysProp = null;
        try {
            envVar = System.getenv(SYS_VAR_GROUP_MAX);
            sysProp = System.getProperty(SYS_VAR_GROUP_MAX);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occurred while retrieving CSUM system property", (Throwable)e);
        }
        try {
            if (envVar != null) {
                ret = Integer.parseInt(envVar);
            } else if (sysProp != null) {
                ret = Integer.parseInt(sysProp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error((Object)"Could not parse int for sys property: csum.cache.group.max");
        }
        return ret;
    }

    @Override
    public void flushAll() {
        spaceGroupCache.removeAll();
        configCache.removeAll();
        LOG.debug((Object)"flushAll() complete");
    }

    @Override
    public ICachedConfig getCachedConfig() {
        return (ICachedConfig)configCache.get((Object)"ignored");
    }

    @Override
    public ICachedConfig updateCachedConfig(CSUMConfigEntity config) {
        configCache.removeAll();
        ICachedConfig recached = (ICachedConfig)configCache.get((Object)"default");
        LOG.debug((Object)"recached config");
        return recached;
    }

    @Override
    public String[] getSpaceGroups(Space space) {
        String[] val;
        String[] ret = ArrayUtils.EMPTY_STRING_ARRAY;
        ICachedSpaceGroups entry = (ICachedSpaceGroups)spaceGroupCache.get((Object)space.getLowerKey());
        if (entry != null && (val = entry.getSpaceGroups()) != null && val.length > 0) {
            ret = val;
        }
        return ret;
    }

    @Override
    public String[] getPagedSpaceGroups(Space space, int maxGroupRetrieval, int offset, String searchVal) {
        String[] ret = ArrayUtils.EMPTY_STRING_ARRAY;
        ICachedSpaceGroups entry = (ICachedSpaceGroups)spaceGroupCache.get((Object)space.getLowerKey());
        if (entry != null) {
            if (searchVal != null && !searchVal.isEmpty()) {
                ret = this.findPagedGroups(maxGroupRetrieval, searchVal, ret, entry);
            } else {
                String[] val = entry.getPagedSpaceGroups(maxGroupRetrieval, offset);
                if (val != null && val.length > 0) {
                    ret = val;
                }
            }
        }
        return ret;
    }

    private String[] findPagedGroups(int maxGroupRetrieval, String searchVal, String[] ret, ICachedSpaceGroups entry) {
        String[] val = entry.getSpaceGroups();
        if (val != null && val.length > 0) {
            ArrayList<String> filteredGroups = new ArrayList<String>();
            for (String group : val) {
                if (filteredGroups.size() == maxGroupRetrieval) break;
                if (!group.contains(searchVal)) continue;
                filteredGroups.add(group);
            }
            ret = filteredGroups.toArray(new String[0]);
        }
        return ret;
    }

    @Override
    public void deleteSpaceGroups(Space space) {
        spaceGroupCache.remove((Object)space.getLowerKey());
    }

    @Override
    public void setSpaceGroups(Space aSpace, String[] updatedGroups) {
        CSUMSpaceGroupsEntry forUpdateEntry = new CSUMSpaceGroupsEntry(aSpace.getLowerKey(), updatedGroups);
        spaceGroupCache.put((Object)aSpace.getLowerKey(), (Object)forUpdateEntry);
    }

    @Override
    public Collection<ICachedSpaceGroups> getAllSpaceGroups() {
        ArrayList<ICachedSpaceGroups> spaceGroups = new ArrayList<ICachedSpaceGroups>();
        Collection keys = spaceGroupCache.getKeys();
        for (String key : keys) {
            ICachedSpaceGroups entry = (ICachedSpaceGroups)spaceGroupCache.get((Object)key);
            if (entry == null) continue;
            spaceGroups.add(entry);
        }
        LOG.debug((Object)("Found: " + spaceGroups.size() + " cached space group lists"));
        return spaceGroups;
    }

    @Override
    public void deleteAllSpaceGroups() {
        spaceGroupCache.removeAll();
    }

    @Override
    public void deleteSpaceGroup(Space aSpace, String groupName) {
        ICachedSpaceGroups origSpaceGroups = (ICachedSpaceGroups)spaceGroupCache.get((Object)aSpace.getLowerKey());
        if (origSpaceGroups != null) {
            Object[] src;
            for (String string : src = origSpaceGroups.getSpaceGroups()) {
                if (!string.equals(groupName)) continue;
                String[] updatedGroups = (String[])ArrayUtils.removeElement((Object[])src, (Object)groupName);
                CSUMSpaceGroupsEntry forUpdateEntry = new CSUMSpaceGroupsEntry(aSpace.getLowerKey(), updatedGroups);
                spaceGroupCache.put((Object)aSpace.getLowerKey(), (Object)forUpdateEntry);
                break;
            }
        }
    }

    @Override
    public String getGroupFilter() {
        String groupFilter = ((ICachedConfig)configCache.get((Object)"groupFilter")).getGroupFilter();
        if (groupFilter != null) {
            return groupFilter;
        }
        LOG.error((Object)"cannot fetch group filter");
        return "error fetching group filter";
    }

    @Override
    public boolean getGroupFilterBehavior() {
        return ((ICachedConfig)configCache.get((Object)"groupFilterBehavior")).getGroupFilterBehavior();
    }

    @Override
    public String[] getDlgGroupsForUser(ConfluenceUser user) {
        String userKeyStr = user.getKey().getStringValue();
        String[] dlgGroupCacheEntries = (String[])authUserCache.get((Object)userKeyStr);
        if (dlgGroupCacheEntries == null) {
            return new String[0];
        }
        return dlgGroupCacheEntries;
    }

    @Override
    public String[] getPagedDlgGroupsForUser(ConfluenceUser user, int maxRows, int offset) {
        String[] ret;
        String userKeyStr = user.getKey().getStringValue();
        String[] dlgGroupCacheEntries = (String[])authUserCache.get((Object)userKeyStr);
        if (dlgGroupCacheEntries == null || dlgGroupCacheEntries.length == 0) {
            ret = new String[]{};
        } else {
            int count = 0;
            ArrayList<String> pagedEntries = new ArrayList<String>();
            for (int i = 0; i < dlgGroupCacheEntries.length; ++i) {
                if (count >= maxRows || i + offset >= dlgGroupCacheEntries.length) continue;
                pagedEntries.add(dlgGroupCacheEntries[i + offset]);
                ++count;
            }
            ret = pagedEntries.toArray(new String[0]);
        }
        return ret;
    }

    @Override
    public int getTotalGroupCount(ConfluenceUser user) {
        String userKeyStr = user.getKey().getStringValue();
        String[] dlgGroupCacheEntries = (String[])authUserCache.get((Object)userKeyStr);
        int ret = dlgGroupCacheEntries == null ? 0 : dlgGroupCacheEntries.length;
        return ret;
    }

    @Override
    public int getFilteredGroupCount(ConfluenceUser user, String searchVal) {
        int ret = 0;
        String userKeyStr = user.getKey().getStringValue();
        String[] dlgGroupCacheEntries = (String[])authUserCache.get((Object)userKeyStr);
        if (dlgGroupCacheEntries != null) {
            for (String groupEntry : dlgGroupCacheEntries) {
                if (!groupEntry.contains(searchVal)) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public Collection<String> getAuthUserCacheKeys(ConfluenceUser user) {
        return authUserCache.getKeys();
    }

    @Override
    public void deleteAuthUsers() {
        authUserCache.removeAll();
    }

    private class CSUMSpaceGroupCacheLoader
    implements CacheLoader<String, ICachedSpaceGroups> {
        private CSUMSpaceGroupCacheLoader() {
        }

        public ICachedSpaceGroups load(@Nonnull String spaceKey) {
            ICachedConfig cachedConfig = (ICachedConfig)configCache.get((Object)"blah");
            String prefix = cachedConfig.getGroupPrefixPattern();
            String suffix = cachedConfig.getGroupSuffixPattern();
            LOG.debug((Object)("spaceGroupCacheLoader, loading [" + spaceKey + "] groups"));
            long tStart = System.currentTimeMillis();
            ICachedSpaceGroups cachedSpaceGroupBean = this.getSpaceGroupsFor(prefix, spaceKey, suffix);
            int len = cachedSpaceGroupBean.getSpaceGroups().length;
            long tDiff = System.currentTimeMillis() - tStart;
            LOG.debug((Object)("spaceGroupCacheLoader, loaded [" + len + "] groups for space [" + spaceKey + "] in " + tDiff + "ms"));
            return cachedSpaceGroupBean;
        }

        private ICachedSpaceGroups getSpaceGroupsFor(String prefixUC, String spaceKey, String suffixUC) {
            String prefix = prefixUC != null ? prefixUC.replace("SPACEKEY", spaceKey).toLowerCase() : null;
            String suffix = suffixUC != null ? suffixUC.replace("SPACEKEY", spaceKey).toLowerCase() : null;
            LOG.debug((Object)("Looking for groups: [prefix=" + prefix + ", suffix=" + suffix + ", spaceKey=" + spaceKey + "]"));
            Pair<List<Group>, Boolean> matches = new Pair<List<Group>, Boolean>(Collections.emptyList(), (Object)false);
            try {
                matches = this.performSpaceGroupSearch(prefix, suffix, DefaultCSUMCacheManagerImpl.this.fMaxGroupsPerCacheEntry, spaceKey);
                if (Boolean.TRUE.equals(matches.right())) {
                    LOG.warn((Object)("Reached groups per space cache limit (" + DefaultCSUMCacheManagerImpl.this.fMaxGroupsPerCacheEntry + "), consider using system property to increase: " + DefaultCSUMCacheManagerImpl.SYS_VAR_GROUP_MAX));
                }
                LOG.debug((Object)("Found " + ((List)matches.left()).size() + " SpaceGroups for space " + spaceKey));
            }
            catch (EntityException e) {
                LOG.error((Object)"Exception during retrieval of space groups. Error: ", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Exception during retrieval of space groups as no CSUM Prefix or Suffix has been set in your CSUM configuration and current space key is null. Error: ", (Throwable)e);
            }
            return new CSUMSpaceGroupsEntry(spaceKey, (List)matches.left());
        }

        private Pair<List<Group>, Boolean> performSpaceGroupSearch(String prefix, String suffix, int max, String spaceKey) throws EntityException {
            boolean exitLoop;
            Query<Group> query = this.buildSpaceGroupQuery(prefix, suffix, spaceKey);
            SearchResult searchResult = DefaultCSUMCacheManagerImpl.this.fUserAccessor.findGroups(query);
            ArrayList<Group> matches = new ArrayList<Group>();
            boolean maxReached = false;
            Pager visibleGroups = searchResult.pager();
            do {
                List currentPage = visibleGroups.getCurrentPage();
                for (Group group : currentPage) {
                    if (matches.size() < max) {
                        if (DefaultCSUMCacheManagerImpl.this.getCachedConfig().isIgnorePermissionCheck()) {
                            if (suffix != null && !group.getName().toLowerCase().endsWith(suffix.toLowerCase())) continue;
                            matches.add(group);
                            continue;
                        }
                        this.checkGroupViewPermission(suffix, spaceKey, matches, group);
                        continue;
                    }
                    maxReached = true;
                    break;
                }
                boolean bl = exitLoop = visibleGroups.onLastPage() || matches.size() == max;
                if (exitLoop) continue;
                visibleGroups.nextPage();
            } while (!exitLoop);
            return new Pair(matches, (Object)maxReached);
        }

        private Query<Group> buildSpaceGroupQuery(String prefix, String suffix, String spaceKey) {
            GroupNameTermQuery retQuery;
            if (prefix != null && suffix != null) {
                GroupNameTermQuery prefixQuery = new GroupNameTermQuery(prefix, "starts_with");
                GroupNameTermQuery suffixQuery = new GroupNameTermQuery(suffix, "ends_with");
                retQuery = new TwoTermBooleanQuery((Query)prefixQuery, (Query)suffixQuery);
            } else if (prefix != null) {
                retQuery = new GroupNameTermQuery(prefix, "starts_with");
            } else if (suffix != null) {
                retQuery = new GroupNameTermQuery(suffix, "ends_with");
            } else if (spaceKey != null) {
                retQuery = new GroupNameTermQuery(spaceKey + "-", "starts_with");
                LOG.debug((Object)("No prefix or suffix set in CSUM config... finding existing groups with prefix as current spaceKey. Current spaceKey:  " + spaceKey));
            } else {
                throw new IllegalArgumentException("At least one of either current spaceKey, prefix or suffix should not be null");
            }
            return retQuery;
        }

        private void checkGroupViewPermission(String suffix, String spaceKey, List<Group> matches, Group group) {
            if ((suffix == null || group.getName().toLowerCase().endsWith(suffix.toLowerCase())) && DefaultCSUMCacheManagerImpl.this.fPermissionManager.groupHasPermission(DefaultCSUMCacheManagerImpl.VIEW_SPACE, DefaultCSUMCacheManagerImpl.this.fSpaceManager.getSpace(spaceKey), group.getName())) {
                matches.add(group);
            }
        }
    }

    private class CSUMAuthUserCacheLoader
    implements CacheLoader<String, String[]> {
        private CSUMAuthUserCacheLoader() {
        }

        @Nonnull
        public String[] load(@Nonnull String userKey) {
            String[] ret = new String[]{};
            try {
                UserKey userKeyObj = new UserKey(userKey);
                ConfluenceUser user = DefaultCSUMCacheManagerImpl.this.fUserAccessor.getUserByKey(userKeyObj);
                CSUMDelegatedGroupEntity[] groups = DefaultCSUMCacheManagerImpl.this.fCao.getDelegatedGroupsForUser(user);
                String[] dlgGroupEntries = new String[groups.length];
                for (int i = 0; i < groups.length; ++i) {
                    CSUMDelegatedGroupEntity group = groups[i];
                    CSUMDlgGroupCacheEntry entry = new CSUMDlgGroupCacheEntry(group);
                    dlgGroupEntries[i] = DlgEntryXmlStrConv.beanToString(entry);
                }
                ret = dlgGroupEntries;
            }
            catch (EntityException | JAXBException e) {
                LOG.error((Object)"Exception occurred during cache population", e);
            }
            return ret;
        }
    }

    private class CSUMConfigCacheLoader
    implements CacheLoader<String, ICachedConfig> {
        private CSUMConfigCacheLoader() {
        }

        public ICachedConfig load(@Nonnull String ignore) {
            return DefaultCSUMCacheManagerImpl.this.fCao.getCachedConfig();
        }
    }
}

