AJS.$(document).ready(function () {
    let auditingTable;
    let refreshTimer;
    let spaceKey = getSpaceKey();

    function getSpaceKey() {
        let ret;
        let ajsSpaceKey = AJS.$("meta[name='ajs-space-key']").attr('content')

        if (typeof ajsSpaceKey === "undefined") {
            console.log('unable to find ajs-space-key, falling back to confluence-space-key');
            let confluenceSpaceKey = AJS.$("meta[name='confluence-space-key']").attr('content');
            if (typeof confluenceSpaceKey === "undefined") {
                if (!document.URL.includes("/admin/plugins/csum-config-actions/")) {
                    alert('CSUM unable to detect space in admin config, please contact support with a HAR archive: https://confluence.atlassian.com/kb/generating-har-files-and-analyzing-web-requests-720420612.html');
                }
            } else {
                console.log('CSUM found space key from meta:confluence-space-key: ' + confluenceSpaceKey)
                ret = confluenceSpaceKey;
            }
        } else {
            console.log('CSUM found space key from meta:ajs-space-key: ' + ajsSpaceKey);
            ret = ajsSpaceKey;
        }
        return ret;
    }
    function markMatch(text, term, markup) {
        let match = csumStripDiacritics(text.toUpperCase()).indexOf(csumStripDiacritics(term.toUpperCase())), tl = term.length;

        if (match < 0) {
            markup.push(AJS.escapeHtml(text));
            return;
        }

        markup.push(AJS.escapeHtml(text.substring(0, match)));
        markup.push("<span class='select2-match'>");
        markup.push(AJS.escapeHtml(text.substring(match, match + tl)));
        markup.push("</span>");
        markup.push(AJS.escapeHtml(text.substring(match + tl, text.length)));
    }

    // enabling this allows you to handle errors yourself.
    //$.fn.dataTable.ext.errMode = 'throw';
    function startAuditingAutoRefresh() {
        refreshTimer = setInterval(function () {
            if (AJS.$('#csum-space-tabs #csum-space-tabs-auditing, #csum-config-tabs #csum-configtabs-audit').hasClass('active-pane')) {
                auditingTable.ajax.reload(null, false);
            }
        }, 10000);
    }

    function initAuditTableFilters() {
        let userSearchUrl = AJS.contextPath() + '/rest/csum/latest/spaceuser/search?atl_token=' + AJS.Meta.get("atl-token");
        function initUserSelect(userSelect) {
            AJS.$(userSelect).auiSelect2({
                placeholder: AJS.I18n.getText('find.users'),
                minimumInputLength: 2,
                allowClear: true,
                width: 500,
                ajax: {
                    url: userSearchUrl,
                    dataType: 'json',
                    quietMillis: 350,
                    data: function (term) {
                        return {
                            spaceKey: spaceKey ? spaceKey : undefined,
                            query: term,
                            page_limit: 25
                        };
                    },
                    results: function (data) {
                        return {results: data.users};
                    }
                },
                formatResult: function (result, container, query) {
                    let markup = [];
                    let text = result.fullname + " (" + result.email + ", " + result.username + ")";
                    markMatch(text, query.term, markup);
                    return markup.join("");
                },
                formatSelection: function (item) {
                    return item.fullname;
                },
                id: function (item) {
                    return item.username;
                }
            });
        }
        initUserSelect("#csum-ctxuser-selector, #csum-changedBy-selector");

        function initGroupSelect() {
            let groupSearchUrl = AJS.contextPath() + '/rest/csum/1.0/spacegroup/search?atl_token=' + AJS.Meta.get("atl-token");
            AJS.$("#csum-group-selector").auiSelect2({
                placeholder: AJS.I18n.getText('find.groups'),
                minimumInputLength: 1,
                allowClear: true,
                width: 500,
                ajax: {
                    url: groupSearchUrl,
                    dataType: 'json',
                    quietMillis: 350,
                    width: 500,
                    data: function (term) {
                        return {
                            spaceKey: spaceKey ? spaceKey : undefined,
                            query: term,
                            page_limit: 25,
                        };
                    },
                    results: function (data) {
                        return {
                            results: data.groups,
                            text: function (item) {
                                return AJS.escapeHtml(item);
                            },
                            id: function (item) {
                                return item;
                            }
                        };
                    }
                },
                formatResult: function (item) {
                    if (item.id) {
                        return AJS.escapeHtml(item.id);
                    } else {
                        return AJS.escapeHtml(item);
                    }
                },
                formatSelection: function (item) {
                    if (item.id) {
                        return AJS.escapeHtml(item.id);
                    } else {
                        return AJS.escapeHtml(item);
                    }
                },
                id: function (item) {
                    if (item.id) {
                        return item.id;
                    } else {
                        return item;
                    }
                }
            });
        }
        initGroupSelect();

        if (AJS.$("#csum-space-selector").length > 0) {
            let customSpaceFindUrl = AJS.contextPath() + "/rest/csum/1.0/space/search?atl_token=" + AJS.Meta.get("atl-token");
            initSpaceSelect(customSpaceFindUrl);

            AJS.$('#csum-space-selector').on('change', function () {
                //Set selected space to hidden input and un-disable delete link
                AJS.$('#selectedSpaceKey').val(this.value);
                AJS.$('#csum-delete-space-history').removeAttr("disabled");
                AJS.$('#csumDeleteSpaceAuditBtn').removeAttr("disabled");
                AJS.$('#csumDeleteSpaceAuditLogo').removeAttr("disabled");
                AJS.$('#csumDeleteSpaceAuditLogo').attr("style", "color: #0052CC");
                auditingTable.column(1).search(this.value).draw();
                AJS.$('#csum-space-selector-clear').attr("style", "display: inline-block");
            });
            AJS.$('#csum-space-selector-clear').click(function () {
                AJS.$('#selectedSpaceKey').val(null);
                AJS.$('#csum-delete-space-history').attr("disabled");
                AJS.$('#csumDeleteSpaceAuditBtn').attr("disabled");
                AJS.$('#csumDeleteSpaceAuditLogo').attr("disabled");
                AJS.$('#csumDeleteSpaceAuditLogo').attr("style", "color: #90b3e9");
                auditingTable.column(1).search('').draw();
                AJS.$('#csum-space-selector').val(null).trigger('change');
                initSpaceSelect(customSpaceFindUrl)
                AJS.$('#csum-space-selector-clear').attr("style", "display: none");
            });

            function initSpaceSelect(customSpaceFindUrl) {
                AJS.$("#csum-space-selector").auiSelect2({
                    placeholder: AJS.I18n.getText('all'),
                    minimumInputLength: 1,
                    allowClear: true,
                    width: 500,
                    ajax: {
                        type: "post",
                        url: customSpaceFindUrl,
                        dataType: 'json',
                        quietMillis: 350,
                        data: function (term) {
                            return {
                                spaceKey: spaceKey,
                                term: term,
                                pageLimit: 25
                            };
                        },
                        results: function (data) {
                            return {
                                results: data,
                                text: function (item) {
                                    return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                                },
                                id: function (item) {
                                    return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                                }
                            };
                        }
                    },
                    formatResult: function (item) {
                        return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                    },
                    formatSelection: function (item) {
                        return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                    },
                    id: function (item) {
                        return AJS.escapeHtml(item.key);
                    }
                });
            }
        }

        AJS.$('#csum-changedBy-selector').on('change', function () {
            auditingTable.column(2).search(this.value).draw();
            AJS.$('#csum-changedBy-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-changedBy-selector-clear').click(function () {
            auditingTable.column(2).search('').draw();
            AJS.$('#csum-changedBy-selector').val(null).trigger('change');
            initUserSelect("#csum-changedBy-selector");
            AJS.$('#csum-changedBy-selector-clear').attr("style", "display: none");
        });

        function initOperationSelect() {
            AJS.$("#csum-operation-selector").auiSelect2({
                placeholder: AJS.I18n.getText('all'),
                allowClear: true,
                width: 500,
                escapeMarkup: function (text) {
                    return text;
                }
            });
        }
        initOperationSelect();
        AJS.$('#csum-operation-selector').on('change', function () {
            auditingTable.column(3).search(this.value).draw();
            AJS.$('#csum-operation-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-operation-selector-clear').click(function () {
            auditingTable.column(3).search('').draw();
            AJS.$('#csum-operation-selector').val(null).trigger('change');
            initOperationSelect();
            AJS.$('#csum-operation-selector-clear').attr("style", "display: none");
        });

        AJS.$('#csum-group-selector').on('change', function () {
            auditingTable.column(4).search(this.value).draw();
            AJS.$('#csum-group-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-group-selector-clear').click(function () {
            auditingTable.column(4).search('').draw();
            AJS.$('#csum-group-selector').val(null).trigger('change');
            initGroupSelect();
            AJS.$('#csum-group-selector-clear').attr("style", "display: none");
        });

        AJS.$('#csum-ctxuser-selector').on('change', function () {
            auditingTable.column(5).search(this.value).draw();
            AJS.$('#csum-ctxuser-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-ctxuser-selector-clear').click(function () {
            auditingTable.column(5).search('').draw();
            AJS.$('#csum-ctxuser-selector').val(null).trigger('change');
            initUserSelect('#csum-ctxuser-selector');
            AJS.$('#csum-ctxuser-selector-clear').attr("style", "display: none");
        });

        function initOutcomeSelector() {
            AJS.$("#csum-outcome-selector").auiSelect2({
                placeholder: AJS.I18n.getText('all'),
                allowClear: true,
                width: 500
            });
        }
        initOutcomeSelector();

        AJS.$('#csum-outcome-selector').on('change', function () {
            auditingTable.column(6).search(this.value).draw();
            AJS.$('#csum-outcome-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-outcome-selector-clear').click(function () {
            auditingTable.column(6).search('').draw();
            AJS.$('#csum-outcome-selector').val(null).trigger('change');
            initOutcomeSelector();
            AJS.$('#csum-outcome-selector-clear').attr("style", "display: none");
        });
    }

    //initialise auditing
    initAuditTableFilters();

    let operationsi18n = {
        systemConfigUpdated: AJS.I18n.getText('csum.auditing.operation.systemConfigUpdated'),
        createUser: AJS.I18n.getText('csum.auditing.operation.createUser'),
        createGroup: AJS.I18n.getText('csum.auditing.operation.createGroup'),
        createRemoteGroup: AJS.I18n.getText('csum.auditing.operation.createRemoteGroup'),
        removeGroup: AJS.I18n.getText('csum.auditing.operation.removeGroup'),
        removeRemoteGroup: AJS.I18n.getText('csum.auditing.operation.removeRemoteGroup'),
        addUserToGroup: AJS.I18n.getText('csum.auditing.operation.addUserToGroup'),
        addUserToRemoteGroup: AJS.I18n.getText('csum.auditing.operation.addUserToRemoteGroup'),
        removeUserFromGroup: AJS.I18n.getText('csum.auditing.operation.removeUserFromGroup'),
        removeUserFromRemoteGroup: AJS.I18n.getText('csum.auditing.operation.removeUserFromRemoteGroup'),
        addDelegatedGroup: AJS.I18n.getText('csum.auditing.operation.addDelegatedGroup'),
        removeDelegatedGroup: AJS.I18n.getText('csum.auditing.operation.removeDelegatedGroup'),
        authorizeUser: AJS.I18n.getText('csum.auditing.operation.authorizeUser'),
        deauthorizeUser: AJS.I18n.getText('csum.auditing.operation.deauthorizeUser'),
        authorizeGroup: AJS.I18n.getText('csum.auditing.operation.authorizeGroup'),
        deauthorizeGroup: AJS.I18n.getText('csum.auditing.operation.deauthorizeGroup'),
        deauthGroupBySystem: AJS.I18n.getText('csum.auditing.operation.deauthGroupBySystem'),
        deauthUserBySystem: AJS.I18n.getText('csum.auditing.operation.deauthUserBySystem'),
        removeDlgGroupBySys: AJS.I18n.getText('csum.auditing.operation.removeDlgGroupBySys'),
        removedFromFilter: AJS.I18n.getText('csum.auditing.operation.removedFromFilter'),
        groupDeletedExternally: AJS.I18n.getText('csum.auditing.operation.groupDeletedExternally'),
        getUsersOrGroups: AJS.I18n.getText('csum.auditing.operation.groupDeletedExternally'),
        importGroup: AJS.I18n.getText('csum.auditing.operation.importGroup')
    };

    auditingTable = AJS.$('#csum-auditing').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: AJS.contextPath() + "/rest/csum/latest/auditing/records?atl_token=" + AJS.Meta.get("atl-token"),
            type: "POST",
            data: function (d) {
                d.orderCol = d.order[0].column;
                d.orderDir = d.order[0].dir;
                d.spaceVal = spaceKey ? spaceKey : d.columns[1].search.value;
                d.creatorVal = d.columns[2].search.value;
                d.opTypeVal = d.columns[3].search.value;
                d.groupVal = d.columns[4].search.value;
                d.userVal = d.columns[5].search.value;
                d.outcomeVal = d.columns[6].search.value;
            }
        },
        columns: [
            null,
            {
                visible: !spaceKey
            },
            {
                "render": function (data, type) {
                    let renderedData;
                    if (type === 'display' && data !== "system") {
                        renderedData = '<a target="_blank" rel="noopener" href="' + AJS.contextPath() + '/display/~' + data + '">' + data + '</a>';
                    } else {
                        renderedData = data;
                    }
                    return renderedData;
                }
            },
            {
                "render": function (data, type, row) {
                    let renderedData;
                    if (type === 'display') {
                        if (data === "authorizeGroup" || data === "deauthorizeGroup" || data === "deauthGroupBySystem") {
                            if (row[7] !== undefined) {
                                renderedData = "<strong>" + row[7] + "</strong>" + " " + operationsi18n[data];
                            } else {
                                renderedData = "A group " + operationsi18n[data];
                            }
                        } else {
                            renderedData = operationsi18n[data];
                        }
                    } else {
                        renderedData = data;
                    }
                    return renderedData
                }
            },
            null,
            {
                "render": function (data, type) {
                    return type === 'display' && data ?
                        '<a target="_blank" rel="noopener" href="' + AJS.contextPath() + '/display/~' + data + '">' + data + '</a>' : data;
                }
            },
            {
                "render": function (data, type) {
                    if (data === 'success') {
                        data = '<span class="aui-icon aui-icon-small aui-iconfont-check">' + data + '</span>'
                    } else if (data === 'queued') {
                        data = '<span class="aui-icon aui-icon-small aui-iconfont-recent">' + data + '</span>'
                    } else {
                        data = '<span class="aui-icon aui-icon-small aui-iconfont-cross">' + data + '</span>'
                    }
                    return type === 'display' && data;
                }
            }
        ],
        order: [[0, "desc"]],
        language: {
            "emptyTable": AJS.I18n.getText('result.grid.no.result.message'),
            "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
            "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
            "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
            "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
            "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
            "processing": AJS.I18n.getText('loading.name'),
            "search": AJS.I18n.getText('search.name'),
            "zeroRecords": AJS.I18n.getText('result.grid.no.result.message')
        }
    });

    AJS.$('#csum-auditing').width("100%");
    startAuditingAutoRefresh();
});
