/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.pluginpeople.confluence.csum.api.ITLicenseManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITLicenseManagerImpl
implements ITLicenseManager {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String TOKEN_HEADER = "X-Atlassian-Token";
    private static final String NO_CHECK = "no-check";
    private static final String ADMIN_USER = "admin";
    private static final String ADDON_3H_TIMEBOMB_LICENSE = "AAABCA0ODAoPeNpdj01PwkAURffzKyZxZ1IyUzARkllQ24gRaQMtGnaP8VEmtjPNfFT59yJVFyzfubkn796Ux0Bz6SmbUM5nbDzj97RISxozHpMUnbSq88poUaLztFEStUN6MJZ2TaiVpu/YY2M6tI6sQrtHmx8qd74EZ+TBIvyUU/AoYs7jiE0jzknWQxMuifA2IBlUbnQ7AulVjwN9AaU9atASs69O2dNFU4wXJLc1aOUGw9w34JwCTTZoe7RPqUgep2X0Vm0n0fNut4gSxl/Jcnj9nFb6Q5tP/Ueu3L+0PHW4ghZFmm2zZV5k6/95CbR7Y9bYGo/zGrV3Ir4jRbDyCA6vt34DO8p3SDAsAhQnJjLD5k9Fr3uaIzkXKf83o5vDdQIUe4XequNCC3D+9ht9ZYhNZFKmnhc=X02dh";
    private static final String CSUM_PLUGIN_KEY = "raju.kadam.confluence.permissionmgmt";
    private ApplicationProperties fAppProps;

    @Autowired
    public ITLicenseManagerImpl(@ComponentImport ApplicationProperties appProps) {
        this.fAppProps = appProps;
    }

    public boolean installLicense() throws UnsupportedEncodingException {
        boolean success = false;
        int TEN_SECONDS = 10000;
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build()).useSystemProperties();
        String baseUrl = this.fAppProps.getBaseUrl(UrlMode.ABSOLUTE);
        String href = baseUrl + "/rest/plugins/1.0/" + CSUM_PLUGIN_KEY + "-key/license";
        String authz = this.basic(ADMIN_USER, ADMIN_USER);
        HttpPut licenseUploader = new HttpPut(href);
        licenseUploader.addHeader(AUTHORIZATION_HEADER, authz);
        licenseUploader.addHeader(TOKEN_HEADER, NO_CHECK);
        licenseUploader.addHeader("Content-Type", "application/vnd.atl.plugins+json");
        licenseUploader.addHeader("Accept", "application/vnd.atl.plugins+json");
        licenseUploader.setEntity((HttpEntity)new StringEntity("{\"rawLicense\" : \"" + ADDON_3H_TIMEBOMB_LICENSE.replaceAll("\\s+", "") + "\" }"));
        System.out.println("sending request");
        try (CloseableHttpClient client = builder.build();
             CloseableHttpResponse response = client.execute((HttpUriRequest)licenseUploader);){
            if (response.getStatusLine().getStatusCode() == 200) {
                success = true;
            }
            if (response.getEntity() != null) {
                System.out.println("license install response: " + IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset()));
            }
        }
        catch (IOException ioe) {
            System.err.println("Unable to install license: " + ioe.getLocalizedMessage());
        }
        return success;
    }

    private String basic(String username, String pwd) throws UnsupportedEncodingException {
        String e = username + ":" + pwd;
        byte[] bytes = e.getBytes("ISO-8859-1");
        String encoded = Base64.getEncoder().encodeToString(bytes);
        return "Basic " + encoded;
    }

    public boolean isLicenseInstalled() throws UnsupportedEncodingException {
        boolean installed = false;
        int TEN_SECONDS = 10000;
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000);
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestBuilder.build()).useSystemProperties();
        String baseUrl = this.fAppProps.getBaseUrl(UrlMode.ABSOLUTE);
        String href = baseUrl + "/rest/plugins/1.0/" + CSUM_PLUGIN_KEY + "-key/license";
        String authz = this.basic(ADMIN_USER, ADMIN_USER);
        HttpGet request = new HttpGet(href);
        request.addHeader(AUTHORIZATION_HEADER, authz);
        request.addHeader(TOKEN_HEADER, NO_CHECK);
        System.out.println("sending request...");
        try (CloseableHttpClient client = builder.build();
             CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            if (response.getEntity() != null) {
                String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
                System.out.println("license check response: " + responseBody);
                ObjectMapper mapper = new ObjectMapper();
                JsonNode json = mapper.readTree(responseBody);
                if (json.get("valid").getBooleanValue() && json.get("active").getBooleanValue()) {
                    installed = true;
                }
            }
        }
        catch (IOException e) {
            System.err.println("Unable to check license state: " + e.getLocalizedMessage());
        }
        return installed;
    }
}

