/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.avatar.AvatarProviderAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

@ReadOnlyAccessAllowed
public class AbstractCSUMSpaceAction
extends AbstractSpaceAction {
    private static final long serialVersionUID = -8404731613599051465L;
    private static final Logger LOG = Logger.getLogger(AbstractCSUMSpaceAction.class);
    protected PermissionManager fPermissionManager;
    protected PluginLicenseManager fLicenseManager;
    protected ICSUMActiveObjectService fAos;
    protected AvatarProviderAccessor fAvatarAccessor;
    protected SpaceManager fSpaceManager;
    protected ICSUMCacheManager fCacheManager;
    protected GroupManager fGroupManager;
    protected UserManager fUserManager;
    protected CSUMPermissionUtil fCsumPermissionUtil;

    public void setCSUMPermissionUtil(CSUMPermissionUtil permissionUtil) {
        this.fLicenseManager = permissionUtil.getPluginLicenseManager();
        this.fCsumPermissionUtil = permissionUtil;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        super.setSpaceManager(spaceManager);
        this.fSpaceManager = spaceManager;
    }

    public void setUserManager(UserManager userManager) {
        this.fUserManager = userManager;
    }

    public void setICSUMActiveObjectService(ICSUMActiveObjectService aos) {
        this.fAos = aos;
    }

    public void setPermissionManager(PermissionManager pm) {
        this.fPermissionManager = pm;
    }

    public void setAvatarProviderAccessor(AvatarProviderAccessor avatarAccessor) {
        this.fAvatarAccessor = avatarAccessor;
    }

    public void setCsumCacheManager(ICSUMCacheManager cacheManager) {
        this.fCacheManager = cacheManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.fGroupManager = groupManager;
    }

    protected String getUrlDecodedCleanedTrimmedParameterValue(Map paramMap, String param) {
        String value = this.getRawParameterValue(paramMap, param);
        return this.cleanParamValue(param, value);
    }

    String getUsernameFromKey(String key) {
        if (key == null) {
            return null;
        }
        ConfluenceUser userByKey = this.getUserAccessor().getUserByKey(new UserKey(key));
        if (userByKey != null) {
            return userByKey.getName();
        }
        return null;
    }

    private String cleanParamValue(String param, String value) {
        if (value != null && !(value = StringUtil.clean(value.trim())).trim().isEmpty()) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                LOG.debug((Object)("request parameter '" + (param != null ? param : "null") + "' had cleaned up value '" + value + "' which could not be URL decoded"), (Throwable)e);
            }
        }
        return value;
    }

    private String getRawParameterValue(Map paramMap, String param) {
        String[] values = (String[])paramMap.get(param);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public final boolean isPermitted() {
        boolean permitted = false;
        ConfluenceUser u = this.getAuthenticatedUser();
        boolean isSysAdmin = this.fPermissionManager.isSystemAdministrator((User)u);
        boolean isSpaceAdmin = this.fPermissionManager.hasPermission((User)u, Permission.ADMINISTER, (Object)this.getSpace());
        if (this.isLicenseValid() && (isSysAdmin || isSpaceAdmin)) {
            permitted = true;
        }
        return permitted;
    }

    public boolean isNotAllowed() {
        boolean isNotAllowed = false;
        String spaceKey = this.getKey();
        if (spaceKey != null && spaceKey.startsWith("~")) {
            if (!this.isPersonalSpaceAdminAllowed()) {
                LOG.info((Object)("Refused to allow " + (this.getAuthenticatedUser().getName() != null ? this.getAuthenticatedUser().getName() : "null") + " to administer users/groups in personal space " + spaceKey));
                isNotAllowed = true;
            }
        } else {
            LOG.debug((Object)"Space is not a personal space");
        }
        return isNotAllowed;
    }

    protected boolean isPersonalSpaceAdminAllowed() {
        return this.fCacheManager.getCachedConfig().isPersonalSpaceAllowed();
    }

    public boolean isGroupActionsPermitted() {
        return this.fCacheManager.getCachedConfig().isGroupActionsPermitted();
    }

    public boolean isRemoveUserFromPermGrpPerm() {
        return this.fCacheManager.getCachedConfig().isRemoveUserFromPermGrpPerm();
    }

    public boolean isGroupAddRemovePermitted() {
        return this.fCacheManager.getCachedConfig().isGroupAddRemovePermitted();
    }

    public boolean isDlgGrpActPerm() {
        return this.fCacheManager.getCachedConfig().isDlgGrpActPerm();
    }

    public boolean isHideUserOperations() {
        return this.fCacheManager.getCachedConfig().isHideUserOperations();
    }

    public boolean isHideGroupOperations() {
        return this.fCacheManager.getCachedConfig().isHideGroupOperations();
    }

    public boolean isAllowSpcAdminDeleteAudits() {
        return this.fCacheManager.getCachedConfig().isAllowAdminDeleteAudits();
    }

    public void setAllowSpcAdminDeleteAudits(boolean allowPermission) {
        this.fCacheManager.getCachedConfig().setAllowAdminDeleteAudits(allowPermission);
    }

    public boolean isGroupPageProcessing() {
        return this.fCacheManager.getCachedConfig().isGroupPageProcessing();
    }

    public boolean isUserPageProcessing() {
        return this.fCacheManager.getCachedConfig().isUserPageProcessing();
    }

    protected final boolean isLicenseValid() {
        boolean valid = false;
        try {
            if (this.fLicenseManager.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.fLicenseManager.getLicense().get();
                valid = !license.getError().isDefined();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Unhandled Exception: " + e.getLocalizedMessage()));
            valid = false;
        }
        return valid;
    }

    public boolean isNotLicensed() {
        return !this.isLicenseValid();
    }

    public final String getLicenseError() {
        String msg = null;
        try {
            if (this.fLicenseManager.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.fLicenseManager.getLicense().get();
                if (license.getError().isDefined()) {
                    msg = ((LicenseError)license.getError().get()).toString();
                }
            } else {
                msg = "Not Installed";
            }
        }
        catch (Exception e) {
            msg = e.getLocalizedMessage();
        }
        return msg;
    }

    public String formatDate(Timestamp t) {
        return this.getDateFormatter().formatDateTime((Date)t);
    }

    public String getNulled(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }
}

