/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.pluginpeople.confluence.csum.api.ITImportManager;
import com.pluginpeople.confluence.csum.rest.beans.JSONImportGroupsResult;
import com.pluginpeople.confluence.csum.util.ImportSpaceGroupUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITImportManagerImpl
implements ITImportManager {
    private final TransactionTemplate fTxTemplate;
    private final ImportSpaceGroupUtil fImportSpaceGroupUtil;

    @Autowired
    public ITImportManagerImpl(@ComponentImport TransactionTemplate txTemplate, ImportSpaceGroupUtil importSpaceGroupUtil) {
        this.fTxTemplate = txTemplate;
        this.fImportSpaceGroupUtil = importSpaceGroupUtil;
    }

    public boolean importGroups(String currentSpaceKey, String importFromSpaceKey, String groupsToImportCSV, boolean importUsers) {
        return (Boolean)this.fTxTemplate.execute(() -> {
            JSONImportGroupsResult result = this.fImportSpaceGroupUtil.importGroupsAndUsers(currentSpaceKey, importFromSpaceKey, groupsToImportCSV, importUsers);
            return result.getExceptionBean() == null && result.getFailedGroups() != null && result.getFailedGroups().isEmpty() && result.getFailedUsers() != null && result.getFailedUsers().isEmpty();
        });
    }
}

