/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.opensymphony.webwork.ServletActionContext;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

@ReadOnlyAccessAllowed
public class AbstractCSUMConfigAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractCSUMConfigAction.class);
    Map<String, String> fResultSpaceKeyMap = new HashMap<String, String>();
    protected PermissionManager fPermissionManager;
    private PluginLicenseManager fLicenseManager;
    private SpaceManager fSpaceManager;
    public ICSUMActiveObjectService fAos;
    private CSUMConfigEntity fConfig;
    private UserManager fUserManager;

    public void setCSUMPermissionUtil(CSUMPermissionUtil permissionUtil) {
        this.fLicenseManager = permissionUtil.getPluginLicenseManager();
    }

    public void setICSUMActiveObjectService(ICSUMActiveObjectService aos) {
        this.fAos = aos;
    }

    protected UserManager getUserManager() {
        return this.fUserManager;
    }

    public void setUserManager(UserManager userManager) {
        this.fUserManager = userManager;
    }

    public ICSUMActiveObjectService getAo() {
        return this.fAos;
    }

    protected SpaceManager getSpaceManager() {
        return this.fSpaceManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.fSpaceManager = spaceManager;
    }

    public PermissionManager getPermissionManager() {
        return this.fPermissionManager;
    }

    public void setPermissionManager(PermissionManager perm) {
        super.setPermissionManager(perm);
        this.fPermissionManager = perm;
    }

    public String doDefault() {
        String ret = "error";
        if (this.isPermitted()) {
            ret = "input";
        }
        return ret;
    }

    public String execute() {
        String ret = "error";
        if (this.isPermitted()) {
            ret = "input";
        }
        return ret;
    }

    public CSUMConfigEntity getConfig() {
        if (this.fConfig == null) {
            this.fConfig = this.fAos.getConfig();
        }
        return this.fConfig;
    }

    public final boolean isPermitted() {
        ConfluenceUser u = this.getAuthenticatedUser();
        PermissionManager pm = this.getPermissionManager();
        return this.isLicenseValid() && (pm.isConfluenceAdministrator((User)u) || pm.isSystemAdministrator((User)u));
    }

    protected final void handleLicenseError() {
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            String html = "License expiration error...";
            response.setContentType("text/html");
            response.setContentLength(html.length());
            response.getWriter().write(html);
        }
        catch (IOException e) {
            LOG.error((Object)"failed to getWriter from javax.servlet.ServletResponse", (Throwable)e);
        }
    }

    protected final void handleUnlicensedError() {
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            String html = "No License installed...";
            response.setContentType("text/html");
            response.setContentLength(html.length());
            response.getWriter().write(html);
        }
        catch (IOException e) {
            LOG.error((Object)"failed to getWriter from javax.servlet.ServletResponse", (Throwable)e);
        }
    }

    public boolean isLicenseInstalled() {
        boolean ret = false;
        try {
            ret = this.fLicenseManager.getLicense().isDefined();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting licence", (Throwable)e);
        }
        return ret;
    }

    public String getLicenseError() {
        String message = null;
        try {
            PluginLicense license = (PluginLicense)this.fLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                try {
                    message = ((LicenseError)license.getError().get()).toString();
                }
                catch (Exception e) {
                    message = "Unable to get the license problem: " + e.getLocalizedMessage();
                }
            }
        }
        catch (Exception e) {
            message = "Unable to 'get' the license: " + e.getLocalizedMessage();
        }
        return message;
    }

    public final boolean isLicenseValid() {
        boolean valid = false;
        try {
            PluginLicense license;
            if (this.fLicenseManager.getLicense().isDefined() && !(license = (PluginLicense)this.fLicenseManager.getLicense().get()).getError().isDefined()) {
                valid = true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"failed to get licence", (Throwable)e);
        }
        return valid;
    }

    public String formatDate(Timestamp t) {
        return this.getDateFormatter().formatDateTime((Date)t);
    }

    public String[] getResultSpaceKeys() {
        Set<String> keySet = this.fResultSpaceKeyMap.keySet();
        String[] vals = new String[keySet.size()];
        return keySet.toArray(vals);
    }

    public String getResultSpaceName(String spaceKey) {
        return this.fResultSpaceKeyMap.get(spaceKey);
    }

    public String getSpaceAvatarUrl(String spaceKey) {
        String baseUrl = this.getGlobalSettings().getBaseUrl();
        return baseUrl + this.fSpaceManager.getLogoForSpace(spaceKey).getDownloadPath();
    }

    public String getSpaceName(String spaceKey) {
        Space space = this.fSpaceManager.getSpace(spaceKey);
        String ret = space != null ? space.getName() : spaceKey;
        return ret;
    }

    public String getUserAvatarUrlByKey(String userkey) {
        ConfluenceUser u;
        String ret = null;
        UserAccessor ua = this.getUserAccessor();
        ProfilePictureInfo userProfilePicture = ua.getUserProfilePicture((User)(u = ua.getUserByKey(new UserKey(userkey))));
        ret = userProfilePicture.isExternal() ? "/images/icons/profilepics/default.png" : userProfilePicture.getUriReference();
        return ret;
    }

    public String getUserAvatarUrlByName(String username) {
        ConfluenceUser u;
        String ret = null;
        UserAccessor ua = this.getUserAccessor();
        ProfilePictureInfo userProfilePicture = ua.getUserProfilePicture((User)(u = ua.getUserByName(username)));
        ret = userProfilePicture.isExternal() ? "/images/icons/profilepics/default.png" : userProfilePicture.getUriReference();
        return ret;
    }

    public String getBaseUrl() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public String urlEscapeText(String param) {
        return URLEncoder.encode(param);
    }

    public boolean isGroupExists(String groupName) {
        Group aGroup = this.getUserAccessor().getGroup(groupName);
        return aGroup != null;
    }

    public String getNulled(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }
}

