/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.EntityMissingException;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.RemoveAllUsersException;
import com.pluginpeople.confluence.csum.api.beans.JSONAddUserResultBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.DataTableUserList;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.service.cache.CSUMDlgGroupCacheEntry;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.DlgEntryXmlStrConv;
import com.pluginpeople.confluence.csum.util.DlgGroupManager;
import com.pluginpeople.confluence.csum.util.GroupUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

@ReadOnlyAccessAllowed
@RequiresLicensedConfluenceAccess
@Path(value="spacedlg")
public class SpaceDelegatedResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = Logger.getLogger(SpaceDelegatedResource.class);
    private final GroupUtil fGroupUtil;
    private final UserAccessor fUserAccessor;
    private final GroupManager fGroupManager;
    private final ICSUMCacheManager fCacheManager;
    private final DlgGroupManager fDgm;
    private final PluginAccessor fPluginAccessor;

    public SpaceDelegatedResource(@ComponentImport SpaceManager spaceManager, GroupUtil groupUtil, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager groupManager, ICSUMCacheManager cacheManager, DlgGroupManager dGm, CSUMPermissionUtil permissionUtil, @ComponentImport XsrfTokenService tokenService, PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor) {
        super(spaceManager, permissionUtil, tokenService, permissionManager);
        this.fGroupUtil = groupUtil;
        this.fUserAccessor = userAccessor;
        this.fGroupManager = groupManager;
        this.fCacheManager = cacheManager;
        this.fDgm = dGm;
        this.fPluginAccessor = pluginAccessor;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/list")
    @Produces(value={"application/json"})
    public Response getDelegatedGroups(@Context HttpServletRequest hsr, @QueryParam(value="spacekey") String spaceKey, @QueryParam(value="searchVal") String search, @QueryParam(value="isGroupProc") boolean isServerSideProcEnabled, @QueryParam(value="length") int maxRows, @QueryParam(value="draw") int draw, @QueryParam(value="start") int offset, @QueryParam(value="atl_token") String atlToken) throws EntityException, JAXBException {
        Response response;
        Space validSpace;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error((Object)"Invalid Space, cannot retrieve dlgGroups in delegated resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ConfluenceUser remoteUser = AuthenticatedUserThreadLocal.get();
        if (remoteUser != null) {
            String[] groupEntryBeans = isServerSideProcEnabled ? this.fCacheManager.getPagedDlgGroupsForUser(remoteUser, maxRows, offset) : this.fCacheManager.getDlgGroupsForUser(remoteUser);
            int total = this.fCacheManager.getTotalGroupCount(remoteUser);
            int filtered = search != null && !search.isEmpty() ? this.fCacheManager.getFilteredGroupCount(remoteUser, search) : total;
            CSUMDlgGroupCacheEntry[] visibleGroupList = new CSUMDlgGroupCacheEntry[groupEntryBeans.length];
            for (int i = 0; i < groupEntryBeans.length; ++i) {
                visibleGroupList[i] = DlgEntryXmlStrConv.stringToBean(groupEntryBeans[i]);
            }
            response = Response.ok((Object)this.fDgm.formatSpaceDelegatedGroupData(visibleGroupList, draw, filtered, total)).build();
        } else {
            response = Response.noContent().build();
        }
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/members")
    @Produces(value={"application/json"})
    public Response getGroupMembers(@Context HttpServletRequest hsr, @QueryParam(value="spacekey") String spaceKey, @QueryParam(value="draw") int draw, @QueryParam(value="start") int offset, @QueryParam(value="length") int maxRows, @QueryParam(value="searchVal") String searchVal, @QueryParam(value="isUserProc") boolean isServerSideProcEnabled, @QueryParam(value="group") String group, @QueryParam(value="highlightedGroup") String selectedGroup, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        Space validSpace;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error((Object)"Invalid Space, cannot retrieve group members in delegated resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            DataTableUserList dataTableFormat;
            List<Object> memberList;
            if (isServerSideProcEnabled && this.serverSideGroupSelected(selectedGroup)) {
                String groupName = null;
                String[] split = selectedGroup.split(",");
                if (split.length > 0) {
                    groupName = split[1];
                }
                memberList = searchVal != null && !searchVal.isEmpty() ? this.fGroupUtil.getPagedGroupMembers(groupName, offset, maxRows, searchVal) : this.fGroupUtil.getPagedGroupMembers(groupName, offset, maxRows, null);
            } else {
                memberList = !isServerSideProcEnabled ? this.fGroupUtil.getGroupMembers(group) : new ArrayList();
            }
            User[] arr = new User[memberList.size()];
            memberList.toArray(arr);
            if (isServerSideProcEnabled) {
                int filteredRecords = 0;
                int totalRecords = 0;
                if (this.serverSideGroupSelected(selectedGroup)) {
                    String[] split = selectedGroup.split(",");
                    totalRecords = this.fGroupUtil.getTotalGroupMembersCount(split[1]);
                    filteredRecords = searchVal != null && !searchVal.isEmpty() ? this.fGroupUtil.getFilteredGroupMembersCount(split[1], searchVal) : totalRecords;
                }
                dataTableFormat = new DataTableUserList(arr, this.fUserAccessor, this.fGroupManager, this.fCacheManager, this.fGroupUtil, draw, totalRecords, filteredRecords);
            } else {
                dataTableFormat = new DataTableUserList(arr, this.fUserAccessor, this.fGroupManager, this.fCacheManager, this.fGroupUtil);
            }
            response = Response.ok((Object)dataTableFormat).build();
        }
        catch (EntityMissingException e) {
            LOG.error((Object)("Could not get group members for: " + (group != null ? group : "null")), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (EntityException e) {
            LOG.error((Object)("Could not get group members for: " + (group != null ? group : "null")), (Throwable)e);
            response = Response.serverError().entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/group/search")
    @Produces(value={"application/json"})
    public Response searchGroups(@Context HttpServletRequest hsr, @QueryParam(value="query") String groupPrefix, @QueryParam(value="dlggroupid") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) throws EntityException, JAXBException {
        Response response;
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ConfluenceUser remoteUser = AuthenticatedUserThreadLocal.get();
        if (remoteUser != null) {
            List<String> groupList = this.fDgm.performSpaceDlgGroupSearch(groupPrefix, 100, remoteUser);
            String[] groupArr = new String[groupList.size()];
            groupList.toArray(groupArr);
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            result.put("groups", groupArr);
            response = Response.ok(result).build();
        } else {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return response;
    }

    @PUT
    @RequiresXsrfCheck
    @Path(value="/addusers")
    @Produces(value={"application/json"})
    public Response addUsersToGroups(@Context HttpServletRequest hsr, @QueryParam(value="spacekey") String spaceKey, @QueryParam(value="dlggroups") String dlgGroups, @FormParam(value="spaceusers") String spaceUsers, @FormParam(value="importViaGroups") String importViaGroups, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        Space validSpace;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error((Object)"Invalid Space, cannot add members in delegated resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (dlgGroups == null || dlgGroups.trim().isEmpty() || (spaceUsers == null || spaceUsers.trim().isEmpty()) && (importViaGroups == null || importViaGroups.trim().isEmpty())) {
            LOG.error((Object)("No groups or users specified: spaceGroups=" + dlgGroups + ", spaceUsers=" + spaceUsers));
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        try {
            JSONAddUserResultBean[] result = this.fDgm.addUsersToGroups(validSpace, dlgGroups, spaceUsers, importViaGroups);
            response = Response.ok((Object)result).build();
        }
        catch (AuthorizationException e) {
            LOG.error((Object)(AuthenticatedUserThreadLocal.getUsername() + " is not authorized to add users to delegated groups: " + dlgGroups));
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (EntityException e) {
            LOG.error((Object)("Could not get group members for space: " + spaceKey), (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unhandled error when adding users: " + (spaceUsers != null ? spaceUsers : "null") + " to group(s): " + dlgGroups + ", " + (importViaGroups != null ? importViaGroups : "null")), (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    @DELETE
    @RequiresXsrfCheck
    @Path(value="/removeusers")
    @Produces(value={"application/json"})
    public Response removeGroupMembers(@Context HttpServletRequest hsr, @QueryParam(value="spacekey") String spaceKey, @QueryParam(value="dlggroups") String dlgGroups, @QueryParam(value="usernames") String userNames, @QueryParam(value="viamembership") String viaMembershipGroups, @QueryParam(value="atltoken") String atlToken) throws EntityException {
        Response response;
        Space validSpace;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error((Object)"Invalid Space, cannot remove members in delegated resource", (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
        }
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (dlgGroups == null || dlgGroups.trim().isEmpty() || (userNames == null || userNames.trim().isEmpty()) && (viaMembershipGroups == null || viaMembershipGroups.trim().isEmpty())) {
            LOG.error((Object)("No groups or users specified: spaceGroups=" + dlgGroups + ", spaceUsers=" + userNames));
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (this.fDgm.isRemovingLastUser(dlgGroups, userNames, validSpace)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            List<String> failedToRemove = this.fDgm.removeUsersSpaceDlgGroups(dlgGroups, userNames, viaMembershipGroups, validSpace);
            response = Response.ok(failedToRemove).build();
        }
        catch (RemoveAllUsersException e) {
            LOG.error((Object)("Attempting to remove last member from group(s): " + dlgGroups));
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (AuthorizationException e) {
            LOG.error((Object)(AuthenticatedUserThreadLocal.getUsername() + " is not authorized to remove users from delegated groups: " + dlgGroups));
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unhandled error when removing group members: " + (userNames != null ? userNames : "null") + " from: " + dlgGroups + ", " + (viaMembershipGroups != null ? viaMembershipGroups : "null")), (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    private boolean serverSideGroupSelected(String spaceGroup) {
        return spaceGroup != null && !spaceGroup.equals("") && !spaceGroup.equals("null");
    }
}

