/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.Group;
import com.pluginpeople.confluence.csum.ao.CSUMBadGroupEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.util.IBadGroupNameFixer;
import com.pluginpeople.confluence.csum.util.OpStatus;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import com.pluginpeople.confluence.csum.util.ToolRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BadGroupNameFixerImpl
implements IBadGroupNameFixer,
DisposableBean {
    private static final int MAX_ENTITY_RETRIEVAL = 10;
    private static final Logger LOG = Logger.getLogger(BadGroupNameFixerImpl.class);
    private static OpStatus fStatus = OpStatus.IDLE;
    private ConfluenceUser fUser;
    private final ICSUMActiveObjectService fAo;
    private boolean fStop = false;
    private final TransactionTemplate fTxTemplate;
    private int fFixedCount = 0;
    private int fInitialCount = 0;
    private String fError;
    private final SpaceGroupUtil fGroupUtil;
    private final SpaceManager fSpaceMgr;

    @Autowired
    public BadGroupNameFixerImpl(ICSUMActiveObjectService ao, @ComponentImport TransactionTemplate txTemplate, SpaceGroupUtil groupUtil, @ComponentImport SpaceManager spaceMgr) {
        this.fAo = ao;
        this.fTxTemplate = txTemplate;
        this.fGroupUtil = groupUtil;
        this.fSpaceMgr = spaceMgr;
    }

    @Override
    public ToolRequest launch(ConfluenceUser user) {
        ToolRequest request;
        if (!OpStatus.RUNNING.equals((Object)fStatus)) {
            new Thread(this.getRunnable(user), "CSUMGroupNameFixer").start();
            request = new ToolRequest(true, null);
        } else {
            request = new ToolRequest(false, "Bad space group name fixer thread is already running on this node");
        }
        return request;
    }

    private Runnable getRunnable(final ConfluenceUser user) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AuthenticatedUserThreadLocal.isAnonymousUser()) {
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
                }
                BadGroupNameFixerImpl.this.fStop = false;
                BadGroupNameFixerImpl.this.fUser = user;
                BadGroupNameFixerImpl.this.fFixedCount = 0;
                fStatus = OpStatus.RUNNING;
                try {
                    CSUMBadGroupEntity[] someEnts;
                    BadGroupNameFixerImpl.this.fInitialCount = (Integer)BadGroupNameFixerImpl.this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

                        public Integer doInTransaction() {
                            return BadGroupNameFixerImpl.this.fAo.getBadGroupCount();
                        }
                    });
                    do {
                        someEnts = (CSUMBadGroupEntity[])BadGroupNameFixerImpl.this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<CSUMBadGroupEntity[]>(){

                            public CSUMBadGroupEntity[] doInTransaction() {
                                return BadGroupNameFixerImpl.this.fAo.getBadGroupEnts(10);
                            }
                        });
                        for (int i = 0; !BadGroupNameFixerImpl.this.fStop && i < someEnts.length; ++i) {
                            final CSUMBadGroupEntity entity = someEnts[i];
                            if (entity != null) {
                                BadGroupNameFixerImpl.this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                                    public Object doInTransaction() {
                                        Group renamedGroup;
                                        Space space = BadGroupNameFixerImpl.this.fSpaceMgr.getSpace(entity.getSpaceKey());
                                        String oldName = entity.getGroupName();
                                        if (space != null && oldName != null && (renamedGroup = BadGroupNameFixerImpl.this.fGroupUtil.convertToLowercase(space, oldName)) != null) {
                                            BadGroupNameFixerImpl.this.fFixedCount++;
                                            BadGroupNameFixerImpl.this.fAo.deleteBadGroupEnt(entity);
                                        }
                                        return null;
                                    }
                                });
                            }
                            BadGroupNameFixerImpl.this.sleepThread(50);
                        }
                    } while (!BadGroupNameFixerImpl.this.fStop && someEnts.length == 10);
                }
                catch (Exception ex) {
                    fStatus = OpStatus.ERROR;
                    BadGroupNameFixerImpl.this.fError = ex.getLocalizedMessage();
                    LOG.error((Object)"Unhandled exception occurred during running of CSUM group name fixer thread", (Throwable)ex);
                }
                finally {
                    if (!fStatus.equals((Object)OpStatus.ERROR)) {
                        fStatus = OpStatus.IDLE;
                        LOG.debug((Object)("CSUM group name fixer task completed without error and fixed " + BadGroupNameFixerImpl.this.fFixedCount + " out of " + BadGroupNameFixerImpl.this.fInitialCount + " groups"));
                    }
                }
            }
        };
    }

    private void sleepThread(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)"Bad group name fixer thread interrupted!");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void stop() {
        this.fStop = true;
    }

    public boolean isStop() {
        return this.fStop;
    }

    @Override
    public OpStatus getStatus() {
        return fStatus;
    }

    @Override
    public int getFixedCount() {
        return this.fFixedCount;
    }

    @Override
    public int getInitialCount() {
        return this.fInitialCount;
    }

    @Override
    public String getError() {
        return this.fError;
    }

    @Override
    public ConfluenceUser getInitiatingUser() {
        return this.fUser;
    }

    public void destroy() {
        LOG.debug((Object)"Component being destroyed, stopping fixer");
        this.fStop = true;
    }
}

