/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.GroupSearchResult;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@ReadOnlyAccessAllowed
@Path(value="/config")
@RequiresLicensedConfluenceAccess
public class ConfigResource
extends AbstractCSUMRestResource {
    private CrowdService fCrowdSvc;

    public ConfigResource(ICSUMCacheManager cacheManager, CrowdService crowdService, XsrfTokenService tokenService, CSUMPermissionUtil permissionUtil, SpaceManager spaceManager, PermissionManager permissionManager) {
        super(spaceManager, permissionUtil, tokenService, permissionManager);
        this.fCrowdSvc = crowdService;
    }

    @GET
    @Path(value="/searchgroups")
    @Produces(value={"application/json"})
    public Response searchGroups(@Context HttpServletRequest hsr, @QueryParam(value="query") String searchTerm, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        QueryBuilder.PartialEntityQuery allGroupsQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group());
        for (Group group : this.fCrowdSvc.search((Query)allGroupsQuery.with((SearchRestriction)new TermRestriction(GroupTermKeys.NAME, MatchMode.CONTAINS, (Object)searchTerm)).returningAtMost(50))) {
            groupNames.add(group.getName());
        }
        GroupSearchResult result = new GroupSearchResult();
        result.setGroups(groupNames);
        return Response.ok((Object)result).build();
    }
}

