/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractCSUMRestResource {
    private final SpaceManager fSpaceManager;
    private final CSUMPermissionUtil fCPermissionUtil;
    private final XsrfTokenService fTokenService;
    private final PermissionManager fPermissionManager;
    public static final String INVALID_SPACE_ERROR = "Invalid Space, could not find Space using spacekey: ";

    public AbstractCSUMRestResource(SpaceManager spaceManager, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, PermissionManager permissionManager) {
        this.fSpaceManager = spaceManager;
        this.fCPermissionUtil = permissionUtil;
        this.fTokenService = tokenService;
        this.fPermissionManager = permissionManager;
    }

    protected final boolean isTokenInvalidOrNotGlobalAdmin(HttpServletRequest hsr) {
        return this.isTokenInvalid(hsr) || !this.fCPermissionUtil.isGlobalAdmin();
    }

    protected final boolean isTokenInvalid(HttpServletRequest hsr) {
        return this.fCPermissionUtil.isLicenseValid() && this.fTokenService.validate(hsr).isDefined();
    }

    protected final boolean isCurrentUserAdminOrSystemAdmin() {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return this.fPermissionManager.isConfluenceAdministrator((User)currentUser) || this.fPermissionManager.isSystemAdministrator((User)currentUser);
    }

    protected final boolean isUnauthorizedOrBadXsrfToken(HttpServletRequest hsr, String spaceKey) {
        Space space;
        boolean isUnauthorized = spaceKey != null && !spaceKey.isEmpty() ? (space = this.fSpaceManager.getSpace(spaceKey)) == null || !this.fCPermissionUtil.isAuthorized(space) : !this.fCPermissionUtil.isGlobalAdmin();
        return isUnauthorized || this.fTokenService.validate(hsr).isDefined() || !this.fCPermissionUtil.isLicenseValid();
    }

    protected final boolean isPermitted(Space space) {
        boolean permitted = false;
        ConfluenceUser u = AuthenticatedUserThreadLocal.get();
        boolean isSysAdmin = this.fPermissionManager.isSystemAdministrator((User)u);
        boolean isSpaceAdmin = this.fPermissionManager.hasPermission((User)u, Permission.ADMINISTER, (Object)space);
        if (isSysAdmin || isSpaceAdmin && this.fCPermissionUtil.isLicenseValid()) {
            permitted = true;
        }
        return permitted;
    }

    protected Space getValidSpaceFromKey(String spaceKey) throws InvalidSpaceException {
        Space space;
        if (spaceKey != null && !spaceKey.isEmpty()) {
            space = this.fSpaceManager.getSpace(spaceKey);
            if (space == null) {
                throw new InvalidSpaceException("Bad Space Key despite passing Resource SpaceKey checks, using key: " + spaceKey);
            }
        } else {
            throw new InvalidSpaceException("SpaceKey was null, unable to find a space without a given spacekey");
        }
        Space ret = space;
        return ret;
    }
}

