/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.legacy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigUtil {
    private static final Log log = LogFactory.getLog(ConfigUtil.class);

    public static String getTrimmedStringOrNull(String value) {
        String result = value;
        if (result != null) {
            result = value.trim();
        }
        return result;
    }

    public static String getTrimmedStringOrUseDefaultIfValueIsNullOrTrimmedValueIsEmpty(String name, String value, String defaultValue) {
        String result = defaultValue;
        if (value != null) {
            result = value.trim();
            if ("".equals(value)) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static int getIntOrUseDefaultIfNullOrTrimmedValueIsEmptyOrNotAnInteger(String name, String value, int defaultValue) {
        int result = defaultValue;
        if (value != null) {
            value = value.trim();
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)("Could not parse " + name + " value of '" + value + "'. Using default value " + defaultValue));
            }
        }
        return result;
    }

    public static int getIntOrUseDefaultIfNullOrTrimmedValueIsEmptyOrNotAnIntegerOrUseRangeMinOrMaxIfOutOfRange(String name, String value, int defaultValue, int minValue, int maxValue) {
        int result = defaultValue;
        if (value != null) {
            value = value.trim();
            try {
                result = Integer.parseInt(value);
                if (result < minValue) {
                    log.debug((Object)("" + name + " value of " + value + " smaller than minimum " + minValue + ". Using minimum value " + minValue));
                    result = minValue;
                } else if (result > maxValue) {
                    log.debug((Object)("" + name + " value of " + value + " greater than maximum " + maxValue + ". Using maximum value " + maxValue));
                    result = maxValue;
                }
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)("Could not parse " + name + " value of '" + value + "'. Using default value " + defaultValue));
            }
        }
        return result;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static boolean isNotNullAndIsYesOrNo(String s) {
        return s != null && ("YES".equals(s) || "NO".equals(s));
    }

    public static boolean isNotNullAndIsYes(String s) {
        return s != null && "YES".equals(s);
    }

    public static boolean isNotNullAndIsIntGreaterThanZero(String s) {
        boolean result = false;
        if (s != null) {
            try {
                result = Integer.parseInt(s) > 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isNotNullAndIsIntBetween(String s, int min, int max) {
        boolean result = false;
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                result = i >= min && i <= max;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

