/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ao.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import org.apache.log4j.Logger;

public class V102PrefixSuffixCorrection
implements ActiveObjectsUpgradeTask {
    static final Logger LOG = Logger.getLogger(V102PrefixSuffixCorrection.class);
    static final ModelVersion VERSION = ModelVersion.valueOf((String)"102");

    public ModelVersion getModelVersion() {
        return VERSION;
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        if (currentVersion.isNewerThan(VERSION)) {
            return;
        }
        ao.migrate(new Class[]{CSUMConfigEntity.class});
        try {
            CSUMConfigEntity[] allConfigs;
            LOG.info((Object)"Ensuring that group prefix and suffix patterns are lowercase");
            for (CSUMConfigEntity config : allConfigs = (CSUMConfigEntity[])ao.find(CSUMConfigEntity.class)) {
                String suffix;
                String prefix = config.getGroupPrefixPattern();
                if (prefix != null && !prefix.isEmpty()) {
                    config.setGroupPrefixPattern(prefix.toLowerCase().replace("spacekey", "SPACEKEY"));
                }
                if ((suffix = config.getGroupSuffixPattern()) != null && !suffix.isEmpty()) {
                    config.setGroupSuffixPattern(suffix.toLowerCase().replace("spacekey", "SPACEKEY"));
                }
                config.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Upgrade problem: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }
}

