/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.fugue.Either;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.ITPublicCSUMDlgSpaceGroupManager;
import com.pluginpeople.confluence.csum.api.RemoveAllUsersException;
import com.pluginpeople.confluence.csum.api.beans.JSONAddUserResultBean;
import com.pluginpeople.confluence.csum.publicapi.components.PublicCSUMDlgSpaceGroupUtil;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITPublicApiDlgSpaceManagerImpl
implements ITPublicCSUMDlgSpaceGroupManager {
    private static final Logger LOG = Logger.getLogger(ITPublicApiDlgSpaceManagerImpl.class);
    private final PublicCSUMDlgSpaceGroupUtil fDelegatedSpaceUtil;
    private final TransactionTemplate fTxTemplate;

    @Autowired
    public ITPublicApiDlgSpaceManagerImpl(PublicCSUMDlgSpaceGroupUtil util, @ComponentImport TransactionTemplate txTemplate) {
        this.fDelegatedSpaceUtil = util;
        this.fTxTemplate = txTemplate;
    }

    public JSONAddUserResultBean[] addUsersToGroups(Space space, String groupNames, String userNames, String importViaGroups) throws AuthorizationException, EntityException, DuplicateException, GroupActionNotPermittedException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right((Object)this.fDelegatedSpaceUtil.addUsersToGroups(space, groupNames, userNames, importViaGroups));
            }
            catch (EntityException | AuthorizationException e) {
                LOG.error((Object)("Could not add users/groups to space group(s): " + groupNames + " in space " + (space != null ? space : "null")), e);
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception ex = (Exception)result.left().get();
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof DuplicateException) {
                throw (DuplicateException)ex;
            }
            if (ex instanceof GroupActionNotPermittedException) {
                throw (GroupActionNotPermittedException)ex;
            }
            if (ex instanceof EntityException) {
                throw (EntityException)((Object)ex);
            }
        }
        return (JSONAddUserResultBean[])result.getOrNull();
    }

    public List<String> removeUsersSpaceDlgGroups(String dlgGroups, String userNames, String membershipGroups, String spaceKey) throws EntityException, AuthorizationException, DuplicateException, GroupActionNotPermittedException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right(this.fDelegatedSpaceUtil.removeUsersSpaceDlgGroups(dlgGroups, userNames, membershipGroups, spaceKey));
            }
            catch (EntityException | AuthorizationException | RemoveAllUsersException e) {
                LOG.error((Object)("Could not add users/groups to space group(s): " + dlgGroups + " in space " + (spaceKey != null ? spaceKey : "null")), e);
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception ex = (Exception)result.left().get();
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof DuplicateException) {
                throw (DuplicateException)ex;
            }
            if (ex instanceof GroupActionNotPermittedException) {
                throw (GroupActionNotPermittedException)ex;
            }
            if (ex instanceof EntityException) {
                throw (EntityException)((Object)ex);
            }
        }
        return (List)result.getOrNull();
    }
}

