var tinymce = require('tinymce');

function plugin() {
    var buttonPressed = false;

    var sourceStyleArray = []

    var destinationStyleArray = []

    var differenceLength = 0

    var ctrlPressed = false;

    var handlersInitiated = false;

    var idoc = null;
    return {
        init: function (ed) {
            //Adding button to editor bar
            AJS.$("#rte-toolbar .toolbar-primary").append($("<ul class='aui-buttons'></ul>")
                .addClass("rte-toolbar-group-example"));


            //Adding shortcuts
            ed.addShortcut('meta+shift+c', 'Format Painter - Copy style', function () {
                ed.execCommand('mcePaint')
            })

            ed.addShortcut('meta+shift+v', 'Format Painter - Paste style', function () {
                pasteStyle()
            })

            //Button click event
            ed.addCommand('mcePaint', function (itemInAddCommand) {
                idoc = idoc ? idoc : getIdoc()

                if (!handlersInitiated) {
                    initMultipleSelection();
                    initCtrlZ();
                    //initCustomCursor();
                    handlersInitiated = true;
                }

                const selection = idoc.getSelection()
                const anchorNode = selection.anchorNode

                sourceStyleArray = []
                destinationStyleArray = []

                if ((selection.type === "Caret" || selection.type === "None") && !buttonPressed) {
                    return AJS.flag({
                        type: 'info',
                        title: 'Selection error!',
                        body: 'Please, select text before copying style.',
                        closeable: 'true',
                        close: 'auto'
                    });
                }

                sourceStyleArray = getStyleArray(selection, false)

                invertButton()
            });

            ed.addButton('format-painter-button', {
                //default value of "toolbar" is "toolbar-primary"
                className: 'format-painter-icon',
                tooltip: AJS.I18n.getText("pl.softlist.fpaint.button.tooltip"),
                cmd: "mcePaint",
                locationGroup: "rte-toolbar-group-example",
                weight: 0,
                onclick: function () { }
            });

            ed.on('mouseup', function (e) {
                pasteStyle()
            })

            function pasteStyle() {
                if (!idoc) return

                const selection = idoc.getSelection()

                if (selection.type === "Range" && buttonPressed === true) {

                    styleSelectedText(selection)

                    if (!ctrlPressed) invertButton();
                }
            }

            function getStyleArray(selection, isDestination) {
                const selectionTags = AJS.$('<div/>').html(getSelectionWithTags(selection))
                const anchorNode = selection.anchorNode
                const array = getHtmlTags(anchorNode)

                //Image selected

                if ((selectionTags.find('img').length === 1) && !isDestination) {
                    const imgAlign = getImgAlign(selectionTags.find('img'))
                    const imgSize = getImgSize(selectionTags.find('img'))
                    const imgIsThumbnail = isImgThumbnail(selectionTags.find('img'))
                    const imgBorder = getImgBorder(selectionTags.find('img'))
                    const imgQueryParams = getImgQueryParams(selectionTags.find('img'))

                    array.push(imgAlign)
                    array.push(imgSize)
                    array.push(imgIsThumbnail)
                    array.push(imgBorder)
                    array.push(imgQueryParams)

                    return filterStyleArray(array)
                }

                const align = getTextAlign()
                const color = getTextColor(anchorNode)
                const list = getListType()
                const backgroundColor = getCellBackground(anchorNode)

                if (align) array.push(align)
                if (color && !isDestination) array.push(color)
                if (list) array.push(list)
                if (backgroundColor && !isDestination) array.push(backgroundColor)
                //if (backgroundColor) array.push(backgroundColor)

                return filterStyleArray(array)
            }

            function getTextAlign() {
                if (AJS.$('#rte-button-justifyleft').hasClass('active')) return 'ALIGN-LEFT'
                if (AJS.$('#rte-button-justifycenter').hasClass('active')) return 'ALIGN-CENTER'
                if (AJS.$('#rte-button-justifyright').hasClass('active')) return 'ALIGN-RIGHT'
            }

            function getListType() {
                if (AJS.$('#rte-button-bullist').hasClass('active')) return 'BULLIST'
                if (AJS.$('#rte-button-numlist').hasClass('active')) return 'NUMLIST'
                if (AJS.$('#rte-button-tasklist').hasClass('active')) return 'TASKLIST'
            }

            function getCellBackground(node) {
                node = deeperNode(node)

                while (node.id !== 'tinymce') {
                    if (node.tagName == 'TD' || node.tagName == 'TH') {
                        const classNames = node.className.split(" ")
                        const hightLightClass = classNames.find(function(className) {
                            return className.startsWith("highlight")
                        })
                        if (hightLightClass) {
                            const trimmed = hightLightClass.slice(10)
                            return "bg_" + trimmed
                        }
                    }
                    // Move up in the tree
                    node = node.parentNode;
                }
            }

            function getTextColor(node) {
                node = deeperNode(node)

                while (node.id !== 'tinymce') {
                    if (node.tagName == 'P' || node.tagName == 'SPAN') {
                        const color = AJS.$(node).css('color')
                        //rgb(23, 43, 77) - default color (has no button on panel)
                        if (color && (color !== 'rgb(23, 43, 77)')) {
                            return rgb2hex(color).toUpperCase()
                        }
                    }
                    // Move up in the tree
                    node = node.parentNode;
                }
            }

            function getImgAlign(node) {
                const classes = AJS.$(node).attr('class').split(/\s+/);
                const floatAttr = AJS.$(node).attr('float')
                var result = ''

                //images and emoticons use both "image-..." class and style:"float: ..."  
                classes.forEach(function (item) {
                    if (item.startsWith('image-')) {
                        result = item.slice(6)
                    }
                })

                if (floatAttr) {
                    result = floatAttr
                }

                if (result !== '') {
                    return 'IMG-ALIGN-' + result
                }

                return 'IMG-ALIGN-NONE'
            }

            function getImgSize(node) {
                const height = AJS.$(node).attr('height')
                const width = AJS.$(node).attr('width')

                if (height) {
                    return 'IMG-HEIGHT-' + height
                }

                if (width) {
                    return 'IMG-WIDTH-' + width
                }

                return 'IMG-SIZE-ORIGINAL'
            }

            function isImgThumbnail(node) {
                return 'IMG-THUMBNAIL-' + AJS.$(node).hasClass('confluence-thumbnail').toString().toUpperCase()
            }

            function getImgBorder(node) {
                return 'IMG-BORDER-' + AJS.$(node).hasClass('confluence-content-image-border').toString().toUpperCase()
            }

            function getImgQueryParams(node) {
                const queryParams = AJS.$(node).attr('confluence-query-params')

                if (queryParams) {
                    return 'IMG-QUERY-' + queryParams
                }

                return 'IMG-QUERY-EMPTY'
            }

            function clearFormatting() {
                const bullist = AJS.$('#rte-button-bullist')
                const numlist = AJS.$('#rte-button-numlist')
                const tasklist = AJS.$('#rte-button-tasklist')

                AJS.$('#rte-removeformat')[0].click()

                if (bullist.hasClass('active')) bullist.click()
                if (numlist.hasClass('active')) numlist.click()
                if (tasklist.hasClass('active')) tasklist.click()
            }

            function rgb2hex(c) {
                return '#' + c.match(/\d+/g).map(function (x) {
                    return (+x).toString(16).padStart(2, 0)
                }).join('')
            }

            function getHtmlTags(node) {
                const tags = ['B', 'CODE', 'S', 'SUB', 'SUP', 'STRONG', 'EM', 'I', 'U', 'PRE', 'BLOCKQUOTE', 'H1', 'H2', 'H3', 'H4', 'H5', 'H6']
                const styleTags = []

                node = deeperNode(node)

                while (node.id !== 'tinymce') {
                    if (tags.includes(node.tagName)) {
                        styleTags.push(node.tagName)
                    }
                    node = node.parentNode
                }

                return styleTags


            }

            function initMultipleSelection() {
                if (idoc) {
                    AJS.$(idoc).on('keyup keydown', function (e) {
                        ctrlPressed = e.ctrlKey
                    })
                }
            }

            function initCtrlZ() {
                if (idoc) {
                    AJS.$(idoc).on('keyup', function (e) {
                        if (e.ctrlKey && (event.key === 'z' || event.key === 'я')) {
                            if (buttonPressed) {
                                invertButton()
                            }

                            //press "undo" until all styles are canceled
                            if (differenceLength > 0) {
                                for (var i = 0; i < differenceLength - 1; i++) {
                                    AJS.$('#rte-button-undo a')[0].click()
                                }

                                differenceLength = 0

                                clearSelection()
                            }
                        }
                    })
                }
            }

            function filterStyleArray(array) {
                array = array.map(function (tag) {
                    if (tag === 'B') {
                        return 'STRONG'
                    }

                    if (tag === 'I') {
                        return 'EM'
                    }

                    return tag
                })

                return array
            }

            function getArraysDifference(array1, array2) {
                return array2
                    .filter(function (item) { return !array1.includes(item) })
                    .concat(array1.filter(function (item) { return !array2.includes(item) }));
            }

            function orderDifference(array) {
                var matchNUMLIST = array.indexOf('NUMLIST')

                if (++matchNUMLIST) {
                    array.splice(matchNUMLIST - 1, 1)
                    array.push('NUMLIST')
                }

                var matchBULLIST = array.indexOf('BULLIST')

                if (++matchBULLIST) {
                    array.splice(matchBULLIST - 1, 1)
                    array.push('BULLIST')
                }

                var matchTASKLIST = array.indexOf('TASKLIST')

                if (++matchTASKLIST) {
                    array.splice(matchTASKLIST - 1, 1)
                    array.push('TASKLIST')
                }

                return array
            }

            function removeDoubleListType(array) {
                const last = array[array.length - 1]
                const secondToLast = array[array.length - 2]
                const listTypes = ['BULLIST', 'NUMLIST', 'TASKLIST']
                if (listTypes.includes(last) && listTypes.includes(secondToLast)) {
                    array = array.slice(0, -2)
                    array.push(sourceStyleArray.find(function (item) {
                        return (item === 'BULLIST') || (item === 'NUMLIST') || (item === 'TASKLIST')
                    }))
                }

                return array
            }

            function styleSelectedText(selection) {
                destinationStyleArray = getStyleArray(selection, true)

                var difference = getArraysDifference(sourceStyleArray, destinationStyleArray)


                const hasSourseBg = sourceStyleArray.find(function(tag) {
                    return tag.startsWith("bg_")
                })

                if (!hasSourseBg) {
                    difference.push('remove-highlight')
                }
                difference = orderDifference(difference)

                difference = removeDoubleListType(difference)

                uiClicks(difference, selection)

                clearSelection()
            }

            function uiClicks(styleTags, selection) {

                // const uiClicks2 = function(tag) {
                //     const conf = confirm('Do ' + tag + '?')

                //     if (!conf) return;

                //     console.log('tag: ', {tag: tag})

                //     if (tag === 'BULLIST') return AJS.$('#rte-button-bullist a')[0].click()
                //     if (tag === 'NUMLIST') return AJS.$('#rte-button-numlist a')[0].click()
                //     if (tag === 'TASKLIST') return AJS.$('#rte-button-tasklist a')[0].click()

                //     //

                //     if (tag === 'STRONG' || tag  === 'B') return AJS.$('#rte-button-bold a')[0].click();
                //     if (tag === 'EM') return AJS.$('#rte-button-italic a')[0].click()
                //     if (tag === 'U') return AJS.$('#rte-button-underline a')[0].click()

                //     //

                //     if (tag === 'S') return AJS.$('#rte-strikethrough')[0].click()
                //     if (tag === 'SUB') return AJS.$('#rte-sub')[0].click()
                //     if (tag === 'SUP') return AJS.$('#rte-sup')[0].click()
                //     if (tag === 'CODE') return AJS.$('#rte-monospace')[0].click()

                //     //

                //     if (tag === 'H1') return AJS.$('#format-dropdown-display-menu .format-h1')[0].click()
                //     if (tag === 'H2') return AJS.$('#format-dropdown-display-menu .format-h2')[0].click()
                //     if (tag === 'H3') return AJS.$('#format-dropdown-display-menu .format-h3')[0].click()
                //     if (tag === 'H4') return AJS.$('#format-dropdown-display-menu .format-h4')[0].click()
                //     if (tag === 'H5') return AJS.$('#format-dropdown-display-menu .format-h5')[0].click()
                //     if (tag === 'H6') return AJS.$('#format-dropdown-display-menu .format-h6')[0].click()
                //     if (tag === 'PRE') return AJS.$('#format-dropdown-display-menu .format-pre')[0].click()
                //     if (tag === 'BLOCKQUOTE') return AJS.$('#format-dropdown-display-menu .format-blockquote')[0].click()

                //     //

                //     if (tag === 'ALIGN-LEFT') return AJS.$('#rte-button-justifyleft a')[0].click()
                //     if (tag === 'ALIGN-CENTER') return AJS.$('#rte-button-justifycenter a')[0].click()
                //     if (tag === 'ALIGN-RIGHT') return AJS.$('#rte-button-justifyright a')[0].click()

                //     //color

                //     if (tag[0] === '#') {
                //         const selector = '.color-picker a[data-color="' + tag.slice(1) + '"]'
                //         return AJS.$(selector)[0].click()
                //     }

                // }

                // for(var i = 0; i < styleTags.length; i++) {
                //     var tag2 = styleTags[i]
                //     console.log('1 tag2:', tag2)
                //     const func = uiClicks2.bind(null, tag2)
                //     setTimeout(func, (3000*i + 50))
                // }

                //////////////////////////////////////////////////////////////////////////

                //FIND STYLES INSIDE TEXT (NOT HIGHLIGHTED BY TOOLBAR BUTTONS)

                //const text = getSelectionWithTags(selection)
                const strong = AJS.$('#rte-button-bold')
                const em = AJS.$('#rte-button-italic')
                const u = AJS.$('#rte-button-underline')
                const black = AJS.$('.color-picker a[data-color="000000"]')

                const selectionTags = AJS.$('<div/>').html(getSelectionWithTags(selection))

                const strongTags = selectionTags.find('b').length
                const emTags = selectionTags.find('em').length
                const uTags = selectionTags.find('u').length
                const imgDestination = Boolean(selectionTags.find('img').length)
                const imgSource = Boolean(styleTags.find(function (item) { return item.startsWith('IMG') }))


                if (imgDestination && imgSource) {
                    const img = selection.anchorNode.children[0]

                    //differenceLength = styleTags.length - 4

                    return styleTags.forEach(function (tag) {
                        //image tags
                        if (tag.startsWith('IMG-ALIGN')) {
                            return AJS.$(img)
                                .removeClass('image-left')
                                .removeClass('image-center')
                                .removeClass('image-right')
                                .addClass('image-' + tag.slice(10).toLowerCase())
                        }

                        if (tag.startsWith('IMG-HEIGHT')) {
                            return AJS.$(img)
                                .removeAttr('width')
                                .attr('height', tag.slice(11))
                        }

                        if (tag.startsWith('IMG-WIDTH-')) {
                            return AJS.$(img)
                                .removeAttr('height')
                                .attr('width', tag.slice(10))
                        }

                        if (tag.startsWith('IMG-THUMBNAIL')) {
                            const splicedURL = AJS.$(img).attr('src').split('/')

                            if (tag.slice(11) === 'TRUE') {
                                splicedURL[2] = 'thumbnail'

                                return AJS.$(img)
                                    .addClass('confluence-thumbnail')
                                    .attr('src', splicedURL.join('/'))
                            }

                            splicedURL[2] = 'attachments'
                            return AJS.$(img)
                                .removeClass('confluence-thumbnail')
                                .attr('src', splicedURL.join('/'))
                        }

                        if (tag.startsWith('IMG-BORDER')) {
                            if (tag.slice(11) === 'TRUE') {
                                return AJS.$(img)
                                    .addClass('confluence-content-image-border')
                            }

                            return AJS.$(img)
                                .removeClass('confluence-content-image-border')

                        }

                        if (tag.startsWith('IMG-QUERY')) {
                            const query = tag.slice(10)
                            const src = AJS.$(img).attr('src').split('effects')[0]

                            if (query === 'EMPTY') {
                                return AJS.$(img)
                                    .removeAttr('confluence-query-params')
                                    .attr('src', src)
                            }

                            return AJS.$(img)
                                .attr('confluence-query-params', query)
                                .attr('src', src + "&" + query)
                        }
                    })

                }

                differenceLength = styleTags.length

                black.click()
                black.click()
                differenceLength = differenceLength + 2

                if (strongTags && !AJS.$(strong).hasClass('active')) {
                    strong.click()
                    strong.click()
                    differenceLength = differenceLength + 2
                }

                if (emTags && !AJS.$(em).hasClass('active')) {
                    em.click()
                    em.click()
                    differenceLength = differenceLength + 2
                }

                if (uTags && !AJS.$(u).hasClass('active')) {
                    u.click()
                    u.click()
                    differenceLength = differenceLength + 2
                }

                styleTags.forEach(function (tag) {

                    if (tag === 'BULLIST') return AJS.$('#rte-button-bullist a')[0].click()
                    if (tag === 'NUMLIST') {
                        return AJS.$('#rte-button-numlist a')[0].click()
                    }
                    if (tag === 'TASKLIST') return AJS.$('#rte-button-tasklist a')[0].click()

                    //

                    if (tag === 'STRONG' || tag === 'B') return AJS.$(strong).click();
                    if (tag === 'EM') return AJS.$(em).click()
                    if (tag === 'U') return AJS.$(u).click()

                    //

                    if (tag === 'S') return AJS.$('#rte-strikethrough')[0].click()
                    if (tag === 'SUB') return AJS.$('#rte-sub')[0].click()
                    if (tag === 'SUP') return AJS.$('#rte-sup')[0].click()
                    if (tag === 'CODE') return AJS.$('#rte-monospace')[0].click()

                    //

                    if (tag === 'H1') return AJS.$('#format-dropdown-display-menu .format-h1')[0].click()
                    if (tag === 'H2') return AJS.$('#format-dropdown-display-menu .format-h2')[0].click()
                    if (tag === 'H3') return AJS.$('#format-dropdown-display-menu .format-h3')[0].click()
                    if (tag === 'H4') return AJS.$('#format-dropdown-display-menu .format-h4')[0].click()
                    if (tag === 'H5') return AJS.$('#format-dropdown-display-menu .format-h5')[0].click()
                    if (tag === 'H6') return AJS.$('#format-dropdown-display-menu .format-h6')[0].click()
                    if (tag === 'PRE') return AJS.$('#format-dropdown-display-menu .format-pre')[0].click()
                    if (tag === 'BLOCKQUOTE') return AJS.$('#format-dropdown-display-menu .format-blockquote')[0].click()

                    //

                    if (tag === 'ALIGN-LEFT') return AJS.$('#rte-button-justifyleft a')[0].click()
                    if (tag === 'ALIGN-CENTER') return AJS.$('#rte-button-justifycenter a')[0].click()
                    if (tag === 'ALIGN-RIGHT') return AJS.$('#rte-button-justifyright a')[0].click()

                    //color

                    if (tag[0] === '#') {
                        const selector = '.color-picker a[data-color="' + tag.slice(1) + '"]'
                        if (!AJS.$(selector).length) {
                            //color not in palette
                            return
                        }
                        return AJS.$(selector)[0].click()
                    }

                    if (tag === 'remove-highlight') {
                        if (AJS.$('.table-highlight-picker .remove-highlight')[0]) {
                            return AJS.$('.table-highlight-picker .remove-highlight')[0].click()
                        } else {
                            return
                        }
                        
                    }

                    if (tag.startsWith("bg_")) {
                        if (!AJS.$('.table-highlight-picker a[data-highlight-colour="' + tag.slice(3) + '"]').length) {
                            //color not in palette
                            return
                        }
                        return AJS.$('.table-highlight-picker a[data-highlight-colour="' + tag.slice(3) + '"]')[0].click()
                    }
                })
            }

            function clearSelection() {
                if (idoc.getSelection) {
                    idoc.getSelection().removeAllRanges();
                }
            }

            function deeperNode(node) {
                while (node.childElementCount === 1) {
                    node = node.firstChild
                }

                return node
            }

            function getIdoc() {
                const tinymceIframe = AJS.$('iframe').each(function () {
                    if (AJS.$(this).contents().find('body').attr('id') === 'tinymce') {
                        return AJS.$(this)
                    }
                })[0]

                const idoc = tinymceIframe.contentDocument || tinymceIframe.contentWindow.document

                return idoc
            }

            function getSelectionWithTags(selection) {
                var html = '';
                if (selection.rangeCount) {
                    var container = document.createElement('div');
                    for (var i = 0, length = selection.rangeCount; i < length; ++i) {
                        container.appendChild(selection.getRangeAt(i).cloneContents());
                    }
                    html = container.innerHTML;
                }
                return html;
            }

            function invertButton() {
                const button = AJS.$('.rte-toolbar-group-example a')

                buttonPressed = !buttonPressed
                buttonPressed ? button.addClass('active') : button.removeClass('active')
            }
        }
    }
}

// Register plugin
tinymce.PluginManager.add('fpaint', plugin);

require('confluence-editor/loader/tinymce-bootstrap').addTinyMcePluginInit(function (settings) {
    settings.plugins += ",fpaint";
});
