/*
 * Decompiled with CFR 0.152.
 */
package pl.softlist.fpaint;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseHelper {
    private PluginLicenseManager pluginLicenseManager;
    private LicenceType licenceType = LicenceType.PROD;

    @Autowired
    LicenseHelper(@ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public boolean isLicenseValid() {
        switch (this.licenceType) {
            case PROD: {
                return this.isLicenseValidProd();
            }
            case UNLIM: {
                return true;
            }
        }
        return false;
    }

    private boolean isLicenseValidProd() {
        Option l = this.pluginLicenseManager.getLicense();
        if (l.isDefined()) {
            boolean isValid = ((PluginLicense)l.get()).isValid();
            return isValid;
        }
        return false;
    }

    static enum LicenceType {
        PROD,
        UNLIM;

    }
}

