/*
 * Copyright (c) 2020 Appfire Technologies, Inc.
 * All rights reserved.
 *This software is licensed under the provisions of the "Bob Swift Atlassian Apps EULA"
 *(https://bobswift.atlassian.net/wiki/x/WoDXBQ) as well as under the provisions of
 *the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product”
 *(http://www.atlassian.com/licensing/marketplace/termsofuse).
 * 
 * See the LICENSE file for more details.
 * 
 */

if (!window.bobswift) {
    window.bobswift = new Object();
}
if (!window.bobswift.html) {
    window.bobswift.html = new Object();
}
if (!window.bobswift.html.profileconfig) {
    window.bobswift.html.profileconfig = new Object();
}

AJS.toInit(function($) {
  //if profile operation added/edited/deleted, the make the profile tab active else default global-config tab will be active
    if(window.location.href.includes('profileActive=true')){
        focusProfileTab();
    }
    
    /**
     * Focus given to clicked tab in the add/edit profile dialog
     */
   function focusProfileTab(){
        $("#global-config-tab").removeClass("active-tab");
        $("#tab-global-config").removeClass("active-pane");
        $("#html-manage-profiles-tab").addClass("active-tab");
        $("#tab-global-html-profile").addClass(" active-pane");
    }
    //Create Profile Screen, Add Profile Button
    AJS.$("#htmlAddProfile").click(function(e) {
        var $dialog = $(org.swift.confluence.html.configtemplates.profileAddEditorDlg({
            'profileObj' : null
        }));
        $dialog.appendTo("#admin-body-content");
        AJS.dialog2($dialog).show();
        AJS.dialog2("#html-config-profile-dialog").on("hide", function() {
            $(this).remove();
            $('.appfire-html-profile-help-dialogs').remove(); //On hiding editprofile dialog, remove the help dialogs as well.
        });
        //Save or Update profile button click handler
        AJS.$("#html-create-profile-button").click(window.bobswift.html.profileconfig.saveProfile);
        // On Add/Edit profile dialog cancel , on cancel do not reload page, only hide the dialog
        AJS.$(".html-add-edit-profile-close").click(function(e) {
            e.preventDefault();
            AJS.dialog2("#html-config-profile-dialog").hide();
        });
    });
    AJS.$(".htmlEditProfileLink").click(function(e) {
        var profileRow = $(this).closest("tr");
        var profileObj = typeof $(profileRow).find(".htmlEditProfileLink").data("profile") == "object" ? $(profileRow).find(".htmlEditProfileLink").data("profile") : JSON.parse($(profileRow).find(".htmlEditProfileLink").data("profile"));
        var $dialog = $(org.swift.confluence.html.configtemplates.profileAddEditorDlg({
            'profileObj' : profileObj
        }));
        $dialog.appendTo("#admin-body-content");
        AJS.dialog2($dialog).show();
        AJS.dialog2("#html-config-profile-dialog").on("hide", function() {
            $(this).remove();
            $('.appfire-html-profile-help-dialogs').remove(); //On hiding editprofile dialog, remove the help dialogs as well.
        });
        //Save or Update profile button click handler
        AJS.$("#html-create-profile-button").click(window.bobswift.html.profileconfig.saveProfile);
        // On Add/Edit profile dialog cancel , on cancel do not reload page, only hide the dialog
        AJS.$(".html-add-edit-profile-close").click(function(e) {
            e.preventDefault();
            AJS.dialog2("#html-config-profile-dialog").hide();
        });
    });
    $(document).on("click", ".htmlDeleteProfileLink", function() {
        var profileRow = $(this).closest("tr");
        var profileName = $(profileRow).find(".profileName").text().trim();
        window.bobswift.html.profileconfig.displayDeleteDialog(profileName);
    });
});

    window.bobswift.html.profileconfig.onProfileTypeChange = function() {
        window.bobswift.html.profileconfig.clearFormFields();
        if (AJS.$("#profileType").val().toLowerCase() == "gitlab") {
            AJS.$("#headerParams").val("Private-Token: $accessToken");
            AJS.$("#url").val("https://gitlab.com/api/v4/projects");
        } else if (AJS.$("#profileType").val().toLowerCase() == "github") {
            AJS.$("#headerParams").val(
                    "Authorization: token  $accessToken , Accept: application/vnd.github.v3.raw");
            AJS.$("#url").val("https://api.github.com/repos");
        }
    }

    window.bobswift.html.profileconfig.clearFormFields = function() {
        //Clear existing value
        AJS.$("#url").val("");
        AJS.$("#urlParams").val("");
        AJS.$("#headerParams").val("");
    }

    window.bobswift.html.profileconfig.saveProfile = function(event) {
        event.preventDefault();
        validForm = window.bobswift.html.profileconfig.validateFields();
        if (validForm) {
            var profileAction = $("#html-create-profile-button").data('profileaction');
            var profileName = $("#html-create-profile-button").data('profilename');
            var isEncrypted = $("#html-create-profile-button").data('isencrypted');
            
            if(!isEncrypted){
                var $dialog = $(org.swift.confluence.html.configtemplates.editOldProfileConfirmationDialog({
                    'profileName' : profileName
                }));
                $dialog.appendTo("#admin-body-content");
                AJS.dialog2($dialog).show();
                AJS.dialog2("#html-edit-profile-confirmation-dialog").on("hide", function() {
                    $(this).remove();
                });
                // Confirm button click handler
                $("#html-confirm-edit-profile-button").click(function(e) {
                    e.preventDefault();
                    window.bobswift.html.profileconfig.submitProfileForm(profileAction, profileName);
                    AJS.dialog2("#html-edit-profile-confirmation-dialog").hide();
                });
    
                // On Delete profile dialog cancel , do not reload page, only hide the dialog
                AJS.$(".confirm-edit-profile-close").click(function(e) {
                    e.preventDefault();
                    AJS.dialog2("#html-edit-profile-confirmation-dialog").hide();
                });
            }else{
               window.bobswift.html.profileconfig.submitProfileForm(profileAction, profileName);
            }
        } else {
            return false; //Seems some validation error.
        }
    }

    window.bobswift.html.profileconfig.submitProfileForm = function(profileAction,
            existingProfileName) {
        //send profile data to server
        var profileName = AJS.$("#profileName").val().trim();
        var profileType = AJS.$("#profileType").val().trim();
        var url = AJS.$("#url").val().trim();
        var user = AJS.$("#user").val().trim();
        var password = AJS.$("#password").val().trim();
        var urlParams = AJS.$("#urlParams").val().trim();
        var headerParams = AJS.$("#headerParams").val().trim();
        var accessToken = AJS.$("#accessToken").val().trim();
        var profileId = AJS.$("#profileId").val().trim();
        var profileObj = {
            "profileName" : profileName,
            "profileType" : profileType,
            "url" : url,
            "user" : user,
            "password" : password,
            "urlParams" : urlParams,
            "headerParams" : headerParams,
            "accessToken" : accessToken,
            "ID" : profileId
        };
        var profileData = JSON.stringify(profileObj);
        AJS.$.ajax({
            url : AJS.contextPath() + '/rest/bobswift/html/1.0/profiles/' + existingProfileName,
            type : (profileAction.trim() == "add" ? "POST" : "PUT"),
            contentType : "application/json; charset=utf-8",
            dataType : "json",
            data : profileData,
            success : function(data, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    AJS.dialog2("#html-config-profile-dialog").hide();
                    window.location.href = "./configure.action?profileActive=true";
                }
            },
            error : function(jqXHR, textStatus, errorThrown) {
                window.bobswift.html.profileconfig.updateStatusField("html-config-profiles-status",
                        "error", jqXHR.responseText);
            }
        })
    }
    window.bobswift.html.profileconfig.updateStatusField = function(field, status, error) {
        var successMessage = AJS.I18n
                .getText("org.swift.confluence.html.config.profile.save.success");
        var successHtml = "<span class=\"aui-icon aui-icon-small aui-iconfont-approve\"></span>&nbsp;&nbsp;<span id=\"message\">"
                + successMessage + "</span>";
        var errorHtml = "<div class=\"error\"><span class=\"aui-icon  aui-icon-small aui-icon-error aui-iconfont-error\"></span>&nbsp;&nbsp;<span id=\"message\">"
                + error + "</span></div>";
        if (status == "success") {
            $("#" + field).html(successHtml);
        } else if (status == "error") {
            $("#" + field).html(errorHtml);
        }
    }
    
    window.bobswift.html.profileconfig.validateFields = function() {
        window.bobswift.html.profileconfig.clearAllExistingErrorMessages();
        var validForm = window.bobswift.html.profileconfig.addValidateClass($("#profileName"));
        if (($("#profileType").val() == "GitHub" || $("#profileType").val() == "GitLab") && $("#accessTokenExists").val() != "yes") {
            validForm = window.bobswift.html.profileconfig.addValidateClass($("#accessToken")) && validForm;
        }
        return validForm;
    }
    window.bobswift.html.profileconfig.clearAllExistingErrorMessages = function(){
        $("#config-profile-form :input").each(function(index,element){
                $("#"+element.id).removeClass("appfire-html-field-validation");
                $("#"+element.id).siblings(".error").css({"display":"none"});
            })
    }
    window.bobswift.html.profileconfig.addValidateClass = function($field) {
        if ($field.prop("disabled"))
            return true;
        if (!$field.val().trim()) {
            if (!$field.hasClass("appfire-html-field-validation")) {
                $field.addClass("appfire-html-field-validation");
                if($field.attr("name")==='accessToken'){
                    
                    var gitlabURL = AJS.I18n.getText("org.swift.confluence.html.config.accessToken.generate.token.gitlab");
                    var githubURL = AJS.I18n.getText("org.swift.confluence.html.config.accessToken.generate.token.github");
                    
                    if ($("#profileType").val() == "GitLab"){
                        $("#htmlTokenGeneratingHelpLink").attr('href',gitlabURL);
                    }
                    else if($("#profileType").val() == "GitHub"){
                        $("#htmlTokenGeneratingHelpLink").attr('href',githubURL);
                    }
                }
                $field.siblings(".error").css({"display":"block"});
            }
            return false;
        } else if ($field.attr('name') === "profileName" && $field.val().match(/[/\\]/g) && $field.val().match(/[/\\]/g).length > 0) {
            if (!$field.hasClass("appfire-html-field-validation")) {
                $field.addClass("appfire-html-field-validation");
                $field.siblings(".error").css({"display":"block"});
            }
            return false;
        }
        else {
            $field.removeClass("appfire-html-field-validation");
            $field.siblings(".error").css({"display":"none"});
            return true;
        }
    }
  //For Delete dialog
    window.bobswift.html.profileconfig.displayDeleteDialog = function(profileName) {
        var $dialog = $(org.swift.confluence.html.configtemplates.deleteDialog({
            'profileName' : profileName
        }));
        $dialog.appendTo("#admin-body-content");
        AJS.dialog2($dialog).show();
        AJS.dialog2("#html-delete-profile-dialog").on("hide", function() {
            $(this).remove();
        });
        // Delete profile button click handler
        $("#html-delete-profile-button").click(function(e) {
            e.preventDefault();
            var profileName = $(this).data('profilename');
            window.bobswift.html.profileconfig.deleteProfile(profileName);
        });

        // On Delete profile dialog cancel , do not reload page, only hide the dialog
        AJS.$(".html-delete-profile-close").click(function(e) {
            e.preventDefault();
            AJS.dialog2("#html-delete-profile-dialog").hide();
        });

    }

    window.bobswift.html.profileconfig.deleteProfile = function(profileName) {
        AJS.$.ajax({
            url : AJS.contextPath() + '/rest/bobswift/html/1.0/profiles/' + encodeURIComponent(profileName),
            type : "DELETE",
            contentType : "application/json; charset=utf-8",
            dataType : "json",
            success : function(data, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    AJS.dialog2("#html-delete-profile-dialog").hide();
                    window.location.href = "./configure.action?profileActive=true";
                }
            },
            error : function(jqXHR, textStatus, errorThrown) {
                window.bobswift.html.profileconfig.updateStatusField("html-config-profiles-status",
                        "error", jqXHR.responseText);
                return false;
            }
        })
    }