/*
 * Copyright (c) 2018, 2021 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Bob Swift Atlassian Apps EULA"
 * (https://bobswift.atlassian.net/wiki/x/WoDXBQ) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */
AJS.toInit(function ($) {
    var content = AJS.$("#htmlConfigHeader").html();
    if (content && content.length > 0) {
        AJS.$('#admin-heading-container').html(content);
    }

    AJS.$("#html-whats-new-tab-link").on('click', function (event) {
        AJS.$('#whats-new-tab a').click();
    });

    // Migration of pages and templates
    var migratePagesButton = AJS.$("#updatePages");
    var migrationResults = AJS.$("#migration-result");
    var showMigrationStatus = AJS.$("#showMigrationStatus");
    var showInProgressMsg = AJS.$("#inProgressMsg")
    var statusList = ["NOT_STARTED", "COMPLETED"];


  // To Migrate the content
    migratePagesButton.click(async function (e) {
        e.preventDefault();
        showInProgressMsg.show();
        migratePagesButton.hide();
        let migStatus = await getMigrationStatus();
        if (statusList.includes(migStatus.status)) {
            showMigrationProgress();
            migStatus = await updatePages();
            if(statusList.includes(migStatus.status)){
              showUpdatePagesButton();
              showInProgressMsg.hide();
            }
        } else {
            showMigrationProgress();
        }
    });

    showMigrationStatus.click(async function (e) {
        e.preventDefault();
        migrationResults.show();
        let migStatus = await getMigrationStatus();
        if (statusList.includes(migStatus.status)) {
            showUpdatePagesButton();
            showInProgressMsg.hide();
        } else {
            showMigrationProgress();
            showInProgressMsg.show();
            migratePagesButton.hide();
        }

    });

   const showMigrationProgress=()=> {
        showMigrationStatus.show();
        migratePagesButton.hide();
    }
    const showUpdatePagesButton=()=> {
        migratePagesButton.show()
        showMigrationStatus.hide();
    }

    const updatePages = async ()=>{
      try {
        var migStatus = {};
        var serviceUrl = AJS.contextPath() + '/admin/plugins/htmladmin/updatepages.action';
          await $.ajax({
              url: serviceUrl,
              type: 'POST',
              contentType: "application/json; charset=utf-8",
              error: function (jqXHR, textStatus, errorThrown) {
                  AJS.log("Status: " + textStatus + "\n" + " Error: " + JSON.stringify(errorThrown));
              },
              success: function (data, textStatus, jqXHR) {
                  // Update migration result in the vm.
                  var result = $(jqXHR.responseText).find('#displayResults').html();

                  migStatus.status = $(jqXHR.responseText).find('#overallMigrationStatus').val();
                  if (migStatus.status == "COMPLETED") {
                      migrationResults.html(result);
                      migratePagesButton.show();
                  }

                  migStatus.noOfTotalPages = $(jqXHR.responseText).find('#noOfTotalPages').val();
                  migStatus.noOfTotalTemplates = $(jqXHR.responseText).find('#noOfTotalTemplates').val();
                  if (migStatus.noOfTotalPages == 0 && migStatus.noOfTotalTemplates == 0) {
                      migratePagesButton.prop("disabled", true);
                  }
              }
          });
            return migStatus;
        } catch (err) {
            return  false;
        }

    }

    const getMigrationStatus = async () => {
        try {
            var migStatus = {};
            await $.ajax({
                url: AJS.contextPath() + '/admin/plugins/htmladmin/migrationstatus.action',
                type: 'GET',
                contentType: "application/json; charset=utf-8",
                success: function (data, textStatus, jqXHR) {
                    // Update migration result in the vm.
                    migStatus.status = $(jqXHR.responseText).find('#overallMigrationStatus').val();
                    var result = $(jqXHR.responseText).find('#displayResults').html();
                    migrationResults.html(result);
                    migStatus.noOfTotalPages = $(jqXHR.responseText).find('#noOfTotalPages').val();
                    migStatus.noOfTotalTemplates = $(jqXHR.responseText).find('#noOfTotalTemplates').val();
                },
                error: function (err) {
                    console.log(err);
                }
            });
            return migStatus;
        } catch (err) {
            console.log(err);
        }
    }

    $("#blacklistDomains").on('change', function (e) {
        if (AJS.$("#blacklistDomains")[0].checked === false) {
            AJS.$("[name='blacklistDomainValues']").attr('disabled', true);
        } else {
            AJS.$("[name='blacklistDomainValues']").attr('disabled', false);
        }
    });
    
    if($('#allowJavascript')[0].checked)
        $('#allowJavaScriptWarningDiv').hide()
    else
        $('#allowJavaScriptWarningDiv').show()
        
        
    $("#allowJavascript").click(function(e) {
        if($('#allowJavascript')[0].checked)
            $('#allowJavaScriptWarningDiv').hide()
        else
            $('#allowJavaScriptWarningDiv').show()
    });
    
});
