/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationHelper {
    private final Logger log = LoggerFactory.getLogger(MigrationHelper.class);
    @ComponentImport
    private final BandanaManager bandanaManager;
    private static final ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();

    public MigrationHelper(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void migrateGlobalConfig() {
        try {
            if (this.needsMigration()) {
                String oldSendStatistics;
                String oldAllowJavaScript;
                String oldAllowWhitelistedUrl;
                String oldDisableSecureProcessing = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.disableSecureProcessing");
                if (StringUtils.isNotBlank((String)oldDisableSecureProcessing)) {
                    String newDisableSecureProcessing = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.disableSecureProcessing");
                    if (!StringUtils.isNotBlank((String)newDisableSecureProcessing)) {
                        this.setConfigParamValue("org.swift.confluence.html.disableSecureProcessing", oldDisableSecureProcessing);
                    }
                    this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.disableSecureProcessing");
                }
                if (StringUtils.isNotBlank((String)(oldAllowWhitelistedUrl = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.allowWhitelistedUrls")))) {
                    String newAllowWhitelistedUrl = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowWhitelistedUrls");
                    if (!StringUtils.isNotBlank((String)newAllowWhitelistedUrl)) {
                        this.setConfigParamValue("org.swift.confluence.html.allowWhitelistedUrls", oldAllowWhitelistedUrl);
                    }
                    this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.allowWhitelistedUrls");
                }
                if (StringUtils.isNotBlank((String)(oldAllowJavaScript = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.allowJavascript")))) {
                    String newAllowJavaScript = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowJavascript");
                    if (!StringUtils.isNotBlank((String)newAllowJavaScript)) {
                        this.setConfigParamValue("org.swift.confluence.html.allowJavascript", oldAllowJavaScript);
                    }
                    this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.allowJavascript");
                }
                if (StringUtils.isNotBlank((String)(oldSendStatistics = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.sendStatistics")))) {
                    String newSendStatistics = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.sendStatistics");
                    if (!StringUtils.isNotBlank((String)newSendStatistics)) {
                        this.setConfigParamValue("org.swift.confluence.html.sendStatistics", oldSendStatistics);
                    }
                    this.bandanaManager.removeValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.sendStatistics");
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error while doing the migration", (Throwable)e);
        }
    }

    private void setConfigParamValue(String newConfigKey, String oldConfigValue) {
        if (oldConfigValue.equals("on")) {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), newConfigKey, (Object)"on");
        } else {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), newConfigKey, (Object)"off");
        }
    }

    private boolean needsMigration() {
        return StringUtils.isNotBlank((String)((String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.disableSecureProcessing"))) || StringUtils.isNotBlank((String)((String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.allowWhitelistedUrls"))) || StringUtils.isNotBlank((String)((String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.sendStatistics"))) || StringUtils.isNotBlank((String)((String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.allowJavascript")));
    }
}

