/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.util;

import com.appfire.common.analytics.bean.EventDetails;
import com.appfire.common.analytics.util.AnalyticEvent;
import com.appfire.common.analytics.util.AnalyticsHelper;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.html.bean.GlobalConfigBean;
import org.swift.confluence.html.bean.MigrationAnalyticsBean;
import org.swift.confluence.html.bean.MigrationStatus;
import org.swift.confluence.html.bean.PreMigrationCheckBean;
import org.swift.confluence.html.bean.ProfileAnalyticsBean;
import org.swift.confluence.html.util.HTMLUtils;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public class HtmlAnalyticsHelper {
    static final Logger log = LoggerFactory.getLogger(HtmlAnalyticsHelper.class);
    private AnalyticsHelper analyticsHelper = null;
    public static final String HTML_SCRIPT = "script";
    public static final String XSLT_SOURCE = "source";
    public static final String XSLT_STYLE = "style";

    public HtmlAnalyticsHelper(AnalyticsHelper analyticsHelper) {
        this.analyticsHelper = analyticsHelper;
    }

    public HtmlAnalyticsHelper(@ComponentImport PluginLicenseManager licenseManager, HostLicenseInformation hostLicenseInformation) {
        this(new AnalyticsHelper(ScriptUtils.getHostInfo((HostLicenseInformation)hostLicenseInformation), ScriptUtils.getPluginInfo((PluginLicenseManager)licenseManager), ScriptUtils.getClientInfo(), HtmlAnalyticsHelper.class.getClassLoader()));
    }

    public void postAnalyticsEvent(AnalyticEvent.Event collectionName, String type) {
        try {
            if (collectionName != null) {
                HashMap<String, String> analyticsEventDataMap = new HashMap<String, String>();
                analyticsEventDataMap.put("type", type == null ? collectionName.getEvent() : type);
                this.analyticsHelper.postAnalyticsEvent(collectionName.getEvent(), analyticsEventDataMap);
            }
        }
        catch (Throwable e) {
            log.debug("Error while posting " + collectionName.getEvent() + " event analytics ", e);
        }
    }

    public void postGlobalConfigAnalyticsEvent(GlobalConfigBean configBean) {
        try {
            if (configBean != null) {
                HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
                analyticsEventDataMap.put("type", AnalyticEvent.Event.GLOBALCONFIG.getEvent());
                analyticsEventDataMap.put("settings", configBean);
                this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.GLOBALCONFIG.getEvent(), analyticsEventDataMap);
            }
        }
        catch (Throwable e) {
            log.debug("Error while posting globalconfig event analytics", e);
        }
    }

    public void postGlobalConfigMigrationEvent(MigrationStatus migrationStatus) {
        try {
            if (migrationStatus != null) {
                MigrationAnalyticsBean migrationAnalyticsBean = new MigrationAnalyticsBean();
                this.buildMigrationAnalyticBean(migrationAnalyticsBean, migrationStatus);
                ArrayList<EventDetails> eventDetailsList = new ArrayList<EventDetails>();
                EventDetails eventDetails = new EventDetails();
                HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
                analyticsEventDataMap.put("type", AnalyticEvent.Event.GLOBALCONFIG.getEvent());
                analyticsEventDataMap.put("settings", migrationAnalyticsBean);
                eventDetails.setCollectionName(AnalyticEvent.Event.MIGRATION.getEvent());
                eventDetails.setEventData(analyticsEventDataMap);
                eventDetailsList.add(eventDetails);
                this.analyticsHelper.postAnalyticsEvents(eventDetailsList);
            }
        }
        catch (Throwable e) {
            log.debug("Error while posting globalconfig event analytics", e);
        }
    }

    public void postNewMacroAnalytics(String macroName, Map<String, String> parameters) {
        if (parameters != null) {
            HashMap<String, String> paramMap = new HashMap<String, String>(parameters);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.NEWMACRO.getEvent());
            analyticsEventDataMap.put("macroName", macroName);
            this.updateSensitiveParams(paramMap);
            analyticsEventDataMap.put("macroParams", paramMap);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.MACRO.getEvent(), analyticsEventDataMap);
        }
    }

    public void postInstallUninstallEvent(AnalyticEvent.Event eventType) {
        this.postAnalyticsEvent(eventType, null);
    }

    public void postErrorEvent(String errorMessage) {
        try {
            HashMap<String, String> analyticsEventDataMap = new HashMap<String, String>();
            analyticsEventDataMap.put("type", AnalyticEvent.Event.ERROR.getEvent());
            analyticsEventDataMap.put("error", errorMessage);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.ERROR.getEvent(), analyticsEventDataMap);
        }
        catch (Throwable e) {
            log.debug("Error while posting " + AnalyticEvent.Event.ERROR.getEvent() + " event analytics ", e);
        }
    }

    public void postErrorEvent(String errorMessage, String event) {
        try {
            HashMap<String, String> analyticsEventDataMap = new HashMap<String, String>();
            analyticsEventDataMap.put("type", AnalyticEvent.Event.ERROR.getEvent());
            analyticsEventDataMap.put("error", errorMessage);
            this.analyticsHelper.postAnalyticsEvent(event, analyticsEventDataMap);
        }
        catch (Throwable e) {
            log.debug("Error while posting " + AnalyticEvent.Event.ERROR.getEvent() + " event analytics ", e);
        }
    }

    public Map<String, Object> convertToMap(Object bean) {
        ObjectMapper m = new ObjectMapper();
        Map beanMap = null;
        beanMap = (Map)m.convertValue(bean, Map.class);
        return beanMap;
    }

    private void updateSensitiveParams(Map<String, String> parameters) {
        if (parameters.containsKey(HTML_SCRIPT)) {
            String scriptParamVal = parameters.get(HTML_SCRIPT);
            this.setSourceInutParam(scriptParamVal, parameters, HTML_SCRIPT);
        }
        if (parameters.containsKey(XSLT_STYLE)) {
            String styleParamVal = parameters.get(XSLT_STYLE);
            this.setSourceInutParam(styleParamVal, parameters, XSLT_STYLE);
        }
        if (parameters.containsKey(XSLT_SOURCE)) {
            String sourceParamVal = parameters.get(XSLT_SOURCE);
            this.setSourceInutParam(sourceParamVal, parameters, XSLT_SOURCE);
        }
        if (parameters.containsKey("user")) {
            parameters.put("user", "true");
        }
        if (parameters.containsKey("password")) {
            parameters.put("password", "true");
        }
        if (parameters.containsKey("profile")) {
            parameters.put("profile", "true");
        }
    }

    public void setSourceInutParam(String sourceParam, Map<String, String> parameters, String inputSource) {
        try {
            int resourceType = ScriptUtils.getResourceType((String)sourceParam, (boolean)false);
            switch (resourceType) {
                case 1: {
                    parameters.put(inputSource, "file");
                    break;
                }
                case 4: {
                    parameters.put(inputSource, "attachment");
                    break;
                }
                case 3: {
                    parameters.put(inputSource, "template");
                    break;
                }
                case 2: {
                    parameters.put(inputSource, "url");
                }
            }
        }
        catch (MacroExecutionException e) {
            log.debug(e.getMessage());
        }
    }

    public void postProfileAddAnalyticsEvent(ProfileBean profileBean) {
        if (profileBean != null) {
            ProfileAnalyticsBean profileAnalyticsBean = HTMLUtils.updateSensitiveProfileParams(profileBean);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.ADDED.getEvent());
            analyticsEventDataMap.put("settings", profileAnalyticsBean);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.PROFILE.getEvent(), analyticsEventDataMap);
        }
    }

    public void postProfileEditAnalyticsEvent(ProfileBean profileBean) {
        if (profileBean != null) {
            ProfileAnalyticsBean profileAnalyticsBean = HTMLUtils.updateSensitiveProfileParams(profileBean);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.UPDATED.getEvent());
            analyticsEventDataMap.put("settings", profileAnalyticsBean);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.PROFILE.getEvent(), analyticsEventDataMap);
        }
    }

    public void postProfileDeleteAnalyticsEvent(ProfileBean profileBean) {
        if (profileBean != null) {
            ProfileAnalyticsBean profileAnalyticsBean = HTMLUtils.updateSensitiveProfileParams(profileBean);
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.REMOVED.getEvent());
            analyticsEventDataMap.put("settings", profileAnalyticsBean);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.PROFILE.getEvent(), analyticsEventDataMap);
        }
    }

    public void postPreMigrationCheckAnalyticsEvent(PreMigrationCheckBean bean) {
        if (bean != null) {
            HashMap<String, Object> analyticsEventDataMap = new HashMap<String, Object>();
            analyticsEventDataMap.put("type", AnalyticEvent.SubEvent.PREMIGRATIONCHECK.getEvent());
            analyticsEventDataMap.put("results", bean);
            this.analyticsHelper.postAnalyticsEvent(AnalyticEvent.Event.MIGRATION.getEvent(), analyticsEventDataMap);
        }
    }

    private void buildMigrationAnalyticBean(MigrationAnalyticsBean migrationAnalyticsBean, MigrationStatus migrationStatus) {
        migrationAnalyticsBean.setMigrationStartdate(migrationStatus.getMigrationstartdate());
        migrationAnalyticsBean.setNoOfPagesFailed(migrationStatus.getNoofpagesfailed());
        migrationAnalyticsBean.setNoOfPagesMigrated(migrationStatus.getNoofpagesmigrated());
        migrationAnalyticsBean.setNoOfTemplatesFailed(migrationStatus.getNooftemplatesfailed());
        migrationAnalyticsBean.setNoOfTemplatesMigrated(migrationStatus.getNooftemplatesmigrated());
        migrationAnalyticsBean.setOverallMigrationStatus(migrationStatus.getOverallmigrationstatus());
        migrationAnalyticsBean.setOverallNoOfPages(migrationStatus.getOverallnoofpages());
        migrationAnalyticsBean.setOverallNoOfTemplates(migrationStatus.getOverallnooftemplates());
        migrationAnalyticsBean.setPagesMigrationStatus(migrationStatus.getPagesmigrationstatus());
        migrationAnalyticsBean.setTemplatesMigrationStatus(migrationStatus.getTemplatesmigrationstatus());
        migrationAnalyticsBean.setTimeTakenForMigration(migrationStatus.getTimetakenformigration());
        migrationAnalyticsBean.setType(AnalyticEvent.Event.MIGRATION.getEvent());
    }
}

