/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.util;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.html.ao.entity.ProfileEntity;
import org.swift.confluence.html.bean.ProfileAnalyticsBean;
import org.swift.confluence.macrosecurity.utils.MacroSecurityUtils;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public class HTMLUtils {
    protected static final Logger log = LoggerFactory.getLogger(HTMLUtils.class);

    public static String validateAndSanitizeHTMLMacroXss(MacroInfo info, String htmlData, BandanaManager bandanaManager, UserAccessor userAccessor, String macroName, I18nResolver i18nResolver, boolean isNewMacroConfigured) {
        if (!HTMLUtils.allowJavascript(bandanaManager)) {
            if (ScriptUtils.hasXssContent((String)htmlData)) {
                StringBuilder output = new StringBuilder();
                output.append(ScriptUtils.cleanXssInHtml((String)htmlData));
                if (HTMLUtils.getConfigValue(bandanaManager, "org.swift.confluence.html.allowJavaScriptWarning", false)) {
                    log.debug("Appending warning message");
                    output.append(i18nResolver.getText("org.swift.confluence.html.info.javascript.message-warning", new Serializable[]{i18nResolver.getText("org.swift.confluence.html.info.javascript.disallowed-msg")}));
                }
                return output.toString();
            }
        } else if (MacroSecurityUtils.isSecurityEnabled((BandanaManager)bandanaManager) && ScriptUtils.hasXssContent((String)htmlData)) {
            try {
                HTMLUtils.checkMacroSecurity(bandanaManager, userAccessor, i18nResolver, info, macroName, "allowJavascript", isNewMacroConfigured);
            }
            catch (MacroExecutionException ex) {
                StringBuilder output = new StringBuilder();
                output.append(ScriptUtils.cleanXssInHtml((String)htmlData));
                output.append(i18nResolver.getText("org.swift.confluence.html.info.javascript.message-warning", new Serializable[]{i18nResolver.getText("org.swift.confluence.html.info.javascript.restricted-through-ms")}));
                return output.toString();
            }
        }
        return htmlData;
    }

    public static String validateAndSanitizeXsltMacroXss(MacroInfo info, String htmlData, BandanaManager bandanaManager, UserAccessor userAccessor, String macroName, I18nResolver i18nResolver) {
        if (!HTMLUtils.allowJavascript(bandanaManager)) {
            if (ScriptUtils.hasXssContent((String)htmlData)) {
                StringBuilder output = new StringBuilder();
                output.append(ScriptUtils.cleanXssInHtml((String)htmlData));
                if (HTMLUtils.getConfigValue(bandanaManager, "org.swift.confluence.html.allowJavaScriptWarning", false)) {
                    log.debug("Appending warning message");
                    output.append(i18nResolver.getText("org.swift.confluence.html.info.javascript.message-warning", new Serializable[]{i18nResolver.getText("org.swift.confluence.html.info.javascript.disallowed-msg")}));
                }
                return output.toString();
            }
        } else if (MacroSecurityUtils.isSecurityEnabled((BandanaManager)bandanaManager) && ScriptUtils.hasXssContent((String)htmlData)) {
            Properties enabledProperties = HTMLUtils.getProperties("org.swift.confluence.macrosecurity.properties", bandanaManager, i18nResolver);
            String MS_ALLOW_JAVASCRIPT = macroName + "." + "allowJavascript";
            if (!enabledProperties.isEmpty() && enabledProperties.getProperty(MS_ALLOW_JAVASCRIPT) != null) {
                try {
                    MacroSecurityUtils.securityCheck((BandanaManager)bandanaManager, (UserAccessor)userAccessor, (String)macroName, (MacroInfo)info, (String)"allowJavascript", null);
                }
                catch (MacroExecutionException e) {
                    StringBuilder output = new StringBuilder();
                    output.append(ScriptUtils.cleanXssInHtml((String)htmlData));
                    output.append(i18nResolver.getText("org.swift.confluence.html.info.javascript.message-warning", new Serializable[]{i18nResolver.getText("org.swift.confluence.html.info.javascript.restricted-through-ms")}));
                    return output.toString();
                }
            }
        }
        return htmlData;
    }

    public static void checkMacroSecurity(BandanaManager bandanaManager, UserAccessor userAccessor, I18nResolver i18nResolver, MacroInfo info, String macroName, String paramName, boolean isNewMacroConfigured) throws MacroExecutionException {
        try {
            MacroSecurityUtils.securityCheck((BandanaManager)bandanaManager, (UserAccessor)userAccessor, (String)macroName, (MacroInfo)info, (String)paramName, null);
        }
        catch (MacroExecutionException exception) {
            if (!isNewMacroConfigured) {
                MacroSecurityUtils.securityCheck((BandanaManager)bandanaManager, (UserAccessor)userAccessor, (String)"html", (MacroInfo)info, (String)paramName, null);
            }
            throw exception;
        }
    }

    public static boolean isNewMacroConfigured(BandanaManager bandanaManager, I18nResolver i18nResolver, String macroName) {
        boolean isNewMacroConfigured = false;
        if (MacroSecurityUtils.isSecurityEnabled((BandanaManager)bandanaManager)) {
            Properties enabledProperties = HTMLUtils.getProperties("org.swift.confluence.macrosecurity.properties", bandanaManager, i18nResolver);
            isNewMacroConfigured = !enabledProperties.isEmpty() && enabledProperties.getProperty(macroName) != null;
        }
        return isNewMacroConfigured;
    }

    private static boolean allowJavascript(BandanaManager bandanaManager) {
        try {
            String allowJavascript = (String)bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.allowJavascript");
            return !"off".equalsIgnoreCase(allowJavascript);
        }
        catch (Exception e) {
            log.error("Unable to retrieve previous allowJavascript config settings", (Throwable)e);
            return true;
        }
    }

    public static Properties getProperties(String propertyKey, BandanaManager bandanaManager, I18nResolver i18nResolver) {
        Properties properties = null;
        try {
            properties = (Properties)bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), propertyKey);
        }
        catch (Exception e) {
            log.error(i18nResolver.getText("org.swift.confluence.html.unabletoget-msconfig-settings-tryagain"), (Throwable)e);
        }
        return properties == null ? new Properties() : properties;
    }

    public static boolean getConfigValue(BandanaManager bandanaManager, String bandanaKey, Boolean defaultValue) {
        String configValue = "";
        try {
            configValue = (String)bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), bandanaKey);
        }
        catch (Exception e) {
            log.error("Unable to retrieve previous config settings.", (Object)e.getMessage());
        }
        if (StringUtils.isBlank((String)configValue)) {
            return defaultValue;
        }
        log.debug("bandanaKey :{}, defaultValue : {}", (Object)bandanaKey, (Object)defaultValue);
        return configValue.equalsIgnoreCase("on");
    }

    public static ProfileAnalyticsBean updateSensitiveProfileParams(ProfileBean profileBean) {
        ProfileAnalyticsBean profileAnalyticsBean = new ProfileAnalyticsBean();
        profileAnalyticsBean.setProfileType(profileBean.getProfileType());
        profileAnalyticsBean.setUser(StringUtils.isNotBlank((String)profileBean.getUser()));
        profileAnalyticsBean.setPassword(StringUtils.isNotBlank((String)profileBean.getPassword()));
        profileAnalyticsBean.setUrl(StringUtils.isNotBlank((String)profileBean.getUrl()));
        profileAnalyticsBean.setAccessToken(StringUtils.isNotBlank((String)profileBean.getAccessToken()));
        profileAnalyticsBean.setUrlParams(StringUtils.isNotBlank((String)profileBean.getUrlParams()));
        profileAnalyticsBean.setHeaderParams(StringUtils.isNotBlank((String)profileBean.getHeaderParams()));
        profileAnalyticsBean.setUserInUrlParams(StringUtils.contains((String)profileBean.getUrlParams(), (String)"$user"));
        profileAnalyticsBean.setPasswordInUrlParams(StringUtils.contains((String)profileBean.getUrlParams(), (String)"$password"));
        profileAnalyticsBean.setAccessTokenInUrlParams(StringUtils.contains((String)profileBean.getUrlParams(), (String)"$accessToken"));
        profileAnalyticsBean.setUserInHeaderParams(StringUtils.contains((String)profileBean.getHeaderParams(), (String)"$user"));
        profileAnalyticsBean.setPasswordInHeaderParams(StringUtils.contains((String)profileBean.getHeaderParams(), (String)"$password"));
        profileAnalyticsBean.setAccessTokenInHeaderParams(StringUtils.contains((String)profileBean.getHeaderParams(), (String)"$accessToken"));
        return profileAnalyticsBean;
    }

    public static ProfileEntity beanToProfileEntity(ProfileBean srcProfile, ProfileEntity destProfile, boolean create) throws Exception {
        if (!HTMLUtils.shouldUpdate(srcProfile.getProfileName(), create)) {
            throw new MacroExecutionException("PROFILE_NAME cannot be null");
        }
        destProfile.setProfileName(srcProfile.getProfileName());
        if (HTMLUtils.shouldUpdate(srcProfile.getUrl(), create)) {
            destProfile.setUrl(srcProfile.getUrl());
        }
        if (HTMLUtils.shouldUpdate(srcProfile.getProfileType(), create)) {
            destProfile.setProfileType(srcProfile.getProfileType());
        }
        if (HTMLUtils.shouldUpdate(srcProfile.getUser(), create)) {
            destProfile.setUser(srcProfile.getUser());
        }
        if (HTMLUtils.shouldUpdate(srcProfile.getPassword(), create)) {
            destProfile.setPassword(EncryptDecryptHelper.encryptText((String)srcProfile.getPassword()));
        }
        if (HTMLUtils.shouldUpdate(srcProfile.getAccessToken(), create)) {
            destProfile.setAccessToken(EncryptDecryptHelper.encryptText((String)srcProfile.getAccessToken()));
        }
        if (HTMLUtils.shouldUpdate(srcProfile.getUrlParams(), create)) {
            destProfile.setUrlParams(srcProfile.getUrlParams());
        }
        if (HTMLUtils.shouldUpdate(srcProfile.getHeaderParams(), create)) {
            destProfile.setHeaderParams(srcProfile.getHeaderParams());
        }
        return destProfile;
    }

    private static boolean shouldUpdate(String value, boolean create) {
        if (create) {
            return !StringUtils.isBlank((String)value);
        }
        return true;
    }

    public static boolean checkForhyperlinkTag(String message) {
        String hyperlinkTagPattern = "(?i)<a([^>]+)>(.+?)</a>";
        Pattern patternTag = Pattern.compile(hyperlinkTagPattern);
        Matcher matcherTag = patternTag.matcher(message);
        return matcherTag.find();
    }

    public static ArrayList<ProfileBean> getProfileBeansFromEntities(List<ProfileEntity> profileEntities) throws Exception {
        ArrayList<ProfileBean> templateList = new ArrayList<ProfileBean>();
        if (profileEntities != null) {
            for (ProfileEntity profileEntity : profileEntities) {
                ProfileBean template = HTMLUtils.profileEntityToBean(profileEntity);
                templateList.add(template);
            }
        }
        return templateList;
    }

    public static ProfileBean profileEntityToBean(ProfileEntity profileEntity) throws Exception {
        ProfileBean profileBean = new ProfileBean();
        profileBean.setID(profileEntity.getID());
        profileBean.setProfileName(profileEntity.getProfileName());
        profileBean.setUrl(profileEntity.getUrl());
        profileBean.setProfileType(profileEntity.getProfileType());
        profileBean.setUser(profileEntity.getUser());
        if (StringUtils.isNotBlank((String)profileEntity.getAccessToken())) {
            profileBean.setAccessToken(EncryptDecryptHelper.decryptText((String)profileEntity.getAccessToken(), (String)profileEntity.getAccessToken()));
        }
        if (StringUtils.isNotBlank((String)profileEntity.getPassword())) {
            profileBean.setPassword(EncryptDecryptHelper.decryptText((String)profileEntity.getPassword(), (String)profileEntity.getPassword()));
        }
        profileBean.setUrlParams(profileEntity.getUrlParams());
        profileBean.setUrl(profileEntity.getUrl());
        profileBean.setHeaderParams(profileEntity.getHeaderParams());
        return profileBean;
    }

    public static ProfileBean macroProfileEntityToBean(ProfileEntity profileEntity) throws Exception {
        ProfileBean profileBean = new ProfileBean();
        profileBean.setID(profileEntity.getID());
        profileBean.setProfileName(profileEntity.getProfileName());
        profileBean.setUrl(profileEntity.getUrl());
        profileBean.setProfileType(profileEntity.getProfileType());
        profileBean.setUser(profileEntity.getUser());
        profileBean.setPassword(profileEntity.getPassword());
        profileBean.setAccessToken(profileEntity.getAccessToken());
        profileBean.setUrlParams(profileEntity.getUrlParams());
        profileBean.setUrl(profileEntity.getUrl());
        profileBean.setHeaderParams(profileEntity.getHeaderParams());
        return profileBean;
    }

    public static String validateIPAddress(String blacklistDomainValues, InetAddressValidator validator) throws Exception {
        StringBuffer finalIPValue = new StringBuffer();
        String finalIPStr = null;
        String[] bdValueArr = blacklistDomainValues.split(",");
        Pattern pattern = Pattern.compile("\\s");
        for (String ipValue : bdValueArr) {
            if (StringUtils.isNotBlank((String)ipValue)) {
                if ((ipValue = ipValue.trim()).indexOf(47) > -1) {
                    String newIPValue = ipValue.substring(0, ipValue.indexOf(47));
                    if (!validator.isValid(newIPValue) || pattern.matcher(ipValue).find()) {
                        throw new Exception(ipValue);
                    }
                    newIPValue = ipValue.substring(ipValue.indexOf(47) + 1, ipValue.length());
                    try {
                        Integer.parseInt(newIPValue);
                    }
                    catch (Exception e) {
                        throw new Exception(ipValue);
                    }
                } else if (pattern.matcher(ipValue).find() || !validator.isValid(ipValue)) {
                    throw new Exception(ipValue);
                }
            } else {
                throw new Exception("blank" + ipValue);
            }
            finalIPValue.append(ipValue + ",");
        }
        if (finalIPValue.length() > 0) {
            finalIPStr = finalIPValue.toString().replaceAll(",$", "");
        }
        return finalIPStr;
    }
}

