/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.swift.confluence.html.ao.entity.ProfileEntity;
import org.swift.confluence.html.service.ManageProfileService;
import org.swift.confluence.html.util.HTMLUtils;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;
import org.swift.confluence.scriptutil.bean.ProfileBean;

@Component
@Transactional
public class ManageProfileServiceImpl
implements ManageProfileService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Autowired
    public ManageProfileServiceImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public ProfileEntity addProfile(ProfileBean profileBean) throws Exception {
        this.log.debug("Adding profile  :" + profileBean.toString());
        ProfileEntity profileEntity = null;
        try {
            profileEntity = (ProfileEntity)this.activeObjects.create(ProfileEntity.class, new DBParam[]{new DBParam("PROFILE_NAME", (Object)profileBean.getProfileName())});
            profileEntity = HTMLUtils.beanToProfileEntity(profileBean, profileEntity, true);
            profileEntity.save();
            this.log.debug("Added profile  :" + profileEntity.getProfileName());
        }
        catch (SQLException sqlException) {
            this.log.error("Error while creating the profile {}. {}", (Object)profileBean.getProfileName(), (Object)sqlException.getMessage());
            throw new MacroExecutionException("Error while creating profile: " + profileBean.getProfileName() + ", make sure profile name is unique.");
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Error while creating the profile {}. {}", (Object)profileBean.getProfileName(), (Object)e);
            } else {
                this.log.error("Error while creating the profile {}. {}", (Object)profileBean.getProfileName(), (Object)e.getMessage());
            }
            throw new MacroExecutionException("Error while adding profile " + profileBean.getProfileName() + " : " + e.getMessage());
        }
        return profileEntity;
    }

    @Override
    public List<ProfileEntity> getProfiles() throws Exception {
        List<ProfileEntity> profileEntities = Collections.emptyList();
        try {
            profileEntities = Arrays.asList((ProfileEntity[])this.activeObjects.find(ProfileEntity.class));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.debug("Error while retrieving the details", (Object)exception.getMessage());
        }
        return profileEntities;
    }

    @Override
    public void updateProfile(String profileName, ProfileBean profileBean) throws Exception {
        this.log.debug("Updataing profile  :" + profileBean.toString());
        try {
            ProfileEntity[] profileEntities = null;
            profileEntities = profileBean.getID() > 0 ? (ProfileEntity[])this.activeObjects.find(ProfileEntity.class, Query.select().where("ID = ?", new Object[]{profileBean.getID()})) : (ProfileEntity[])this.activeObjects.find(ProfileEntity.class, Query.select().where("PROFILE_NAME = ?", new Object[]{profileBean.getProfileName()}));
            if (profileEntities != null && profileEntities.length > 0) {
                ProfileEntity destProfile = profileEntities[0];
                this.log.debug("Updated profile :{}", (Object)profileName);
                destProfile = HTMLUtils.beanToProfileEntity(profileBean, destProfile, false);
                destProfile.save();
            }
        }
        catch (Exception e) {
            this.log.error("Error while updating profile {}. {}", (Object)profileBean.getProfileName(), (Object)e.getMessage());
            throw new MacroExecutionException("Error while updating profile " + profileBean.getProfileName() + " : " + e.getMessage());
        }
    }

    @Override
    public void deleteProfile(String profileName) {
        this.log.debug("Deleting profile  :" + profileName);
        ProfileEntity[] profiles = (ProfileEntity[])this.activeObjects.find(ProfileEntity.class, Query.select().where("PROFILE_NAME = ?", new Object[]{profileName}));
        if (profiles != null && profiles.length > 0) {
            this.activeObjects.delete(new RawEntity[]{profiles[0]});
            this.log.debug("Removed profile :{}", (Object)profiles[0].getProfileName());
        }
    }

    @Override
    public ProfileBean getProfileBeanForProfileName(String profileName) throws MacroExecutionException {
        ProfileBean profileBean = null;
        try {
            ProfileEntity[] profileEntities = (ProfileEntity[])this.activeObjects.find(ProfileEntity.class, Query.select().where("PROFILE_NAME = ?", new Object[]{profileName}));
            if (profileEntities != null && profileEntities.length > 0) {
                ProfileEntity destProfile = profileEntities[0];
                profileBean = HTMLUtils.macroProfileEntityToBean(destProfile);
            }
        }
        catch (Exception e) {
            this.log.error("Error while getting profile {}. {}", (Object)profileBean.getProfileName(), (Object)e.getMessage());
            throw new MacroExecutionException("Error while getting profile " + profileBean.getProfileName() + " : " + e.getMessage());
        }
        return profileBean;
    }

    @Override
    public boolean checkProfileExists(String profileName) throws Exception {
        ArrayList<ProfileBean> profilesList = HTMLUtils.getProfileBeansFromEntities(this.getProfiles());
        if (profilesList != null && profilesList.size() > 0) {
            for (ProfileBean profileBean : profilesList) {
                if (profileBean.getProfileName().equalsIgnoreCase(profileName)) {
                    return true;
                }
                this.log.debug("Profile :" + profileName + " already exists");
            }
        }
        return false;
    }

    @Override
    @Transactional
    public JsonObject getProfilesForMigration() throws Exception {
        JsonObject profilesData = new JsonObject();
        this.activeObjects.stream(ProfileEntity.class, Query.select((String)"USER, HEADER_PARAMS, URL, URL_PARAMS, ACCESS_TOKEN, PROFILE_TYPE, PASSWORD, PROFILE_NAME, ID"), profileEntity -> {
            JsonObject profileObj = new JsonObject();
            profileObj.addProperty("user", profileEntity.getUser());
            profileObj.addProperty("requestHeaders", profileEntity.getHeaderParams());
            profileObj.addProperty("url", profileEntity.getUrl());
            profileObj.addProperty("urlParameters", profileEntity.getUrlParams());
            try {
                profileObj.addProperty("accessToken", EncryptDecryptHelper.decryptText((String)profileEntity.getAccessToken()));
            }
            catch (Exception e) {
                this.log.error("Error while decrypting accesstoken text " + profileEntity.getProfileName());
            }
            profileObj.addProperty("type", profileEntity.getProfileType());
            try {
                profileObj.addProperty("password", EncryptDecryptHelper.decryptText((String)profileEntity.getPassword()));
            }
            catch (Exception e) {
                this.log.error("Error while decrypting password text " + profileEntity.getProfileName());
            }
            profilesData.add(profileEntity.getProfileName(), (JsonElement)profileObj);
        });
        return profilesData;
    }
}

