/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.service;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.atlassian.confluence.content.ContentQuery;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.migration.app.check.CheckResult;
import com.atlassian.migration.app.check.CheckResultBuilder;
import com.atlassian.migration.app.check.CheckSpec;
import com.atlassian.migration.app.check.CheckStatus;
import com.atlassian.migration.app.check.MigrationPlanContext;
import com.atlassian.migration.app.check.PreMigrationCheckRepository;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.html.bean.PreMigrationCheckBean;
import org.swift.confluence.html.util.HtmlAnalyticsHelper;

@ExportAsService
@Named
public class HtmlPreMigrationCheckImpl
implements PreMigrationCheckRepository {
    @ComponentImport
    private final CustomContentManager contentManager;
    private static final Logger log = LoggerFactory.getLogger(HtmlPreMigrationCheckImpl.class);
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final HostLicenseInformation hostLicenseInformation;

    public HtmlPreMigrationCheckImpl(CustomContentManager contentManager, PluginLicenseManager licenseManager, @ComponentImport com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, @ComponentImport LicenseHandler licenseHandler, I18nResolver i18nResolver) {
        this.contentManager = contentManager;
        this.licenseManager = licenseManager;
        this.i18nResolver = i18nResolver;
        this.hostLicenseInformation = new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
    }

    public Set<CheckSpec> getAvailableChecks() {
        HashSet<CheckSpec> checks = new HashSet<CheckSpec>();
        try {
            checks.add(this.createHTMLCountCheck());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return checks;
    }

    public CheckResult executeCheck(String checkId, MigrationPlanContext migrationPlanContext) {
        log.info("Running app vendor checks for plan {}", (Object)migrationPlanContext.getPlanName());
        return this.executeOldHTMLMacroCheck();
    }

    private CheckSpec createHTMLCountCheck() {
        CheckSpec complicatedCheckWithTemplates = new CheckSpec("Unmigrated-HTML-check", "HTML macro pre-migration check", "HTML macro pre-migration check", this.buildStepsToResolveCheck());
        List validationErrors = complicatedCheckWithTemplates.validate();
        if (!validationErrors.isEmpty()) {
            log.warn("Validation errors found: " + validationErrors);
        }
        return complicatedCheckWithTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckResult executeOldHTMLMacroCheck() {
        String errorMessage = null;
        PreMigrationCheckBean bean = new PreMigrationCheckBean();
        try {
            CheckResultBuilder builder = CheckResultBuilder.resultBuilder((CheckStatus)CheckStatus.WARNING);
            if (this.checkSomething(bean)) {
                builder.withStepsToResolveKey("steps-to-resolve-check");
            } else {
                builder = CheckResultBuilder.resultBuilder((CheckStatus)CheckStatus.SUCCESS);
            }
            CheckResult checkResult = builder.build();
            return checkResult;
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            log.error("Error while performing check {}", (Throwable)e);
            CheckResult checkResult = CheckResultBuilder.resultBuilder((CheckStatus)CheckStatus.CHECK_EXECUTION_ERROR).build();
            return checkResult;
        }
        finally {
            HtmlAnalyticsHelper analyticsHelper = new HtmlAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
            if (errorMessage == null) {
                analyticsHelper.postPreMigrationCheckAnalyticsEvent(bean);
            } else {
                analyticsHelper.postErrorEvent(errorMessage, AnalyticEvent.Event.MIGRATION.getEvent());
            }
        }
    }

    private long findHtmlMacroCount(PreMigrationCheckBean bean) throws InvalidSearchException {
        long startTime = System.currentTimeMillis();
        long macroCount = (Long)ImmutableList.copyOf((Iterator)this.contentManager.findByQuery(new ContentQuery("html.findAllHtmlInContentsCount", new Object[0]), 0, Integer.MAX_VALUE)).get(0);
        bean.setNoOfUnmigratedMacros(new Long(macroCount).toString());
        bean.setTimeTakenInMilis(new Long(System.currentTimeMillis() - startTime).toString());
        return macroCount;
    }

    private boolean checkSomething(PreMigrationCheckBean bean) {
        try {
            if (this.findHtmlMacroCount(bean) > 0L) {
                return true;
            }
        }
        catch (InvalidSearchException e) {
            log.error("Error while executing the check {}", (Object)e.getMessage());
        }
        return false;
    }

    private Map<String, String> buildStepsToResolveCheck() {
        HashMap<String, String> stepsToResolve = new HashMap<String, String>();
        stepsToResolve.put("steps-to-resolve-check", "<paragraph>There seem to be some unmigrated HTML macros.</> <unordered-item>Go to HTML Configuration -> Migrate to Confluence Cloud to complete the pre-migration process.</>");
        return stepsToResolve;
    }
}

