/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.service;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.swift.confluence.html.service.ManageProfileService;
import org.swift.confluence.scriptutil.ScriptUtils;

@Component
@ExportAsService
public class AppMigrationServiceImpl
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(AppMigrationServiceImpl.class);
    private final BandanaManager bandanaManager;
    private final ManageProfileService manageProfileService;

    @Inject
    public AppMigrationServiceImpl(BandanaManager bandanaManager, ManageProfileService profileService) {
        this.bandanaManager = bandanaManager;
        this.manageProfileService = profileService;
    }

    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            log.info("HTML Migration started...");
            HashMap<String, String> configMap = new HashMap<String, String>();
            configMap.put("allowWhitelistedUrls", "off");
            configMap.put("allowJavascript", "on");
            configMap.put("sendStatistics", "on");
            configMap.put("profiles", ScriptUtils.appDatatoJson((JsonObject)this.manageProfileService.getProfilesForMigration()));
            HashMap<String, String> cloudKeysMap = new HashMap<String, String>();
            cloudKeysMap.put("allowWhitelistedUrls", "allowWhitelistedUrls");
            cloudKeysMap.put("allowJavascript", "allowJavaScript");
            cloudKeysMap.put("sendStatistics", "sendStatistics");
            cloudKeysMap.put("profiles", "profiles");
            String jsonPayload = ScriptUtils.buildAppDataCustomToMigrate((BandanaManager)this.bandanaManager, (String)"org.swift.confluence.html", configMap, cloudKeysMap);
            log.debug("Migration payload {}", (Object)jsonPayload);
            OutputStream globalConfigStream = gateway.createAppData(transferId);
            globalConfigStream.write(jsonPayload.getBytes());
            globalConfigStream.close();
        }
        catch (IOException e) {
            log.error("Error uploading files to the cloud", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error uploading files to the cloud", (Throwable)e);
        }
    }

    public String getCloudAppKey() {
        return "org.swift.confluence.html";
    }

    public String getServerAppKey() {
        return "org.swift.confluence.html";
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }
}

