/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.migrator;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.swift.confluence.html.bean.MigrationStatus;
import org.swift.confluence.scriptutil.ScriptUtils;

@Component
public class MigrationStatusDao {
    private static final Logger log = LoggerFactory.getLogger(MigrationStatusDao.class);
    @ComponentImport
    private final BandanaManager bandanaManager;

    @Autowired
    public MigrationStatusDao(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public Map<String, String> saveMigrationStatus(MigrationStatus migrationStatus) throws Exception {
        HashMap<String, String> map = (HashMap<String, String>)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.migrationParamsMap");
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("migration_key", migrationStatus.getMigrationStatusBuilder());
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.migrationParamsMap", map);
        return map;
    }

    private MigrationStatus loadMigrationStatus(Map<String, String> map) throws Exception {
        MigrationStatus migratorBean = null;
        ObjectMapper mapper = new ObjectMapper();
        Map migratorMap = null;
        if (map == null) {
            map = this.loadMigrationStatusAsMap();
        }
        if (map != null) {
            migratorMap = ScriptUtils.getMap((String)map.get("migration_key"));
        }
        if (migratorMap != null && !migratorMap.isEmpty()) {
            migratorBean = (MigrationStatus)mapper.convertValue((Object)migratorMap, MigrationStatus.class);
            log.info("loadMigrationStatus: " + migratorBean.getMigrationStatusBuilder());
        } else {
            log.info("Bandana entry not found");
        }
        return migratorBean;
    }

    public MigrationStatus getMigrationStatus() throws Exception {
        log.info("Loading migration status ");
        MigrationStatus migratorBean = this.loadMigrationStatus(this.loadMigrationStatusAsMap());
        return migratorBean;
    }

    private Map<String, String> loadMigrationStatusAsMap() throws Exception {
        Map map = (Map)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.migrationParamsMap");
        log.info("Loading migration status as map {}" + map);
        return map;
    }
}

