/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.migrator;

import com.atlassian.confluence.content.ContentQuery;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.PlainTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.RichTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.migration.AbstractExceptionTolerantMigrator;
import com.atlassian.confluence.content.render.xhtml.migration.ExceptionTolerantMigrator;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionBuilder;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.swift.confluence.html.bean.MigrationStage;
import org.swift.confluence.html.bean.MigrationStatus;
import org.swift.confluence.html.bean.OverallMigrationStatus;
import org.swift.confluence.html.exception.HtmlMigrationException;
import org.swift.confluence.html.migrator.MigrationStatusDao;
import org.swift.confluence.scriptutil.ScriptUtils;

@Component
public class MacroNameMigrator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @ComponentImport
    private final CustomContentManager contentManager;
    @ComponentImport
    private final PageTemplateManager pageTemplateManager;
    @ComponentImport
    private final XhtmlContent xhtmlContent;
    private final HtmlMacroParamsContentEntityMigrator migrator;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final FormatSettingsManager formatSettingsManager;
    private final MigrationStatusDao migrationStatusDao;
    private static MigrationStatus migrationStatus;

    @Autowired
    public MacroNameMigrator(CustomContentManager contentManager, PageTemplateManager pageTemplateManager, XhtmlContent xhtmlContent, UserAccessor userAccessor, FormatSettingsManager formatSettingsManager, MigrationStatusDao migrationStatusDao) {
        this.contentManager = contentManager;
        this.pageTemplateManager = pageTemplateManager;
        this.xhtmlContent = xhtmlContent;
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.migrationStatusDao = migrationStatusDao;
        this.migrator = new HtmlMacroParamsContentEntityMigrator();
    }

    public void startMigration() throws Exception {
        this.getPageTemplateCounts();
        if (MacroNameMigrator.getMigrationStatusInstance() != null && OverallMigrationStatus.INPROGRESS.equals((Object)MacroNameMigrator.getMigrationStatusInstance().getOverallmigrationstatus())) {
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: A migration already is in progress");
            throw new HtmlMigrationException("Another macro name migration is currently in progress");
        }
        try {
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Started migration for the macro...");
            MacroNameMigrator.getMigrationStatusInstance().setOverallmigrationstatus(OverallMigrationStatus.INPROGRESS);
            StopWatch stopWatch = new StopWatch();
            ScriptUtils.safeWatchStart((StopWatch)stopWatch);
            String migrationStartTime = ScriptUtils.getLoggedinUserTime((UserAccessor)this.userAccessor, (FormatSettingsManager)this.formatSettingsManager);
            MacroNameMigrator.getMigrationStatusInstance().setMigrationstartdate(migrationStartTime);
            this.migrationStatusDao.saveMigrationStatus(MacroNameMigrator.getMigrationStatusInstance());
            if (this.getEntities().size() > 0) {
                this.migrateEntityContents(this.getEntities());
            }
            if (this.getPageTemplates().size() > 0) {
                this.migratePageTemplates(this.getPageTemplates());
            }
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Completed migration for both pages and templates..");
            MacroNameMigrator.getMigrationStatusInstance().setOverallmigrationstatus(OverallMigrationStatus.COMPLETED);
            ScriptUtils.safeWatchStop((StopWatch)stopWatch);
            MacroNameMigrator.getMigrationStatusInstance().setTimetakenformigration(stopWatch.toString());
            this.migrationStatusDao.saveMigrationStatus(MacroNameMigrator.getMigrationStatusInstance());
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: \n No. Of Pages Migarted :\n" + MacroNameMigrator.getMigrationStatusInstance().getNoofpagesmigrated() + " Html macro(s) pages were updated\n" + MacroNameMigrator.getMigrationStatusInstance().getNooftemplatesmigrated() + " Html macro(s) templates were updated\n" + MacroNameMigrator.getMigrationStatusInstance().getNoofpagesfailed() + " Html macro(s) pages could not be updated\n" + MacroNameMigrator.getMigrationStatusInstance().getNooftemplatesfailed() + " Html macro(s) templates could not be updated\n");
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Time taken to migrate pages and templates in hh:mm:ss.ms: {}", (Object)stopWatch);
        }
        catch (Exception exception) {
            this.log.error("HTML_BOBSWIFT_MIGRATION_LOG: Exception while performing the overall migrating process :", (Throwable)exception);
            throw new HtmlMigrationException("Exception while processing the migration :", exception);
        }
    }

    private void migrateEntityContents(List<ContentEntityObject> entities) throws Exception {
        long numPageFailed = 0L;
        long numPageMigrated = 0L;
        long numPageToBeMigrated = 0L;
        try {
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Started migration for the pages...");
            MacroNameMigrator.getMigrationStatusInstance().setPagesmigrationstatus(OverallMigrationStatus.INPROGRESS.getValue());
            MacroNameMigrator.getMigrationStatusInstance().setMigrationstage(MigrationStage.PAGE);
            for (ContentEntityObject entity : entities) {
                this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Migrating content of type '{}' with title '{}'", (Object)entity.getType(), (Object)entity.getTitle());
                BodyContent bodyContent = entity.getBodyContent();
                String originalBodyText = bodyContent == null ? "" : bodyContent.getBody();
                DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)entity.toPageContext());
                ExceptionTolerantMigrator.MigrationResult migrationResult = this.migrator.migrate(originalBodyText, (ConversionContext)conversionContext);
                if (migrationResult == null || !migrationResult.isMigrationPerformed()) {
                    MacroNameMigrator.getMigrationStatusInstance().setNoofpagesfailed(++numPageFailed);
                } else {
                    try {
                        ContentEntityObject originalVersion = (ContentEntityObject)entity.clone();
                        bodyContent.setBodyType(BodyType.XHTML);
                        bodyContent.setBody(migrationResult.getContent());
                        entity.setBodyContent(bodyContent);
                        this.doMigrateContent(entity, originalVersion);
                        MacroNameMigrator.getMigrationStatusInstance().setNoofpagesmigrated(++numPageMigrated);
                    }
                    catch (Exception exception) {
                        MacroNameMigrator.getMigrationStatusInstance().setNoofpagesfailed(++numPageFailed);
                        this.log.error("HTML_BOBSWIFT_MIGRATION_LOG: Unable to set body for entity With Exception Message: {} and  entity object {}", (Object)exception.getMessage(), (Object)entity.getDisplayTitle());
                    }
                }
                this.migrationStatusDao.saveMigrationStatus(MacroNameMigrator.getMigrationStatusInstance());
            }
            MacroNameMigrator.getMigrationStatusInstance().setTotalnoofpageswiththismacro(0L);
        }
        catch (Exception exception) {
            this.log.error("HTML_BOBSWIFT_MIGRATION_LOG: Exception while migrating pages :", (Throwable)exception);
            throw new HtmlMigrationException("Exception while migrating the pages ", exception);
        }
        finally {
            numPageToBeMigrated = MacroNameMigrator.getMigrationStatusInstance().getTotalnoofpageswiththismacro() - MacroNameMigrator.getMigrationStatusInstance().getNoofpagesmigrated();
            MacroNameMigrator.getMigrationStatusInstance().setTotalnoofpagestobemigrated(numPageToBeMigrated);
            MacroNameMigrator.getMigrationStatusInstance().setPagesmigrationstatus(OverallMigrationStatus.COMPLETED.getValue());
            MacroNameMigrator.getMigrationStatusInstance().setTemplatesmigrationstatus(OverallMigrationStatus.NOT_STARTED.getValue());
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Completed migration for the pages...");
            try {
                this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: The migration details finally stored after the migration of the pages done : " + MacroNameMigrator.getMigrationStatusInstance().getMigrationStatusBuilder());
                this.migrationStatusDao.saveMigrationStatus(MacroNameMigrator.getMigrationStatusInstance());
            }
            catch (Exception exception) {
                this.log.error("HTML_BOBSWIFT_MIGRATION_LOG: Exception while storing the migration status for the pages : ", (Throwable)exception);
                throw new HtmlMigrationException("Exception while processing the migration of the pages :", exception);
            }
        }
    }

    private void migratePageTemplates(List<PageTemplate> pageTemplates) throws Exception {
        long numTempMigrated = 0L;
        long numTempFailed = 0L;
        long numTemplatesToBeMigrated = 0L;
        try {
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Started migration for the templates...");
            MacroNameMigrator.getMigrationStatusInstance().setTemplatesmigrationstatus(OverallMigrationStatus.INPROGRESS.getValue());
            MacroNameMigrator.getMigrationStatusInstance().setMigrationstage(MigrationStage.TEMPLATE);
            for (PageTemplate pageTemplate : pageTemplates) {
                this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Migrating template with title '{}'", (Object)pageTemplate.getTitle());
                DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)new PageContext());
                ExceptionTolerantMigrator.MigrationResult migrationResult = this.migrator.migrate(pageTemplate.getContent(), (ConversionContext)conversionContext);
                if (migrationResult == null || !migrationResult.isMigrationPerformed()) {
                    MacroNameMigrator.getMigrationStatusInstance().setNooftemplatesfailed(++numTempFailed);
                } else {
                    try {
                        PageTemplate original = (PageTemplate)pageTemplate.clone();
                        pageTemplate.setContent(migrationResult.getContent());
                        this.pageTemplateManager.savePageTemplate(pageTemplate, original);
                        MacroNameMigrator.getMigrationStatusInstance().setNooftemplatesmigrated(++numTempMigrated);
                    }
                    catch (Exception exception) {
                        MacroNameMigrator.getMigrationStatusInstance().setNooftemplatesfailed(++numTempFailed);
                        this.log.error("HTML_BOBSWIFT_MIGRATION_LOG: Exception while updating templates..{} page template name is {} ", (Object)exception.getMessage(), (Object)pageTemplate.getTitle());
                    }
                }
                this.migrationStatusDao.saveMigrationStatus(MacroNameMigrator.getMigrationStatusInstance());
            }
            MacroNameMigrator.getMigrationStatusInstance().setTotalnooftemplateswiththismacro(0L);
        }
        catch (Exception exception) {
            this.log.error("HTML_BOBSWIFT_MIGRATION_LOG: Exception while migrating the templates :", (Throwable)exception);
            throw new HtmlMigrationException("Exception while processing the migration of the templates :", exception);
        }
        finally {
            numTemplatesToBeMigrated = MacroNameMigrator.getMigrationStatusInstance().getTotalnooftemplateswiththismacro() - MacroNameMigrator.getMigrationStatusInstance().getNooftemplatesmigrated();
            MacroNameMigrator.getMigrationStatusInstance().setTotalnooftemplatestobemigrated(numTemplatesToBeMigrated);
            this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Completed migration for the templates...");
            MacroNameMigrator.getMigrationStatusInstance().setTemplatesmigrationstatus(OverallMigrationStatus.COMPLETED.getValue());
            try {
                this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: The migration details finally stored after the migration of the templates done : " + MacroNameMigrator.getMigrationStatusInstance().getMigrationStatusBuilder());
                this.migrationStatusDao.saveMigrationStatus(MacroNameMigrator.getMigrationStatusInstance());
            }
            catch (Exception exception) {
                this.log.error("HTML_BOBSWIFT_MIGRATION_LOG: Exception while storing the final values of the migration : ", (Throwable)exception);
                throw new HtmlMigrationException("Exception while processing the migration of the templates ", exception);
            }
        }
    }

    public MigrationStatus getMigrationStatus() throws Exception {
        MacroNameMigrator.setMigrationStatus(this.migrationStatusDao.getMigrationStatus());
        this.getPageTemplateCounts();
        try {
            if (OverallMigrationStatus.INPROGRESS.equals((Object)MacroNameMigrator.getMigrationStatusInstance().getOverallmigrationstatus())) {
                return MacroNameMigrator.getMigrationStatusInstance();
            }
            if (OverallMigrationStatus.COMPLETED.equals((Object)MacroNameMigrator.getMigrationStatusInstance().getOverallmigrationstatus())) {
                this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Set and get the details on  refresh from UI post migration completion");
                this.getPageTemplateCounts();
                MacroNameMigrator.getMigrationStatusInstance().resetAfterComplete();
                this.migrationStatusDao.saveMigrationStatus(MacroNameMigrator.getMigrationStatusInstance());
            }
        }
        catch (Exception exception) {
            this.log.error("HTML_BOBSWIFT_MIGRATION_LOG: Exception while Loading the migration data :", (Throwable)exception);
            throw new HtmlMigrationException("Exception while Loading the migration data :", exception);
        }
        this.log.info("HTML_BOBSWIFT_MIGRATION_LOG: Migration details before retune in getMigrationStatus : " + MacroNameMigrator.getMigrationStatusInstance().getMigrationStatusBuilder());
        return MacroNameMigrator.getMigrationStatusInstance();
    }

    private List<ContentEntityObject> findContentWithHtmlMacro() throws InvalidSearchException {
        return ImmutableList.copyOf((Iterator)this.contentManager.findByQuery(new ContentQuery("html.findAllHtmlInContents", new Object[0]), 0, Integer.MAX_VALUE));
    }

    private List<PageTemplate> findPageTemplateWithHtmlMacro() throws InvalidSearchException {
        return ImmutableList.copyOf((Iterator)this.contentManager.findByQuery(new ContentQuery("html.findAllHtmlInPageTemplates", new Object[0]), 0, Integer.MAX_VALUE));
    }

    private long findHtmlMacroCount() throws InvalidSearchException {
        return (Long)ImmutableList.copyOf((Iterator)this.contentManager.findByQuery(new ContentQuery("html.findAllHtmlInContentsCount", new Object[0]), 0, Integer.MAX_VALUE)).get(0);
    }

    private long findHtmlPageTemplateMacroCount() throws InvalidSearchException {
        return (Long)ImmutableList.copyOf((Iterator)this.contentManager.findByQuery(new ContentQuery("html.findAllHtmlInContentsTemplatesCount", new Object[0]), 0, Integer.MAX_VALUE)).get(0);
    }

    private long findTotalContent() throws InvalidSearchException {
        return (Long)ImmutableList.copyOf((Iterator)this.contentManager.findByQuery(new ContentQuery("html.findTotalContent", new Object[0]), 0, Integer.MAX_VALUE)).get(0);
    }

    private long findTotalPageTemplateContent() throws InvalidSearchException {
        return (Long)ImmutableList.copyOf((Iterator)this.contentManager.findByQuery(new ContentQuery("html.findTotalPageTemplateContent", new Object[0]), 0, Integer.MAX_VALUE)).get(0);
    }

    private void doMigrateContent(ContentEntityObject newEntity, ContentEntityObject originalEntity) throws Exception {
        Date originalLastModificationDate = originalEntity.getLastModificationDate();
        if (originalLastModificationDate != null) {
            newEntity.setLastModificationDate(new Date(originalLastModificationDate.getTime() + 1000L));
        }
        newEntity.setLastModifier(AuthenticatedUserThreadLocal.get());
        newEntity.setVersionComment("Macro name changed from html to html-bobswift during server to cloud migration processing.");
        if (newEntity instanceof Draft) {
            Draft draft = (Draft)newEntity;
            draft.setPageVersion(draft.getPageVersion() + 1);
        }
        DefaultSaveContext saveContext = new DefaultSaveContext(true, true, true);
        if (newEntity instanceof Page || newEntity instanceof BlogPost) {
            this.contentManager.saveContentEntity(newEntity, originalEntity, (SaveContext)saveContext);
        } else {
            this.contentManager.saveContentEntity(newEntity, (SaveContext)saveContext);
        }
    }

    private void getPageTemplateCounts() throws InvalidSearchException {
        MacroNameMigrator.getMigrationStatusInstance().setTotalnoofpageswiththismacro(this.findHtmlMacroCount());
        MacroNameMigrator.getMigrationStatusInstance().setTotalnooftemplateswiththismacro(this.findHtmlPageTemplateMacroCount());
        MacroNameMigrator.getMigrationStatusInstance().setOverallnoofpages(this.findTotalContent());
        MacroNameMigrator.getMigrationStatusInstance().setOverallnooftemplates(this.findTotalPageTemplateContent());
    }

    public List<ContentEntityObject> getEntities() throws InvalidSearchException {
        return this.findContentWithHtmlMacro();
    }

    public List<PageTemplate> getPageTemplates() throws InvalidSearchException {
        return this.findPageTemplateWithHtmlMacro();
    }

    public static void setMigrationStatus(MigrationStatus migrationStatus) {
        MacroNameMigrator.migrationStatus = migrationStatus;
    }

    public static MigrationStatus getMigrationStatusInstance() {
        if (migrationStatus == null) {
            MacroNameMigrator.setMigrationStatus(new MigrationStatus());
            migrationStatus.setPagesmigrationstatus(OverallMigrationStatus.NOT_STARTED.getValue());
            migrationStatus.setTemplatesmigrationstatus(OverallMigrationStatus.NOT_STARTED.getValue());
            migrationStatus.setOverallmigrationstatus(OverallMigrationStatus.NOT_STARTED);
        }
        return migrationStatus;
    }

    class HtmlMacroParamsContentEntityMigrator
    extends AbstractExceptionTolerantMigrator {
        HtmlMacroParamsContentEntityMigrator() {
        }

        public ExceptionTolerantMigrator.MigrationResult migrate(String content, ConversionContext conversionContext) {
            try {
                String migratedContent = MacroNameMigrator.this.xhtmlContent.updateMacroDefinitions(content, conversionContext, new MacroDefinitionUpdater(){

                    public MacroDefinition update(MacroDefinition macroDefinition) {
                        String bodyContent;
                        if (StringUtils.equals((String)macroDefinition.getName(), (String)"html")) {
                            HtmlMacroParamsContentEntityMigrator.this.processParams(macroDefinition);
                        } else if (macroDefinition.getBody() != null && ((bodyContent = macroDefinition.getBody().getBody()).contains("ac:name=\"html\"") || bodyContent.contains("{html}") || bodyContent.contains("{html:"))) {
                            String acNameChanged = bodyContent.replaceAll("ac:name=\"html\"", "ac:name=\"html-bobswift\"");
                            String markupChanged = acNameChanged.replaceAll("\\{html\\}", "{html-bobswift}");
                            String markupChangedfinal = markupChanged.replaceAll("\\{html:", "{html-bobswift:");
                            if (macroDefinition.getBody() instanceof PlainTextMacroBody) {
                                MacroDefinitionBuilder builder = MacroDefinition.builder((String)macroDefinition.getName()).withMacroBody((MacroBody)new PlainTextMacroBody(markupChangedfinal));
                                macroDefinition.setBody(builder.build().getBody());
                            } else {
                                MacroDefinitionBuilder builder = MacroDefinition.builder((String)macroDefinition.getName()).withMacroBody((MacroBody)new RichTextMacroBody(markupChangedfinal));
                                builder.build();
                                macroDefinition.setBody(builder.build().getBody());
                            }
                        }
                        return macroDefinition;
                    }
                });
                return new ExceptionTolerantMigrator.MigrationResult(migratedContent, true);
            }
            catch (XhtmlException e) {
                MacroNameMigrator.this.log.debug("HTML_BOBSWIFT_MIGRATION_LOG: Encountered an exception during Html macro migration", (Throwable)e);
                return new ExceptionTolerantMigrator.MigrationResult(content, false);
            }
        }

        private void processParams(MacroDefinition macroDefinition) {
            macroDefinition.setName("html-bobswift");
        }
    }
}

