/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.listener;

import com.appfire.common.analytics.util.AnalyticEvent;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.event.PluginLicenseAddedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseUpdatedEvent;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.swift.confluence.html.util.HtmlAnalyticsHelper;
import org.swift.confluence.html.util.MigrationHelper;
import org.swift.confluence.scriptutil.EncryptDecryptHelper;

@Component
public class HtmlAnalyticsListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(HtmlAnalyticsListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final BootstrapManager bootstrapManager;
    private final HostLicenseInformation compatibilityHostLicenseInformation;
    @ComponentImport
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    @ComponentImport
    private final XhtmlContent xhtmlManager;
    private final BandanaManager bandanaManager;

    @Autowired
    public HtmlAnalyticsListener(PluginLicenseEventRegistry pluginLicenseEventRegistry, EventPublisher eventPublisher, PluginLicenseManager licenseManager, BootstrapManager bootstrapManager, @ComponentImport LicenseHandler licenseHandler, @ComponentImport com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, XhtmlContent xhtmlManager, BandanaManager bandanaManager) {
        this.eventPublisher = eventPublisher;
        this.eventPublisher.register((Object)this);
        this.licenseManager = licenseManager;
        this.bootstrapManager = bootstrapManager;
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.pluginLicenseEventRegistry.register((Object)this);
        this.compatibilityHostLicenseInformation = new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
        this.xhtmlManager = xhtmlManager;
        this.bandanaManager = bandanaManager;
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            String filePrefix = "org.swift.confluence.html";
            String confluenceSharedHome = this.bootstrapManager.getSharedHome().getAbsolutePath();
            String pluginFolderPath = confluenceSharedHome + File.separator + filePrefix;
            EncryptDecryptHelper.initialize((String)pluginFolderPath, (String)filePrefix);
        }
        catch (Exception e) {
            log.error("Error while generating encryption keys ", (Object)e.getMessage());
        }
        Plugin thisPlugin = event.getPlugin();
        try {
            if ("org.swift.confluence.html".equalsIgnoreCase(thisPlugin.getKey())) {
                MigrationHelper migrationHelper = new MigrationHelper(this.bandanaManager);
                migrationHelper.migrateGlobalConfig();
                HtmlAnalyticsHelper helper = new HtmlAnalyticsHelper(this.licenseManager, this.compatibilityHostLicenseInformation);
                helper.postInstallUninstallEvent(AnalyticEvent.Event.INSTALL);
            }
        }
        catch (Exception e) {
            log.error("Error in Analytics Listener : {}", (Object)e.getMessage());
        }
    }

    @EventListener
    public void onPageCreateEvent(PageCreateEvent e) {
        if (this.getSendStatistics().equalsIgnoreCase("on")) {
            try {
                this.xhtmlManager.handleMacroDefinitions(e.getPage().getBodyAsString(), (ConversionContext)new DefaultConversionContext(new RenderContext()), new MacroDefinitionHandler(){

                    public void handle(MacroDefinition macroDefinition) {
                        String macroName = macroDefinition.getName();
                        if ("html".equals(macroName) || "html-bobswift".equals(macroName) || "xslt".equals(macroName)) {
                            HtmlAnalyticsHelper helper = new HtmlAnalyticsHelper(HtmlAnalyticsListener.this.licenseManager, HtmlAnalyticsListener.this.compatibilityHostLicenseInformation);
                            helper.postNewMacroAnalytics(macroDefinition.getName(), macroDefinition.getParameters());
                        }
                    }
                });
            }
            catch (XhtmlException ex) {
                log.error("XHTML Exception Keen IO for Create Event : {}", (Object)ex.getMessage());
            }
        }
    }

    public void destroy() throws Exception {
        HtmlAnalyticsHelper helper = new HtmlAnalyticsHelper(this.licenseManager, this.compatibilityHostLicenseInformation);
        helper.postInstallUninstallEvent(AnalyticEvent.Event.UNINSTALL);
        log.info("destroy called");
        this.eventPublisher.unregister((Object)this);
        this.pluginLicenseEventRegistry.unregister((Object)this);
    }

    @EventListener
    public void onEvent(PluginLicenseAddedEvent event) {
        HtmlAnalyticsHelper helper = new HtmlAnalyticsHelper(this.licenseManager, this.compatibilityHostLicenseInformation);
        helper.postAnalyticsEvent(AnalyticEvent.Event.LICENSED, AnalyticEvent.SubEvent.LICENSEADDED.getEvent());
    }

    @EventListener
    public void onEvent(PluginLicenseUpdatedEvent event) {
        HtmlAnalyticsHelper helper = new HtmlAnalyticsHelper(this.licenseManager, this.compatibilityHostLicenseInformation);
        helper.postAnalyticsEvent(AnalyticEvent.Event.LICENSED, AnalyticEvent.SubEvent.LICENSEUPDATED.getEvent());
    }

    public void afterPropertiesSet() throws Exception {
    }

    private String getSendStatistics() {
        String sendStatistics = null;
        try {
            sendStatistics = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.sendStatistics");
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
        }
        if (sendStatistics == null) {
            sendStatistics = "on";
        }
        log.debug("retrieved sendStatistics: {}", (Object)sendStatistics);
        return sendStatistics;
    }
}

