/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.listener;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.upm.datacentercompatibility.impl.CompatibilityHostLicenseInformation;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.swift.confluence.html.bean.GlobalConfigBean;
import org.swift.confluence.html.util.HtmlAnalyticsHelper;

@Component
public class AnalyticsUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsUpgradeTask.class);
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    @ComponentImport
    private final PluginLicenseManager licenseManager;
    @ComponentImport
    private final BandanaManager bandanaManager;
    private final HostLicenseInformation hostLicenseInformation;

    @Autowired
    public AnalyticsUpgradeTask(PluginLicenseManager licenseManager, BandanaManager bandanaManager, PluginAccessor pluginAccessor, @ComponentImport com.atlassian.upm.api.license.HostLicenseInformation upmHostLicenseInformation, @ComponentImport LicenseHandler licenseHandler) {
        this.licenseManager = licenseManager;
        this.bandanaManager = bandanaManager;
        this.pluginAccessor = pluginAccessor;
        this.hostLicenseInformation = new CompatibilityHostLicenseInformation(upmHostLicenseInformation, licenseHandler);
    }

    public int getBuildNumber() {
        int buildNumber = Integer.parseInt((String)this.pluginAccessor.getPlugin("org.swift.confluence.html").getPluginInformation().getParameters().get("build"));
        return buildNumber;
    }

    public String getShortDescription() {
        return null;
    }

    public Collection<Message> doUpgrade() throws Exception {
        HtmlAnalyticsHelper helper = new HtmlAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
        GlobalConfigBean configBean = this.buildConfigBean();
        if (configBean != null) {
            helper.postGlobalConfigAnalyticsEvent(configBean);
        }
        return null;
    }

    public String getPluginKey() {
        return "org.swift.confluence.html";
    }

    private GlobalConfigBean buildConfigBean() {
        log.debug("building config bean");
        GlobalConfigBean configBean = new GlobalConfigBean();
        ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();
        String disableSecureProcessing = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.disableSecureProcessing");
        String allowWhitelistedUrls = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowWhitelistedUrls");
        String allowJavascript = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowJavascript");
        String sendStatistics = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.sendStatistics");
        if (disableSecureProcessing == null && allowWhitelistedUrls == null && sendStatistics == null && allowJavascript == null) {
            return null;
        }
        configBean.setDisableSecureProcessing(disableSecureProcessing);
        configBean.setAllowWhitelistedUrls(allowWhitelistedUrls);
        configBean.setSendStatistics(sendStatistics);
        configBean.setAllowJavascript(allowJavascript);
        return configBean;
    }
}

