/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.config;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import com.atlassian.user.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.html.bean.GlobalConfigBean;
import org.swift.confluence.html.service.ManageProfileService;
import org.swift.confluence.html.util.EventSubType;
import org.swift.confluence.html.util.HTMLUtils;
import org.swift.confluence.html.util.HtmlAnalyticsHelper;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;

public class ConfigurePluginAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public String disableSecureProcessing;
    public String allowWhitelistedUrls;
    public String sendStatistics;
    public String prevSendStatistics;
    private String allowJavascript;
    private String blacklistDomains;
    public String blacklistDomainValues;
    public boolean isInvalidInput = false;
    private String itestAllow;
    private String allowJavaScriptWarning;
    public InetAddressValidator validator = InetAddressValidator.getInstance();
    public String confirm;
    @ComponentImport
    private BandanaManager bandanaManager;
    @ComponentImport
    private PluginLicenseManager licenseManager;
    @ComponentImport
    private I18nResolver i18nResolver;
    private static final ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();
    private HostLicenseInformation hostLicenseInformation;
    private final String I18N_PREFIX_KEY = ConfigurePluginAction.class.getPackage().getName();
    private ManageProfileService manageProfileService;

    public void setManageProfileService(ManageProfileService manageProfileService) {
        this.manageProfileService = manageProfileService;
    }

    public void setPluginLicenseManager(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String getActionName(String fullClassName) {
        return "HTML for Confluence - Configuration";
    }

    public String input() {
        return "input";
    }

    public boolean isReadOnly() {
        return ScriptUtils.isReadOnly();
    }

    public String save() throws Exception {
        HttpServletRequest request = ServletContextThreadLocal.getRequest();
        if (request.getMethod().equalsIgnoreCase("GET") && !"true".equals(this.itestAllow)) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".operation-not-supported"));
            return "error";
        }
        if (ScriptUtils.isReadOnly()) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".readonly-warning-message"));
            return "error";
        }
        GlobalConfigBean configBean = null;
        String result = "success";
        boolean firstTimeFlag = this.checkIfFirstTimeConfigSaving();
        if (this.confirm != null && this.confirm.equalsIgnoreCase("true")) {
            if (!this.saveDisableSecureProcessing()) {
                result = "error";
            }
            if (!this.saveAllowWhitelistedUrls()) {
                result = "error";
            }
            if (!this.saveAllowJavascript()) {
                result = "error";
            }
            if (!this.saveSendStatistics()) {
                result = "error";
            }
            if (!this.saveBlacklistDomains()) {
                result = "error";
            }
            if (!this.saveAllowJavaScriptWarning()) {
                result = "error";
            }
            if (this.isBlacklistDomainFlagOn() && !this.saveBlacklistDomainValues()) {
                result = "error";
            }
            if (result.equals("success")) {
                this.addActionMessage("Settings saved.");
            }
        } else {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".settings-couldnotsave-loginexpired"));
            result = "error";
        }
        EventSubType subType = null;
        if (result.equals("success") && firstTimeFlag) {
            subType = EventSubType.CREATE;
        } else if ("success".equals(result) && ("on".equalsIgnoreCase(this.getSendStatistics()) || "off".equalsIgnoreCase(this.getSendStatistics()) && "on".equalsIgnoreCase(this.getPrevSendStatistics()))) {
            subType = EventSubType.UPDATE;
        }
        if (subType != null) {
            configBean = this.buildConfigBean();
            HtmlAnalyticsHelper helper = new HtmlAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
            helper.postGlobalConfigAnalyticsEvent(configBean);
        }
        return result;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public String restoreDefaults() {
        String result = "success";
        try {
            this.bandanaManager.removeValue((BandanaContext)bandanaContext, this.disableSecureProcessing);
        }
        catch (Exception exception) {
            this.log.debug("Ignore exception restoring default config: {}", (Object)exception.toString());
        }
        return result;
    }

    public void setItestAllow(String str) {
        this.itestAllow = str;
    }

    public String getDisableSecureProcessing() {
        if (!this.isInvalidInput) {
            try {
                this.disableSecureProcessing = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.disableSecureProcessing");
            }
            catch (Exception exception) {
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unableto-retrieve-previous-disablesecureprocessing-setting"));
                this.disableSecureProcessing = null;
            }
            if (this.disableSecureProcessing == null) {
                this.disableSecureProcessing = "off";
            }
            this.log.debug("retrieved disableSecureProcessing: {}", (Object)this.disableSecureProcessing);
        }
        return this.disableSecureProcessing;
    }

    public void setDisableSecureProcessing(String disableSecureProcessing) {
        this.disableSecureProcessing = disableSecureProcessing;
    }

    public boolean saveDisableSecureProcessing() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.disableSecureProcessing);
        try {
            if (this.disableSecureProcessing == null) {
                this.disableSecureProcessing = "off";
            }
            this.bandanaManager.setValue((BandanaContext)bandanaContext, "org.swift.confluence.html.disableSecureProcessing", (Object)this.disableSecureProcessing);
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-disablesecureprocessing-setting"));
            success = false;
        }
        return success;
    }

    public String getAllowJavascript() {
        if (!this.isInvalidInput) {
            try {
                this.allowJavascript = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowJavascript");
                if (this.allowJavascript == null) {
                    this.allowJavascript = "on";
                }
            }
            catch (Exception exception) {
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unableto-retrieve-previous-allowjavascript-setting"));
            }
            this.log.debug("retrieved restrictJavaScript: {}", (Object)this.allowJavascript);
        }
        return this.allowJavascript;
    }

    public boolean saveAllowJavascript() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.allowJavascript);
        try {
            if (this.allowJavascript == null) {
                this.allowJavascript = "off";
            }
            this.bandanaManager.setValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowJavascript", (Object)this.allowJavascript);
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-allowjavascript-setting"));
            success = false;
        }
        return success;
    }

    public void setAllowJavascript(String allowJavascript) {
        this.allowJavascript = allowJavascript;
    }

    public String getAllowWhitelistedUrls() {
        if (!this.isInvalidInput) {
            try {
                this.allowWhitelistedUrls = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowWhitelistedUrls");
                if (this.allowWhitelistedUrls == null) {
                    this.allowWhitelistedUrls = "off";
                }
            }
            catch (Exception exception) {
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unableto-retrieve-previous-allowwhitelistedurls-setting"));
            }
            this.log.debug("retrieved allowWhitelistedUrls: {}", (Object)this.allowWhitelistedUrls);
        }
        return this.allowWhitelistedUrls;
    }

    public void setAllowWhitelistedUrls(String allowWhitelistedUrls) {
        this.allowWhitelistedUrls = allowWhitelistedUrls;
    }

    public boolean saveAllowWhitelistedUrls() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.allowWhitelistedUrls);
        try {
            if (this.allowWhitelistedUrls == null) {
                this.allowWhitelistedUrls = "off";
            }
            this.bandanaManager.setValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowWhitelistedUrls", (Object)this.allowWhitelistedUrls);
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-allowwhitelistedurls-setting"));
            success = false;
        }
        return success;
    }

    public String getSendStatistics() {
        if (!this.isInvalidInput) {
            try {
                this.sendStatistics = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.sendStatistics");
            }
            catch (Exception exception) {
                this.log.error(exception.getMessage());
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unableto-retrieve-previous-sendstatistics-setting"));
            }
            if (this.sendStatistics == null) {
                this.sendStatistics = "on";
            }
            this.log.debug("retrieved sendStatistics: {}", (Object)this.sendStatistics);
        }
        return this.sendStatistics;
    }

    public void setSendStatistics(String sendStatistics) {
        this.sendStatistics = sendStatistics;
    }

    public boolean saveSendStatistics() {
        boolean success = true;
        this.prevSendStatistics = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.sendStatistics");
        this.log.debug("saving: {}", (Object)this.sendStatistics);
        try {
            if (this.sendStatistics == null) {
                this.sendStatistics = "off";
            }
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.sendStatistics", (Object)this.sendStatistics);
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-sendstatistics-setting"));
            success = false;
        }
        return success;
    }

    public String getBlacklistDomains() {
        if (!this.isInvalidInput) {
            try {
                this.blacklistDomains = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.blacklistDomains");
            }
            catch (Exception exception) {
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unable-to-retrive-previous-blacklistdomains-setting"));
                this.blacklistDomains = null;
            }
            if (this.blacklistDomains == null) {
                this.blacklistDomains = "off";
            }
            this.log.debug("retrieved blacklistDomains: {}", (Object)this.blacklistDomains);
        }
        return this.blacklistDomains;
    }

    public void setBlacklistDomains(String blacklistDomains) {
        this.blacklistDomains = blacklistDomains;
    }

    public boolean saveBlacklistDomains() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.blacklistDomains);
        try {
            if (this.blacklistDomains == null) {
                this.blacklistDomains = "off";
            }
            this.bandanaManager.setValue((BandanaContext)bandanaContext, "org.swift.confluence.html.blacklistDomains", (Object)this.blacklistDomains);
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-blacklistdomains-setting"));
            success = false;
        }
        return success;
    }

    public boolean saveBlacklistDomainValues() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.blacklistDomainValues);
        try {
            if (StringUtils.isBlank((CharSequence)this.blacklistDomainValues)) {
                this.blacklistDomainValues = this.getText(this.I18N_PREFIX_KEY + ".blaclistdomainvalues.default");
            }
            try {
                String tempValue = null;
                tempValue = HTMLUtils.validateIPAddress(this.blacklistDomainValues, this.validator);
                if (StringUtils.isNotBlank((CharSequence)tempValue)) {
                    this.blacklistDomainValues = tempValue;
                }
            }
            catch (Exception exception) {
                this.addActionError(this.i18nResolver.getText(this.I18N_PREFIX_KEY + ".blaclistdomainvalues.invalid.ip.value", new Serializable[]{exception.getMessage()}));
                success = false;
                this.isInvalidInput = true;
                return success;
            }
            this.bandanaManager.setValue((BandanaContext)bandanaContext, "org.swift.confluence.html.blacklistDomainValues", (Object)this.blacklistDomainValues);
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-blacklistdomains-setting"));
            success = false;
        }
        return success;
    }

    public void setBlacklistDomainValues(String blacklistDomainValues) {
        this.blacklistDomainValues = blacklistDomainValues;
    }

    public String getBlacklistDomainValues() {
        if (!this.isInvalidInput) {
            try {
                this.blacklistDomainValues = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.blacklistDomainValues");
            }
            catch (Exception exception) {
                this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unableto-retrieve-previous-blacklistDomainValues-usedefault"));
            }
            if (StringUtils.isBlank((CharSequence)this.blacklistDomainValues)) {
                this.blacklistDomainValues = this.getText(this.I18N_PREFIX_KEY + ".blaclistdomainvalues.default");
            }
            this.log.debug("retrieved blacklistDomainValues: {}", (Object)this.blacklistDomainValues);
        }
        return this.blacklistDomainValues;
    }

    public boolean checkIfFirstTimeConfigSaving() {
        boolean firstTimeFlag = false;
        try {
            ConfluenceBandanaContext banadanContext = new ConfluenceBandanaContext();
            String disableSecureProcessing = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.html.disableSecureProcessing");
            String blacklistDomainValues = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.html.blacklistDomainValues");
            String allowWhitelistedUrls = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.html.allowWhitelistedUrls");
            String blacklistDomains = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.html.blacklistDomains");
            String sendStatistics = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.html.sendStatistics");
            String restrictJavaScript = (String)this.bandanaManager.getValue((BandanaContext)banadanContext, "org.swift.confluence.html.allowJavascript");
            firstTimeFlag = disableSecureProcessing == null && allowWhitelistedUrls == null && blacklistDomains == null && restrictJavaScript == null && sendStatistics == null && blacklistDomainValues == null;
        }
        catch (Exception e) {
            firstTimeFlag = true;
        }
        return firstTimeFlag;
    }

    private GlobalConfigBean buildConfigBean() {
        this.log.debug("building config bean");
        GlobalConfigBean configBean = new GlobalConfigBean();
        configBean.setDisableSecureProcessing(this.disableSecureProcessing);
        configBean.setAllowWhitelistedUrls(this.allowWhitelistedUrls);
        configBean.setSendStatistics(this.sendStatistics);
        configBean.setBlacklistDomains(this.blacklistDomains);
        configBean.setAllowJavascript(this.allowJavascript);
        if (StringUtils.isNotBlank((CharSequence)this.blacklistDomainValues)) {
            configBean.setBlacklistDomainValues(Boolean.TRUE);
        } else {
            configBean.setBlacklistDomainValues(Boolean.FALSE);
        }
        return configBean;
    }

    public String getPrevSendStatistics() {
        return this.prevSendStatistics;
    }

    public void setHostLicenseInformation(HostLicenseInformation hostLicenseInformation) {
        this.hostLicenseInformation = hostLicenseInformation;
    }

    public List<ProfileBean> getProfilesList() {
        ArrayList<ProfileBean> profilesList = new ArrayList();
        try {
            profilesList = HTMLUtils.getProfileBeansFromEntities(this.manageProfileService.getProfiles());
        }
        catch (Exception e) {
            this.addActionError(this.getText("org.swift.confluence.html.unableto-retrieve-profileslist-please-tryagain"));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        Collections.sort(profilesList, new Comparator<ProfileBean>(){

            @Override
            public int compare(ProfileBean profileBean1, ProfileBean profileBean2) {
                return profileBean1.getProfileName().compareTo(profileBean2.getProfileName());
            }
        });
        return profilesList;
    }

    public boolean isBlacklistDomainFlagOn() {
        boolean isFlagOn = false;
        try {
            this.blacklistDomains = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.blacklistDomains");
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unable-to-retrive-previous-blacklistdomains-setting"));
            this.blacklistDomains = null;
        }
        if (this.blacklistDomains != null && "on".equalsIgnoreCase(this.blacklistDomains)) {
            isFlagOn = true;
        }
        return isFlagOn;
    }

    public String getAllowJavaScriptWarning() {
        try {
            this.allowJavaScriptWarning = (String)this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowJavaScriptWarning");
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".unable-to-retrieve-previous-allowJavaScriptWarning"));
        }
        if (this.allowJavaScriptWarning == null) {
            this.allowJavaScriptWarning = "on";
        }
        this.log.debug("retrieved allowJavaScriptWarning: {}", (Object)this.allowJavaScriptWarning);
        return this.allowJavaScriptWarning;
    }

    public boolean isAllowJavaScriptWarningEnabled() {
        return this.getAllowJavaScriptWarning().equalsIgnoreCase("on");
    }

    public boolean saveAllowJavaScriptWarning() {
        boolean success = true;
        this.log.debug("saving: {}", (Object)this.allowJavaScriptWarning);
        try {
            if (this.allowJavaScriptWarning == null) {
                this.allowJavaScriptWarning = "off";
            }
            this.bandanaManager.setValue((BandanaContext)bandanaContext, "org.swift.confluence.html.allowJavaScriptWarning", (Object)this.allowJavaScriptWarning);
        }
        catch (Exception exception) {
            this.addActionError(this.getText(this.I18N_PREFIX_KEY + ".cannot-store-allowJavaScriptWarning"));
            success = false;
        }
        return success;
    }

    public void setAllowJavaScriptWarning(String allowJavaScriptWarning) {
        this.allowJavaScriptWarning = allowJavaScriptWarning;
    }
}

