/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html.config;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.datacentercompatibility.HostLicenseInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.html.bean.MigrationStatus;
import org.swift.confluence.html.bean.OverallMigrationStatus;
import org.swift.confluence.html.exception.HtmlMigrationException;
import org.swift.confluence.html.migrator.MacroNameMigrator;
import org.swift.confluence.html.migrator.MigrationStatusDao;
import org.swift.confluence.html.util.HtmlAnalyticsHelper;
import org.swift.confluence.scriptutil.ScriptUtils;

public class ConfigMigratePluginAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MigrationStatus migrationStatus = null;
    private MacroNameMigrator macroNameMigrator;
    private HostLicenseInformation hostLicenseInformation;
    @ComponentImport
    private PluginLicenseManager licenseManager;
    private MigrationStatusDao migrationStatusDao;

    public void setMigrationStatusDao(MigrationStatusDao migrationStatusDao) {
        this.migrationStatusDao = migrationStatusDao;
    }

    public void setMacroNameMigrator(MacroNameMigrator macroNameMigrator) {
        this.macroNameMigrator = macroNameMigrator;
    }

    public void setPluginLicenseManager(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setHostLicenseInformation(HostLicenseInformation hostLicenseInformation) {
        this.hostLicenseInformation = hostLicenseInformation;
    }

    public String getActionName(String fullClassName) {
        return "Server to Cloud Confluence Macro Migration";
    }

    public boolean isReadOnly() {
        return ScriptUtils.isReadOnly();
    }

    public String updatePages() throws HtmlMigrationException {
        try {
            this.log.info("Migration has started for the Bob Swift html macro.");
            this.macroNameMigrator.startMigration();
            this.migrationStatus = MacroNameMigrator.getMigrationStatusInstance();
        }
        catch (Exception exception) {
            this.addActionError(exception.getMessage());
            this.log.error("Error while updating pages ", (Throwable)exception);
            throw new HtmlMigrationException("Error while updating pages ", exception);
        }
        finally {
            HtmlAnalyticsHelper helper = new HtmlAnalyticsHelper(this.licenseManager, this.hostLicenseInformation);
            try {
                MigrationStatus migrationStatus = this.migrationStatusDao.getMigrationStatus();
                if (migrationStatus != null && OverallMigrationStatus.COMPLETED.equals((Object)migrationStatus.getOverallmigrationstatus())) {
                    helper.postGlobalConfigMigrationEvent(migrationStatus);
                }
            }
            catch (Exception exception) {
                helper.postErrorEvent(exception.getMessage());
                this.log.error("Error while posting migration status to analytics: ", (Throwable)exception);
                throw new HtmlMigrationException("Error while posting migration status to analytics: ", exception);
            }
        }
        return "success";
    }

    public String migrationStatus() throws HtmlMigrationException {
        try {
            this.migrationStatus = this.macroNameMigrator.getMigrationStatus();
        }
        catch (Exception exception) {
            this.addActionError(exception.getMessage());
            this.log.error("Error while getting migration status: ", (Throwable)exception);
            throw new HtmlMigrationException("Error while getting migration status: ", exception);
        }
        return "success";
    }

    public MigrationStatus getMigrationStatus() throws Exception {
        try {
            this.migrationStatus = this.macroNameMigrator.getMigrationStatus();
        }
        catch (Exception exception) {
            this.addActionError(exception.getMessage());
            throw new HtmlMigrationException("Error while getting migration status: ", exception);
        }
        return this.migrationStatus;
    }
}

