/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.swift.confluence.html.CustomErrorHandler;
import org.swift.confluence.html.CustomResolver;
import org.swift.confluence.html.CustomUriResolver;
import org.swift.confluence.html.XsltErrorListener;
import org.swift.confluence.html.service.ManageProfileService;
import org.swift.confluence.html.util.HTMLUtils;
import org.swift.confluence.macrosecurity.utils.MacroSecurityUtils;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.FindReplaceUtilities;
import org.swift.confluence.scriptutil.LicensedScriptMacro;
import org.swift.confluence.scriptutil.ProfileHelperAO;
import org.swift.confluence.scriptutil.ScriptLibCommonBean;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XsltMacro
extends LicensedScriptMacro {
    protected static final RenderMode RENDER_MODE_WIKI = RenderMode.suppress((long)256L);
    protected final BandanaManager bandanaManager;
    @ComponentImport
    protected final UserAccessor userAccessor;
    protected final SubRenderer subRenderer;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final ManageProfileService manageProfileService;
    @ComponentImport
    private final ApplicationLinkService applicationLinkService;
    protected static final ConfluenceBandanaContext bandanaContext = new ConfluenceBandanaContext();

    public XsltMacro(@ComponentImport SettingsManager settingsManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport PageTemplateManager templateManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, PermissionManager permissionManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport LocaleManager localeManager, @ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport BandanaManager bandanaManager, UserAccessor userAccessor, @ComponentImport SubRenderer subRenderer, @ComponentImport I18nResolver i18nResolver, ManageProfileService manageProfileService, @ComponentImport ApplicationLinkService applicationLinkService) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, licenseManager, xhtmlContent);
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
        this.subRenderer = subRenderer;
        this.i18nResolver = i18nResolver;
        this.applicationLinkService = applicationLinkService;
        this.manageProfileService = manageProfileService;
    }

    protected boolean exemptDeveloperLicense() {
        return true;
    }

    protected String getExtension() {
        return ".xslt";
    }

    protected String getMacroName() {
        return "xslt";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    /*
     * Loose catch block
     */
    public String execute(MacroInfo info) throws MacroExecutionException {
        String string;
        InputStream styleStream = null;
        InputStream xmlStream = null;
        String xmlString = null;
        String styleString = null;
        try {
            block44: {
                String applinkStyle;
                ApplicationLink appLink;
                block42: {
                    String style;
                    String encoding;
                    block45: {
                        String profileName;
                        block43: {
                            boolean isBodyUsed;
                            block40: {
                                String applinkSrc;
                                block38: {
                                    String source;
                                    boolean needFindReplace;
                                    block41: {
                                        block39: {
                                            this.validateLicense(this.licenseManager);
                                            MacroSecurityUtils.securityCheck((BandanaManager)this.bandanaManager, (UserAccessor)this.userAccessor, (String)this.getMacroName(), (MacroInfo)info);
                                            isBodyUsed = false;
                                            needFindReplace = FindReplaceUtilities.needFindReplace((MacroInfo)info);
                                            source = info.getMacroParams().getString("source", "");
                                            encoding = info.getMacroParams().getString("encoding", "");
                                            profileName = info.getMacroParams().getString("profile", "");
                                            applinkSrc = "";
                                            if (StringUtils.isNotBlank((String)source)) {
                                                applinkSrc = source.substring(1);
                                            }
                                            if ((appLink = ScriptUtils.getApplicationLinkFromURL((String)applinkSrc, (ApplicationLinkService)this.applicationLinkService)) != null) break block38;
                                            if (source.trim().length() != 0) break block39;
                                            xmlString = FindReplaceUtilities.findReplace((MacroInfo)info, (String)ScriptUtils.trim((String)info.getMacroBody()));
                                            isBodyUsed = true;
                                            break block40;
                                        }
                                        if (!StringUtils.isNotBlank((String)profileName)) break block41;
                                        ProfileBean profileBean = this.manageProfileService.getProfileBeanForProfileName(profileName);
                                        if (profileBean != null) {
                                            if (MacroSecurityUtils.isSecurityEnabled((BandanaManager)this.bandanaManager)) {
                                                MacroSecurityUtils.securityCheck((BandanaManager)this.bandanaManager, (UserAccessor)this.userAccessor, (String)this.getMacroName(), (MacroInfo)info, (String)"profile", null);
                                            }
                                            String url = ProfileHelperAO.getUrlParameter((ProfileBean)profileBean, (MacroInfo)info, (String)"source", null, (BandanaManager)this.bandanaManager, (String)"org.swift.confluence.html.allowWhitelistedUrls", (String)"org.swift.confluence.html.blacklistDomains");
                                            xmlString = ProfileHelperAO.retrieveDataFromUrl((MacroInfo)info, (ProfileBean)profileBean, (String)url, (SettingsManager)this.settingsManager, (I18nResolver)this.i18nResolver, (String)"org.swift.confluence.html").toString();
                                            if (needFindReplace) {
                                                xmlString = FindReplaceUtilities.findReplace((MacroInfo)info, (String)xmlString);
                                            }
                                        } else {
                                            ScriptLibCommonBean scriptLibCommonBean = this.prepareScriptLibBean(info, "source");
                                            this.getDataAllowUrl(scriptLibCommonBean);
                                            xmlStream = this.getUrlStream(info, null, source);
                                            if (needFindReplace) {
                                                xmlString = FindReplaceUtilities.findReplace((MacroInfo)info, (String)ScriptUtils.getStreamAsString((InputStream)xmlStream, (String)encoding));
                                            }
                                        }
                                        break block40;
                                    }
                                    switch (ScriptUtils.getResourceType((String)source, (boolean)true)) {
                                        case 1: {
                                            xmlString = FindReplaceUtilities.findReplace((MacroInfo)info, (String)ScriptUtils.getFileAsString((File)this.getScriptAsFile(source.substring(1)), (String)encoding));
                                            break block40;
                                        }
                                        case 4: {
                                            if (needFindReplace) {
                                                xmlString = FindReplaceUtilities.findReplace((MacroInfo)info, (String)ScriptUtils.getStreamAsString((InputStream)this.getAttachmentAsStream(source, info.getContent().toPageContext()), (String)encoding));
                                            } else {
                                                xmlStream = this.getAttachmentAsStream(source, info.getContent().toPageContext());
                                            }
                                            break block40;
                                        }
                                        case 3: {
                                            xmlString = FindReplaceUtilities.findReplace((MacroInfo)info, (String)this.getTemplateAsString(info, source));
                                            break block40;
                                        }
                                        case 2: {
                                            ScriptLibCommonBean scriptLibCommonBean = this.prepareScriptLibBean(info, "source");
                                            this.getDataAllowUrl(scriptLibCommonBean);
                                            xmlStream = this.getUrlStream(info, null, source.substring(1));
                                            if (needFindReplace) {
                                                xmlString = FindReplaceUtilities.findReplace((MacroInfo)info, (String)ScriptUtils.getStreamAsString((InputStream)xmlStream, (String)encoding));
                                            }
                                            break block40;
                                        }
                                        default: {
                                            throw new MacroExecutionException(this.i18nResolver.getText("org.swift.confluence.html.unsupported.xml.resource.type.message-warning"));
                                        }
                                    }
                                }
                                xmlString = ScriptUtils.getStreamAsString((MacroInfo)info, (InputStream)ScriptUtils.retrieveDataFromAppLink((MacroInfo)info, (ApplicationLink)appLink, (String)applinkSrc, (String)this.getSessionCookie(info, applinkSrc), (I18nResolver)this.i18nResolver, (String)"org.swift.confluence.html"));
                            }
                            style = info.getMacroParams().getString("style", "");
                            applinkStyle = "";
                            if (StringUtils.isNotBlank((String)style)) {
                                applinkStyle = style.substring(1);
                            }
                            if ((appLink = ScriptUtils.getApplicationLinkFromURL((String)applinkStyle, (ApplicationLinkService)this.applicationLinkService)) != null) break block42;
                            if (style.trim().length() != 0) break block43;
                            if (isBodyUsed) {
                                throw new MacroExecutionException(this.i18nResolver.getText("org.swift.confluence.html.style.parameter.must.be.provided.message-warning"));
                            }
                            styleString = ScriptUtils.trim((String)info.getMacroBody());
                            break block44;
                        }
                        if (!StringUtils.isNotBlank((String)profileName)) break block45;
                        ProfileBean profileBean = this.manageProfileService.getProfileBeanForProfileName(profileName);
                        if (profileBean != null) {
                            if (MacroSecurityUtils.isSecurityEnabled((BandanaManager)this.bandanaManager)) {
                                MacroSecurityUtils.securityCheck((BandanaManager)this.bandanaManager, (UserAccessor)this.userAccessor, (String)this.getMacroName(), (MacroInfo)info, (String)"profile", null);
                            }
                            String url = ProfileHelperAO.getUrlParameter((ProfileBean)profileBean, (MacroInfo)info, (String)"style", null, (BandanaManager)this.bandanaManager, (String)"org.swift.confluence.html.allowWhitelistedUrls", (String)"org.swift.confluence.html.blacklistDomains");
                            styleStream = ProfileHelperAO.getUrlStream((MacroInfo)info, (ProfileBean)profileBean, (String)url, (SettingsManager)this.settingsManager, (I18nResolver)this.i18nResolver, (String)"org.swift.confluence.html");
                        } else {
                            ScriptLibCommonBean scriptLibCommonBean = this.prepareScriptLibBean(info, "style");
                            this.getDataAllowUrl(scriptLibCommonBean);
                            styleStream = this.getUrlStream(info, null, style, false, null);
                        }
                        break block44;
                    }
                    switch (ScriptUtils.getResourceType((String)style, (boolean)true)) {
                        case 1: {
                            styleString = ScriptUtils.getFileAsString((File)this.getScriptAsFile(style.substring(1)), (String)encoding);
                            break block44;
                        }
                        case 4: {
                            styleStream = this.getAttachmentAsStream(style, info.getContent().toPageContext());
                            break block44;
                        }
                        case 3: {
                            styleString = this.getTemplateAsString(info, style);
                            break block44;
                        }
                        case 2: {
                            ScriptLibCommonBean scriptLibCommonBean = this.prepareScriptLibBean(info, "style");
                            this.getDataAllowUrl(scriptLibCommonBean);
                            styleStream = this.getUrlStream(info, null, style.substring(1), false, null);
                            break block44;
                        }
                        default: {
                            throw new MacroExecutionException(this.i18nResolver.getText("org.swift.confluence.html.unsupported.xslt.stylesheet.message-warning"));
                        }
                    }
                }
                styleStream = ScriptUtils.retrieveDataFromAppLink((MacroInfo)info, (ApplicationLink)appLink, (String)applinkStyle, (String)this.getSessionCookie(info, applinkStyle), (I18nResolver)this.i18nResolver, (String)"org.swift.confluence.html");
            }
            if (xmlString != null) {
                xmlStream = new ByteArrayInputStream(xmlString.getBytes());
            }
            if (xmlStream != null) {
                xmlStream = this.getReReadableStream(xmlStream);
            }
            if (styleString != null) {
                styleStream = new ByteArrayInputStream(styleString.getBytes());
            }
            if (styleStream != null) {
                styleStream = this.getReReadableStream(styleStream);
            }
            this.validateExternalEntity(info, xmlStream);
            this.validateExternalEntityStyles(info, styleStream);
            string = this.transform(info, new StreamSource(styleStream), new StreamSource(xmlStream));
            ScriptUtils.closeInputStream((InputStream)xmlStream);
        }
        catch (MacroExecutionException exception) {
            block37: {
                if (!HTMLUtils.checkForhyperlinkTag(exception.getMessage())) break block37;
                String string2 = exception.getMessage();
                return string2;
            }
            throw new MacroExecutionException(exception.getMessage());
        }
        catch (Exception exception2) {
            this.log.error("Unexpected exception.", (Throwable)exception2);
            throw new MacroExecutionException("Unexpected program error: " + exception2.toString());
        }
        ScriptUtils.closeInputStream((InputStream)styleStream);
        return string;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        finally {
            ScriptUtils.closeInputStream(xmlStream);
            ScriptUtils.closeInputStream(styleStream);
        }
    }

    private ScriptLibCommonBean prepareScriptLibBean(MacroInfo macroInfo, String paramType) throws MacroExecutionException {
        ScriptLibCommonBean scriptLibCommonBean = new ScriptLibCommonBean();
        scriptLibCommonBean.setMacroInfo(macroInfo);
        scriptLibCommonBean.setProfileHelper(null);
        scriptLibCommonBean.setParameterName(paramType);
        scriptLibCommonBean.setWantJson(false);
        scriptLibCommonBean.setBandanaManager(this.bandanaManager);
        scriptLibCommonBean.setConfigKey("org.swift.confluence.html.allowWhitelistedUrls");
        scriptLibCommonBean.setBlacklistConfigKey("org.swift.confluence.html.blacklistDomains");
        return scriptLibCommonBean;
    }

    private void validateExternalEntityStyles(MacroInfo info, InputStream styleStream) throws MacroExecutionException {
        try {
            boolean disableSecureProcessing = this.getDisableSecureProcessing(info);
            if (!disableSecureProcessing) {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setEntityResolver(new CustomResolver());
                xmlReader.setErrorHandler(new CustomErrorHandler());
                InputSource is = new InputSource(styleStream);
                xmlReader.parse(is);
                this.resetSourceStream(styleStream);
            }
        }
        catch (SAXException e) {
            throw new MacroExecutionException(this.i18nResolver.getText("org.swift.confluence.html.error.creating.xslt.transformer.message-warning"));
        }
        catch (IOException e) {
            throw new MacroExecutionException("External entities are disabled, please contact your system administrator. Exception while validating external entity: " + e.toString());
        }
    }

    private void resetSourceStream(InputStream sourceStream) throws IOException {
        if (sourceStream.markSupported()) {
            sourceStream.reset();
        }
    }

    private InputStream getReReadableStream(InputStream xmlStream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)xmlStream);
        ByteArrayInputStream originalStream = new ByteArrayInputStream(bytes);
        return originalStream;
    }

    private void validateExternalEntity(MacroInfo info, InputStream xmlStream) throws Exception {
        try {
            boolean disableSecureProcessing = this.getDisableSecureProcessing(info);
            if (!disableSecureProcessing) {
                this.disAllowExternalEntity(xmlStream);
                this.resetSourceStream(xmlStream);
            }
        }
        catch (ParserConfigurationException e) {
            throw new MacroExecutionException("Exception while validating XML: " + e.toString());
        }
        catch (SAXException e) {
            throw new MacroExecutionException("Exception while validating XML: " + e.toString());
        }
        catch (IOException e) {
            throw new MacroExecutionException("External entities are disabled, please contact your system administrator. Exception while validating external entity: " + e.toString());
        }
    }

    private boolean getDisableSecureProcessing(MacroInfo info) throws MacroExecutionException {
        boolean disableSecureProcessing = this.getGlobalDisableSecureProcessing();
        if (!disableSecureProcessing && (disableSecureProcessing = ScriptUtils.getBoolean((String)"disablesecureprocessing", (boolean)false, (MacroInfo)info))) {
            disableSecureProcessing = MacroSecurityUtils.securityCheck((BandanaManager)this.bandanaManager, (UserAccessor)this.userAccessor, (String)this.getMacroName(), (MacroInfo)info, (String)"disableSecureProcessing", null);
        }
        return disableSecureProcessing;
    }

    private void disAllowExternalEntity(InputStream inStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        builder.setEntityResolver(new CustomResolver());
        builder.setErrorHandler(new CustomErrorHandler());
        InputSource is = new InputSource(inStream);
        builder.parse(is);
    }

    protected String transform(MacroInfo info, StreamSource styleSource, StreamSource xmlSource) throws MacroExecutionException {
        StringWriter out = new StringWriter();
        StreamResult result = new StreamResult(out);
        String xsltVersion = info.getMacroParams().getString("xsltVersion", "1.0");
        this.log.debug("Selected XSLT Version: " + xsltVersion);
        boolean head = ScriptUtils.getBoolean((String)"head", (boolean)false, (MacroInfo)info);
        boolean showErrors = ScriptUtils.getBoolean((String)"showerrors", (boolean)false, (MacroInfo)info);
        String output = info.getMacroParams().getString("output", "html");
        boolean xhtml = output.equalsIgnoreCase("xhtml");
        boolean wiki = output.equalsIgnoreCase("wiki");
        String errorLevel = info.getMacroParams().getString("errorLevel", null);
        Transformer transformer = null;
        XsltErrorListener errorListener = new XsltErrorListener();
        try {
            TransformerFactory factory;
            if (StringUtils.isNotBlank((String)xsltVersion) && Arrays.asList("3.0", "2.0").contains(xsltVersion)) {
                factory = new TransformerFactoryImpl();
                if (!this.getDisableSecureProcessing(info)) {
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    factory.setURIResolver(new CustomUriResolver());
                    factory.setErrorListener(errorListener);
                }
                transformer = factory.newTransformer(styleSource);
            } else {
                factory = TransformerFactory.newInstance();
                if (!this.getDisableSecureProcessing(info)) {
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    factory.setURIResolver(new CustomUriResolver());
                    factory.setErrorListener(errorListener);
                }
                transformer = factory.newTransformer(styleSource);
            }
        }
        catch (TransformerConfigurationException exception) {
            throw new MacroExecutionException("Error creating XSLT transformer. " + exception.toString());
        }
        catch (TransformerFactoryConfigurationError exception) {
            throw new MacroExecutionException("Error creating XSLT transformer. " + exception.toString());
        }
        if (transformer == null) {
            this.log.debug("Error creating transformer.");
            throw new MacroExecutionException(this.i18nResolver.getText("org.swift.confluence.html.error.creating.xslt.transformer.message-warning"));
        }
        errorListener.setErrorLevel(errorLevel);
        transformer.setErrorListener(errorListener);
        this.setTransformerParameters(info, transformer);
        boolean wasTransformSuccessful = true;
        try {
            transformer.transform(xmlSource, result);
        }
        catch (TransformerException exception) {
            this.log.debug("Expected XSLT transformer exception: {}", (Object)exception.toString());
            wasTransformSuccessful = false;
        }
        catch (Exception exception) {
            this.log.debug("Unexpected XSLT transformer exception", (Throwable)exception);
            throw new MacroExecutionException("Unexpected XSLT transformer error: " + exception.toString());
        }
        StringBuilder builder = new StringBuilder();
        if (wasTransformSuccessful) {
            this.log.debug("transformed content with output {}, out: {}", (Object)output, (Object)out);
            if (wiki) {
                builder.append(this.subRenderer.render(out.toString(), (RenderContext)info.getConversionContext().getPageContext(), RENDER_MODE_WIKI));
            } else if (xhtml) {
                builder.append(HTMLUtils.validateAndSanitizeXsltMacroXss(info, this.render(info, ScriptUtils.removeSpecificHtmlTags((String)out.toString(), (boolean)head)), this.bandanaManager, this.userAccessor, this.getMacroName(), this.i18nResolver));
            } else {
                builder.append(ScriptUtils.removeSpecificHtmlTags((String)HTMLUtils.validateAndSanitizeXsltMacroXss(info, out.toString(), this.bandanaManager, this.userAccessor, this.getMacroName(), this.i18nResolver), (boolean)head));
            }
            if (showErrors) {
                builder.append(this.generateErrorHtml(info, errorListener.getErrorList()));
            }
        } else {
            builder.append(this.generateErrorHtml(info, errorListener.getErrorList()));
            builder.append("<div class=\"error\"><span class=\"error\">XSLT transformer was terminated with error level: ").append(errorListener.getErrorLevel()).append(".</span></div>");
        }
        return builder.toString();
    }

    protected String generateErrorHtml(MacroInfo info, List<String> errorList) {
        if (errorList.size() > 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("{noformat:title=XSLT transformer errors}\n");
            for (String line : errorList) {
                builder.append(line).append('\n');
            }
            builder.append("{noformat}");
            return this.subRenderer.render(builder.toString(), (RenderContext)info.getConversionContext().getPageContext(), RENDER_MODE_WIKI);
        }
        return "";
    }

    protected void setTransformerParameters(MacroInfo info, Transformer transformer) throws MacroExecutionException {
        Set keySet = info.getMacroParamsMap().keySet();
        for (String key : keySet) {
            if (key == null || key.startsWith(":") || key.equals("@body") || (key = key.trim()).equals("") || key.equalsIgnoreCase("style") || key.equalsIgnoreCase("source") || key.equalsIgnoreCase("output") || key.equalsIgnoreCase("head") || key.equalsIgnoreCase("encoding") || key.equalsIgnoreCase("user") || key.equalsIgnoreCase("password") || key.equalsIgnoreCase("showErrors") || key.equalsIgnoreCase("errorLevel") || key.startsWith("atlassian-")) continue;
            String value = (String)info.getMacroParamsMap().get(key);
            this.log.debug("Parameter key: {}, value: {}", (Object)key, (Object)value);
            if (value == null) continue;
            try {
                transformer.setParameter(key, value);
            }
            catch (Exception exception) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(exception.getMessage());
                }
                throw new MacroExecutionException("Error setting transform parameter: " + key + ", with value: " + value + ". Error was: " + exception.toString());
            }
        }
    }

    protected boolean getGlobalDisableSecureProcessing() {
        boolean result = "on".equals(this.bandanaManager.getValue((BandanaContext)bandanaContext, "org.swift.confluence.html.disableSecureProcessing"));
        this.log.debug("Global disableSecureProcessing on: {}", (Object)result);
        return result;
    }
}

