/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltErrorListener
implements ErrorListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected List<String> errorList = new ArrayList<String>();
    protected ErrorLevel errorLevel = ErrorLevel.FATAL;
    protected boolean terminating = false;

    public void setErrorLevel(String errorLevel) {
        if (errorLevel != null) {
            this.errorLevel = ErrorLevel.fromString(errorLevel);
        }
    }

    public void setErrorLevel(ErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
    }

    public String getErrorLevel() {
        return this.errorLevel.toString();
    }

    public List<String> getErrorList() {
        return this.errorList;
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this.addError(ErrorLevel.ERROR, exception);
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this.addError(ErrorLevel.FATAL, exception);
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this.addError(ErrorLevel.WARNING, exception);
    }

    protected void addError(ErrorLevel level, TransformerException exception) throws TransformerException {
        if (!this.terminating) {
            String message = exception.getMessage() == null ? exception.toString() : exception.getMessage().trim();
            this.log.debug((Object)((Object)level) + ": " + message);
            this.errorList.add((Object)((Object)level) + ": " + message);
        }
        this.log.debug("level: {}, errorLevel: {}", (Object)level.ordinal(), (Object)this.errorLevel.ordinal());
        if (level.compareTo(this.errorLevel) >= 0) {
            this.terminating = true;
            throw exception;
        }
    }

    protected static enum ErrorLevel {
        WARNING,
        ERROR,
        FATAL,
        NONE;


        private static ErrorLevel fromString(String string) {
            try {
                return ErrorLevel.valueOf(string.toUpperCase());
            }
            catch (Exception discard) {
                return FATAL;
            }
        }
    }
}

