/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.html;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.importexport.resource.DownloadResourceWriter;
import com.atlassian.confluence.importexport.resource.WritableDownloadResourceManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.swift.confluence.html.service.ManageProfileService;
import org.swift.confluence.html.util.HTMLUtils;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.FindReplaceUtilities;
import org.swift.confluence.scriptutil.LicensedScriptMacro;
import org.swift.confluence.scriptutil.ProfileHelperAO;
import org.swift.confluence.scriptutil.ScriptLibCommonBean;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.bean.ProfileBean;
import org.w3c.tidy.Tidy;

public class HtmlMacro
extends LicensedScriptMacro {
    protected static final RenderMode RENDER_MODE_WIKI = RenderMode.suppress((long)256L);
    private final BandanaManager bandanaManager;
    private final UserAccessor userAccessor;
    private final SubRenderer subRenderer;
    private static final int FILENAME_LENTH = 12;
    private final WritableDownloadResourceManager downloadResourceManager;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final ManageProfileService manageProfileService;
    @ComponentImport
    private final ApplicationLinkService applicationLinkService;

    public HtmlMacro(@ComponentImport SettingsManager settingsManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport PageTemplateManager templateManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport LocaleManager localeManager, @ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport XhtmlContent xhtmlContent, @ComponentImport BandanaManager bandanaManager, UserAccessor userAccessor, @ComponentImport SubRenderer subRenderer, @ComponentImport WritableDownloadResourceManager downloadResourceManager, @ComponentImport I18nResolver i18nResolver, ManageProfileService manageProfileService, @ComponentImport ApplicationLinkService applicationLinkService) {
        super(settingsManager, bootstrapManager, templateManager, spaceManager, pageManager, permissionManager, attachmentManager, localeManager, i18NBeanFactory, licenseManager, xhtmlContent);
        this.bandanaManager = bandanaManager;
        this.userAccessor = userAccessor;
        this.subRenderer = subRenderer;
        this.i18nResolver = i18nResolver;
        this.manageProfileService = manageProfileService;
        this.applicationLinkService = applicationLinkService;
        this.downloadResourceManager = downloadResourceManager;
    }

    protected boolean exemptDeveloperLicense() {
        return true;
    }

    protected String getExtension() {
        return ".html";
    }

    protected String getMacroName() {
        return "html-bobswift";
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    public String execute(MacroInfo info) throws MacroExecutionException {
        this.validateLicense(this.licenseManager);
        try {
            boolean isNewMacroConfigured = HTMLUtils.isNewMacroConfigured(this.bandanaManager, this.i18nResolver, this.getMacroName());
            HTMLUtils.checkMacroSecurity(this.bandanaManager, this.userAccessor, this.i18nResolver, info, this.getMacroName(), null, isNewMacroConfigured);
            return this.processScript(info, isNewMacroConfigured);
        }
        catch (MacroExecutionException exception) {
            if (HTMLUtils.checkForhyperlinkTag(exception.getMessage())) {
                return exception.getMessage();
            }
            throw new MacroExecutionException(exception.getMessage());
        }
        catch (Exception exception) {
            this.log.error("", (Throwable)exception);
            throw new MacroExecutionException(this.i18nResolver.getText("org.swift.confluence.html.unexpected.program.error", new Serializable[]{exception.toString()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processScript(MacroInfo info, boolean isNewMacroConfigured) throws MacroExecutionException, IOException {
        ApplicationLink appLink;
        StringBuilder data = new StringBuilder();
        data.append(info.getMacroBody());
        String blacklistDomainValues = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), "org.swift.confluence.html.blacklistDomainValues");
        String[] blacklistdomainArray = null;
        if (StringUtils.isNotBlank((String)blacklistDomainValues)) {
            blacklistdomainArray = blacklistDomainValues.split(",");
        }
        ScriptLibCommonBean scriptLibCommonBean = new ScriptLibCommonBean();
        scriptLibCommonBean.setMacroInfo(info);
        scriptLibCommonBean.setProfileHelper(null);
        scriptLibCommonBean.setParameterName("script");
        scriptLibCommonBean.setWantJson(false);
        scriptLibCommonBean.setBandanaManager(this.bandanaManager);
        scriptLibCommonBean.setConfigKey("org.swift.confluence.html.allowWhitelistedUrls");
        scriptLibCommonBean.setBlacklistConfigKey("org.swift.confluence.html.blacklistDomains");
        scriptLibCommonBean.setBlacklistDomainValues(blacklistdomainArray);
        String profileName = info.getMacroParams().getString("profile", "");
        String scriptURL = info.getMacroParams().getString("script", "");
        if (StringUtils.isNotBlank((String)scriptURL)) {
            scriptURL = scriptURL.substring(1);
        }
        if ((appLink = ScriptUtils.getApplicationLinkFromURL((String)scriptURL, (ApplicationLinkService)this.applicationLinkService)) == null) {
            if (StringUtils.isNotBlank((String)profileName)) {
                ProfileBean profileBean = this.manageProfileService.getProfileBeanForProfileName(profileName);
                if (profileBean != null) {
                    HTMLUtils.checkMacroSecurity(this.bandanaManager, this.userAccessor, this.i18nResolver, info, this.getMacroName(), "profile", isNewMacroConfigured);
                    String url = ProfileHelperAO.getUrlParameter((ProfileBean)profileBean, (MacroInfo)info, (String)"script", null, (BandanaManager)this.bandanaManager, (String)"org.swift.confluence.html.allowWhitelistedUrls", (String)"org.swift.confluence.html.blacklistDomains", (String[])blacklistdomainArray);
                    data.append(ProfileHelperAO.retrieveDataFromUrl((MacroInfo)info, (ProfileBean)profileBean, (String)url, (SettingsManager)this.settingsManager, (I18nResolver)this.i18nResolver, (String)"org.swift.confluence.html"));
                } else {
                    data.append(this.getDataAllowUrl(scriptLibCommonBean));
                }
            } else {
                data.append(this.getDataAllowUrl(scriptLibCommonBean));
            }
        } else {
            data.append(ScriptUtils.getStreamAsString((MacroInfo)info, (InputStream)ScriptUtils.retrieveDataFromAppLink((MacroInfo)info, (ApplicationLink)appLink, (String)scriptURL, (String)this.getSessionCookie(info, scriptURL), (I18nResolver)this.i18nResolver, (String)"org.swift.confluence.html")));
        }
        String output = info.getMacroParams().getString("output", "html");
        boolean xhtml = output.equals("xhtml");
        boolean wiki = output.equals("wiki");
        String noPanel = info.getMacroParams().getString("noPanel", "");
        StringBuilder builder = new StringBuilder();
        if (wiki) {
            builder.append(this.subRenderer.render("{noformat:nopanel=" + noPanel + "}" + ScriptUtils.trim((String)data.toString()) + "{noformat}", (RenderContext)info.getConversionContext().getPageContext(), RENDER_MODE_WIKI));
        } else if (xhtml) {
            builder.append(this.render(info, data.toString()));
        } else {
            boolean clean = ScriptUtils.getBoolean((String)"clean", (boolean)true, (MacroInfo)info);
            boolean tidy = ScriptUtils.getBoolean((String)"tidy", (boolean)false, (MacroInfo)info);
            boolean head = ScriptUtils.getBoolean((String)"head", (boolean)false, (MacroInfo)info);
            boolean useSrcDoc = ScriptUtils.getBoolean((String)"srcdoc", (boolean)false, (MacroInfo)info);
            String htmlData = data.toString();
            if (tidy) {
                StringReader inputData = new StringReader(data.toString());
                StringWriter outputData = new StringWriter();
                Tidy jTidy = new Tidy();
                jTidy.setDocType("omit");
                jTidy.parse((Reader)inputData, (Writer)outputData);
                htmlData = ((Object)outputData).toString();
            }
            if (clean) {
                builder.append(ScriptUtils.removeSpecificHtmlTags((String)htmlData, (boolean)head));
            } else {
                int width = info.getMacroParams().getInteger("width", Integer.valueOf(500));
                int height = info.getMacroParams().getInteger("height", Integer.valueOf(500));
                this.log.debug("use srcdoc: {}", (Object)useSrcDoc);
                if (useSrcDoc) {
                    builder.append("<iframe srcdoc=\"").append(StringEscapeUtils.escapeHtml((String)htmlData)).append("\" width=\"").append(width).append("\" height=\"").append(height).append("\"/>");
                } else {
                    DownloadResourceWriter downloadResourceWriter = this.downloadResourceManager.getResourceWriter(AuthenticatedUserThreadLocal.getUsername(), "html_iframe", ".txt");
                    try (OutputStream stream = downloadResourceWriter.getStreamForWriting();){
                        stream.write(htmlData.getBytes());
                    }
                    String sourceURL = "about:blank";
                    String resourcePath = downloadResourceWriter.getResourcePath();
                    if (resourcePath != null) {
                        int startIndex = resourcePath.lastIndexOf("/");
                        int endIndex = resourcePath.lastIndexOf(".");
                        String fileKey = resourcePath.substring(startIndex + 12, endIndex);
                        sourceURL = this.settingsManager.getGlobalSettings().getBaseUrl() + "/plugins/servlet/htmlMacroDownloadResource?fileKey=" + fileKey;
                    }
                    builder.append("<iframe src=\"").append(sourceURL).append("\" width=\"").append(width).append("\" height=\"").append(height).append("\"></iframe>");
                }
            }
        }
        return HTMLUtils.validateAndSanitizeHTMLMacroXss(info, FindReplaceUtilities.findReplace((MacroInfo)info, (String)builder.toString()), this.bandanaManager, this.userAccessor, this.getMacroName(), this.i18nResolver, isNewMacroConfigured);
    }
}

