/*
 * Decompiled with CFR 0.152.
 */
package com.appfire.confluence.rest.license;

import com.appfire.confluence.rest.license.LicenseResponse;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/validatelicense")
public class LicenseResource {
    static final Logger log = LoggerFactory.getLogger(LicenseResource.class);
    protected final I18nResolver i18nResolver;
    protected final SystemInformationService systemInformationService;
    protected final LicenseService licenseService;
    protected final TimeZoneManager timeZoneManager;
    protected final AccessModeService accessModeService;
    protected final PermissionManager permissionManager;
    protected final PluginLicenseManager pluginLicenseManager;

    public LicenseResource(I18nResolver i18nResolver, SystemInformationService systemInformationService, LicenseService licenseService, TimeZoneManager timeZoneManager, AccessModeService accessModeService, PermissionManager permissionManager, PluginLicenseManager pluginLicenseManager) {
        log.debug("injecting Spring dependencies for REST V1 in the LicenseResource endpoint");
        this.i18nResolver = i18nResolver;
        this.systemInformationService = systemInformationService;
        this.licenseService = licenseService;
        this.timeZoneManager = timeZoneManager;
        this.accessModeService = accessModeService;
        this.permissionManager = permissionManager;
        this.pluginLicenseManager = pluginLicenseManager;
        log.debug("injected Spring dependencies for REST V1 in the LicenseResource endpoint");
    }

    public LicenseResource() {
        log.debug("injecting Spring dependencies for REST V2 in the LicenseResource endpoint");
        this.i18nResolver = OsgiServices.importOsgiService(I18nResolver.class);
        this.systemInformationService = OsgiServices.importOsgiService(SystemInformationService.class);
        this.licenseService = OsgiServices.importOsgiService(LicenseService.class);
        this.timeZoneManager = OsgiServices.importOsgiService(TimeZoneManager.class);
        this.accessModeService = OsgiServices.importOsgiService(AccessModeService.class);
        this.permissionManager = OsgiServices.importOsgiService(PermissionManager.class);
        this.pluginLicenseManager = OsgiServices.importOsgiService(PluginLicenseManager.class);
        log.debug("injected Spring dependencies for REST V2 in the LicenseResource endpoint");
    }

    @GET
    @com.atlassian.plugins.rest.common.security.AnonymousSiteAccess
    @AnonymousSiteAccess
    @Produces(value={"application/json", "text/plain"})
    public Response getMessage(@QueryParam(value="option") String option) {
        return LicenseResource.buildResponse(this.validateLicense(option));
    }

    public LicenseResponse validateLicense(String option) {
        String reason = "UNKNOWN_ERROR";
        boolean licenseOk = this.pluginLicenseManager != null;
        ConfluenceLicense hostLicense = this.licenseService.retrieve();
        LicenseResponse licenseResponse = new LicenseResponse();
        this.addServerInfo(licenseResponse, option, hostLicense);
        if (licenseOk) {
            try {
                PluginLicense pluginLicense;
                boolean bl = licenseOk = this.pluginLicenseManager.getLicense() != null && this.pluginLicenseManager.getLicense().isDefined();
                reason = licenseOk ? (!(licenseOk = (pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid()) ? this.i18nResolver.getText(((LicenseError)pluginLicense.getError().get()).name()) : this.getText(".valid-license", new Serializable[0])) : this.getText(".no-license", new Serializable[0]);
            }
            catch (Exception exception) {
                log.error(exception.getMessage());
                licenseOk = false;
            }
        }
        if (!licenseOk && hostLicense.getLicenseType().equals((Object)LicenseType.DEVELOPER)) {
            reason = this.getText(".developer-license", new Serializable[0]);
            licenseOk = true;
        }
        if (!licenseOk) {
            reason = this.getText(".invalid-license", new Serializable[]{reason});
        }
        licenseResponse.setStatus(licenseOk);
        licenseResponse.setMessage(reason);
        log.debug("License response message: {}", (Object)licenseResponse.getMessage());
        return licenseResponse;
    }

    protected void addServerInfo(LicenseResponse licenseResponse, String option, ConfluenceLicense hostLicense) {
        try {
            ConfluenceInfo confluenceInfo = this.systemInformationService.getConfluenceInfo();
            Settings globalSettings = confluenceInfo.getGlobalSettings();
            licenseResponse.setProduct("Confluence");
            licenseResponse.setVersion(confluenceInfo.getVersion());
            licenseResponse.setBuild(confluenceInfo.getBuildNumber());
            licenseResponse.setBaseUrl(confluenceInfo.getBaseUrl());
            licenseResponse.setTitle(globalSettings.getSiteTitle());
            licenseResponse.setTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(System.currentTimeMillis()));
            licenseResponse.setTimeZone(this.timeZoneManager.getDefaultTimeZone().getDisplayName());
            licenseResponse.setReadOnly(this.accessModeService.isReadOnlyAccessModeEnabled());
            licenseResponse.setHosting(this.getHosting(hostLicense.isClusteringEnabled() || hostLicense.isSubscription()));
            boolean isConfluenceAdmin = this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get());
            if ("2".equals(option) && isConfluenceAdmin) {
                licenseResponse.setSupportEntitlementNumber(this.getPluginSupportEntitlementNumber());
                LinkedHashMap<String, Object> licenseInfo = new LinkedHashMap<String, Object>();
                licenseInfo.put("description", hostLicense.getDescription());
                licenseInfo.put("type", hostLicense.getLicenseType().name());
                licenseInfo.put("maxUsers", hostLicense.getMaximumNumberOfUsers());
                licenseInfo.put("unlimitedUsers", hostLicense.isUnlimitedNumberOfUsers());
                licenseInfo.put("expiry", this.toJsonDate(hostLicense.getMaintenanceExpiryDate()));
                licenseInfo.put("subscription", hostLicense.isSubscription());
                licenseInfo.put("evaluation", hostLicense.isEvaluation());
                licenseInfo.put("developer", hostLicense.getLicenseType().equals((Object)LicenseType.DEVELOPER));
                licenseInfo.put("supportEntitlementNumber", hostLicense.getSupportEntitlementNumber());
                licenseInfo.put("serverId", hostLicense.getServerId());
                licenseInfo.put("cluster", hostLicense.isClusteringEnabled());
                licenseInfo.put("maxNodes", hostLicense.getMaximumNumberOfClusterNodes());
                licenseResponse.setLicenseInfo(licenseInfo);
            }
        }
        catch (Exception exception) {
            log.error("Unexpected exception retrieving server information: {}", (Throwable)exception);
        }
    }

    protected String getHosting(boolean isCluster) {
        return isCluster ? "datacenter" : "server";
    }

    protected String getPluginSupportEntitlementNumber() {
        String supportEntitlementNumber = "";
        try {
            PluginLicense pluginLicense;
            Option pluginLicenseOption = this.pluginLicenseManager.getLicense();
            if (pluginLicenseOption != null && pluginLicenseOption.isDefined() && (pluginLicense = (PluginLicense)pluginLicenseOption.get()) != null && pluginLicense.getSupportEntitlementNumber().isDefined()) {
                supportEntitlementNumber = (String)pluginLicense.getSupportEntitlementNumber().get();
            }
        }
        catch (Exception e) {
            log.warn("Error while capturing plugin information ", (Throwable)e);
        }
        return supportEntitlementNumber;
    }

    public static Response buildResponse(LicenseResponse licenseResponse) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)LicenseResource.toJson(licenseResponse)).build();
    }

    public static String toJson(Object object) {
        return new Gson().toJson(object);
    }

    protected String toJsonDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    protected String getText(String key, Serializable ... arguments) {
        return this.i18nResolver.getText("org.swift.confluence.cli" + key, arguments);
    }
}

