/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.scriptutil.ScriptUtils;

public class TableStyleHelper {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final Pattern TR_PATTERN = Pattern.compile("(<tr([^>]*)>)");
    protected int rowCount = 0;
    protected int styleIndex = 0;

    public String modifyTableRowStyles(String html, List<String> styles, int headingCount, boolean multiple) {
        if (styles.size() > 0) {
            try {
                StringBuilder builder = new StringBuilder();
                int startTable = ScriptUtils.findTableIndex(html, 1);
                int endTable = ScriptUtils.findMatchedEndTableIndex(html, startTable);
                this.log.debug("startTable: {}, endTable: {}", (Object)startTable, (Object)endTable);
                builder.append(this.modifyTableRowStylesInternal(html.substring(0, startTable), styles, headingCount));
                if (startTable < html.length()) {
                    if (!multiple) {
                        this.log.debug("ignore embedded table starting: {}, ending: {}", (Object)startTable, (Object)endTable);
                        builder.append(html.substring(startTable, endTable));
                    }
                    this.log.debug("continue applying row styles starting: {}", (Object)endTable);
                    builder.append(this.modifyTableRowStyles(html.substring(endTable), styles, headingCount, multiple));
                }
                return builder.toString();
            }
            catch (Exception exception) {
                this.log.debug("Exception caught. Ignore with unapplied row styles.");
                this.log.debug("html: {}", (Object)html);
                this.log.debug("styles: {}", styles);
            }
        }
        return html;
    }

    protected String modifyTableRowStylesInternal(String html, List<String> styles, int headingCount) {
        Matcher matcher = TR_PATTERN.matcher(html);
        StringBuffer builder = new StringBuffer();
        while (matcher.find()) {
            ++this.rowCount;
            if (this.rowCount <= headingCount) {
                this.styleIndex = 0;
            }
            if (this.styleIndex >= styles.size()) {
                this.styleIndex = 1;
            }
            if (this.styleIndex >= styles.size()) break;
            this.log.debug("row count: {}, style index: {}", (Object)this.rowCount, (Object)this.styleIndex);
            if (StringUtils.isNotBlank((String)styles.get(this.styleIndex))) {
                String style = this.getStyleWithReferenceHandling(styles.get(this.styleIndex), styles);
                String replacement = "<tr style=\"" + style + "\" " + matcher.group(2).trim() + ">";
                matcher.appendReplacement(builder, replacement);
                this.log.debug("do a replacement with style: {}", (Object)style);
            }
            ++this.styleIndex;
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public String constructColumnStyleHtml(List<String> styleList) {
        StringBuilder builder = new StringBuilder();
        if (styleList.size() > 0) {
            builder.append("<colgroup>");
            for (String style : styleList) {
                style = this.getStyleWithReferenceHandling(style, styleList);
                builder.append("<col style=\"" + style + "\"/>");
            }
            builder.append("</colgroup>");
        }
        return builder.toString();
    }

    protected String getStyleWithReferenceHandling(String inStyle, List<String> styleList) {
        String style;
        String string = style = inStyle == null ? "" : inStyle.trim();
        if (!style.equals("") && StringUtils.isNumeric((String)style)) {
            int index = Integer.parseInt(style);
            style = index > 0 && index <= styleList.size() ? styleList.get(index - 1) : "";
        }
        return style;
    }
}

