/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.macro.MacroExecutionException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.scriptutil.ScriptUtils;
import org.swift.confluence.scriptutil.URLValidation;

public class BlacklistDomains {
    protected static final Logger log = LoggerFactory.getLogger(BlacklistDomains.class);

    public static boolean isURLBlacklisted(String url, boolean isBlackListToggleOn, String[] blacklistDomainValues) throws MacroExecutionException {
        if (isBlackListToggleOn) {
            block13: {
                String finalUrl = url;
                HttpURLConnection connection = null;
                try {
                    if (StringUtils.isNotBlank((String)url) && url.startsWith("file:")) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!ScriptUtils.checkUrlIsAllowed(url, true)) break block13;
                    do {
                        URLValidation.checkBlackListUrl(finalUrl, blacklistDomainValues);
                        connection = (HttpURLConnection)new URL(finalUrl).openConnection();
                        int responseCode = BlacklistDomains.getResponseCode(connection, finalUrl);
                        if (responseCode < 300 || responseCode > 307 || responseCode == 304) break;
                        String redirectedUrl = connection.getHeaderField("Location");
                        if (null == redirectedUrl) {
                            break;
                        }
                        String host = URLValidation.getHostOfUrl(redirectedUrl);
                        URL urlObj = connection.getURL();
                        finalUrl = StringUtils.isBlank((String)host) ? urlObj.getProtocol() + "://" + urlObj.getAuthority() + redirectedUrl : redirectedUrl;
                    } while (connection.getResponseCode() != 200 || connection.getResponseCode() != 404);
                }
                catch (IOException exception) {
                    log.error("Exception occured during validation blacklist url: ", (Throwable)exception);
                    throw new MacroExecutionException("Unexpected program error: " + exception.getMessage());
                }
                catch (URISyntaxException uriSyntaxException) {
                    log.error("Exception occured during validation blacklist url: ", (Throwable)uriSyntaxException);
                    throw new MacroExecutionException("Unexpected program error: " + uriSyntaxException.getMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error("Exception occured during validation blacklist url: ", (Throwable)illegalArgumentException);
                    throw new MacroExecutionException(illegalArgumentException.getMessage());
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isURLBlacklisted(String url, boolean isBlackListToggleOn) throws MacroExecutionException {
        return BlacklistDomains.isURLBlacklisted(url, isBlackListToggleOn, null);
    }

    private static int getResponseCode(HttpURLConnection connection, String finalUrl) throws IOException {
        connection.setInstanceFollowRedirects(false);
        connection.setUseCaches(false);
        connection.setConnectTimeout(5000);
        connection.connect();
        return connection.getResponseCode();
    }
}

