/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.macro.MacroExecutionException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.scriptutil.RunnableStreamReader;
import org.swift.confluence.scriptutil.ScriptUtils;

public class Runner {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String[] args;
    protected int exitCode;
    protected boolean cannotRunError = false;
    protected boolean deleteContentFileAfterRun = false;
    protected Object content;
    private File outputFile;
    protected String outputString;
    protected RunnableStreamReader.Type outputType = RunnableStreamReader.Type.TEXT;
    protected RunnableStreamReader stdoutRunnable;
    protected RunnableStreamReader stderrRunnable;

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public void setOutputType(RunnableStreamReader.Type type) {
        this.outputType = type;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isCannotRunError() {
        return this.cannotRunError;
    }

    public BufferedImage getImage() {
        return this.stdoutRunnable != null ? this.stdoutRunnable.getImage() : null;
    }

    public List<String> getOutput() {
        return this.stdoutRunnable != null ? this.stdoutRunnable.getList() : null;
    }

    public byte[] getBytes() {
        return this.stdoutRunnable != null ? this.stdoutRunnable.getBytes() : null;
    }

    public String getOutputString() {
        if (this.outputString == null) {
            this.outputString = ScriptUtils.toSeparatedString(this.getOutput(), "\n");
        }
        return this.outputString;
    }

    public List<String> getErrorList() {
        return this.stderrRunnable != null ? this.stderrRunnable.getList() : null;
    }

    public File getContentAsFile() {
        return this.content instanceof File ? (File)this.content : null;
    }

    public void run() throws MacroExecutionException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(this.args);
            if (this.content != null) {
                this.log.debug("content found: " + this.content.getClass().getName());
                int bytesCopied = -1;
                OutputStream stdin = process.getOutputStream();
                if (this.content instanceof String) {
                    stdin.write(((String)this.content).getBytes());
                    bytesCopied = ((String)this.content).length();
                } else if (this.content instanceof byte[]) {
                    stdin.write((byte[])this.content);
                    bytesCopied = ((byte[])this.content).length;
                } else if (this.content instanceof InputStream) {
                    bytesCopied = IOUtils.copy((InputStream)((InputStream)this.content), (OutputStream)stdin);
                }
                IOUtils.closeQuietly((OutputStream)stdin);
                this.log.debug("bytes copied to stdin: {}", (Object)bytesCopied);
            }
            this.stdoutRunnable = new RunnableStreamReader(process.getInputStream(), this.outputType);
            this.stderrRunnable = new RunnableStreamReader(process.getErrorStream(), RunnableStreamReader.Type.TEXT);
            Thread stdoutThread = new Thread((Runnable)this.stdoutRunnable, "Script utility stdout reader");
            Thread stderrThread = new Thread((Runnable)this.stderrRunnable, "Script utility stderr reader");
            stdoutThread.start();
            stderrThread.start();
            while (true) {
                try {
                    stdoutThread.join();
                    stderrThread.join();
                    this.exitCode = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.addFileToOutputList();
            this.log.debug("Exit code: {}", (Object)this.exitCode);
        }
        catch (IOException exception) {
            this.cannotRunError = true;
            this.log.error("Could not run '{}', exception was: {}", (Object)this.getExecutableName(), (Object)exception.toString());
            throw new MacroExecutionException("Requested service not available on this server. Contact your administrator if it is suppose to be available. A common error is that it is not on the PATH for the Confluence server. Exception is: " + exception.getMessage(), (Throwable)exception);
        }
        catch (Exception exception) {
            this.log.debug("Unexpected exception", (Throwable)exception);
            throw new MacroExecutionException("Unexpected exception: " + exception.getMessage(), (Throwable)exception);
        }
        finally {
            if (process != null) {
                this.destroyProcess(process);
            }
            if (this.deleteContentFileAfterRun && this.getContentAsFile() != null) {
                this.log.debug("delete file: {}", (Object)this.getContentAsFile());
                this.getContentAsFile().delete();
            }
        }
    }

    /*
     * Loose catch block
     */
    protected void addFileToOutputList() {
        if (this.outputFile != null) {
            FileInputStream inputStream = null;
            this.log.debug("get output from file: {}, list size: {}", (Object)this.outputFile, (Object)this.stdoutRunnable.getList().size());
            try {
                inputStream = new FileInputStream(this.outputFile);
                this.stdoutRunnable.getList().addAll(IOUtils.readLines((InputStream)inputStream));
                this.log.debug("list size: {}", (Object)this.stdoutRunnable.getList().size());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                IOUtils.closeQuietly((InputStream)inputStream);
                this.outputFile.delete();
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        this.outputFile.delete();
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                this.outputFile.delete();
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            this.outputFile.delete();
        }
    }

    protected String getExecutableName() {
        return this.args[0];
    }

    protected void destroyProcess(Process p) {
        if (p != null) {
            IOUtils.closeQuietly((InputStream)p.getInputStream());
            IOUtils.closeQuietly((OutputStream)p.getOutputStream());
            IOUtils.closeQuietly((InputStream)p.getErrorStream());
            p.destroy();
        }
    }

    protected File contentToFile(String prefix, String suffix) throws MacroExecutionException {
        if (!(this.content instanceof File)) {
            this.deleteContentFileAfterRun = true;
            this.log.debug("content class: {}", (Object)this.content.getClass().getName());
            try {
                File tempFile = File.createTempFile(prefix, suffix);
                tempFile.deleteOnExit();
                int bytesCopied = 0;
                if (this.content instanceof InputStream) {
                    bytesCopied = IOUtils.copy((InputStream)((InputStream)this.content), (OutputStream)new FileOutputStream(tempFile));
                }
                this.log.debug("bytes copied to temp file: {}", (Object)bytesCopied);
                this.content = tempFile;
            }
            catch (IOException exception) {
                this.log.debug("Unexpected exception", (Throwable)exception);
                throw new MacroExecutionException("Unexpected exception: " + exception.getMessage(), (Throwable)exception);
            }
        }
        this.log.debug("file: {}", (Object)this.getContentAsFile());
        return this.getContentAsFile();
    }

    protected File createFileForOutput(String prefix, String suffix) throws MacroExecutionException {
        try {
            this.outputFile = File.createTempFile(prefix, suffix);
        }
        catch (IOException exception) {
            throw new MacroExecutionException("Unexpected exception creating a temporary file: " + exception.getMessage(), (Throwable)exception);
        }
        this.outputFile.deleteOnExit();
        return this.outputFile;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }
}

