/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateHelper {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SettingsManager settingsManager;
    protected final FormatSettingsManager formatSettingsManager;
    protected final UserAccessor userAccessor;

    public DateHelper(SettingsManager settingsManager, FormatSettingsManager formatSettingsManager, UserAccessor userAccessor) {
        this.settingsManager = settingsManager;
        this.formatSettingsManager = formatSettingsManager;
        this.userAccessor = userAccessor;
    }

    public String formatDate(Date date, String dateFormat) {
        if (date == null) {
            return null;
        }
        DateFormat format = this.getDateFormat(dateFormat);
        return format.format(date);
    }

    public String formatDate(Date date, DateFormat format) {
        if (date == null) {
            return null;
        }
        return format.format(date);
    }

    public DateFormat getDateFormat(String dateFormat) {
        DateFormat format;
        try {
            format = this.getDateFormatWithCheck(dateFormat);
        }
        catch (Exception exception) {
            format = new SimpleDateFormat(this.formatSettingsManager.getDateTimeFormat());
        }
        format.setTimeZone(this.getUserTimeZone((User)AuthenticatedUserThreadLocal.get()));
        return format;
    }

    public DateFormat getDateFormatWithCheck(String dateFormat) throws MacroExecutionException {
        try {
            if (StringUtils.isBlank((String)dateFormat)) {
                dateFormat = this.formatSettingsManager.getDateTimeFormat();
            }
            return new SimpleDateFormat(dateFormat.trim());
        }
        catch (Exception exception) {
            this.log.debug("Exception getting format: {}, exception: {}", (Object)dateFormat, (Object)exception.toString());
            throw new MacroExecutionException("Invalid date format: " + dateFormat + ". Error was: " + exception.toString());
        }
    }

    public TimeZone getUserTimeZone(User user) {
        return (user == null ? this.settingsManager.getGlobalSettings().getTimeZone() : this.userAccessor.getConfluenceUserPreferences(user).getTimeZone()).getWrappedTimeZone();
    }
}

