/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLValidation {
    protected static final Logger log = LoggerFactory.getLogger(URLValidation.class);
    private static List<String> blackSubnetList = new LinkedList<String>(Arrays.asList("10.0.0.0/8", "100.64.0.0/10", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", "192.168.0.0/16", "192.0.0.0/24", "198.18.0.0/15", "255.255.255.255/32", "0.0.0.0/32", "192.0.2.0/24", "192.88.99.0/24", "198.51.100.0/24", "203.0.113.0/24", "224.0.0.0/4", "240.0.0.0/4"));

    public static void checkBlackListUrl(String url, String[] blacklistDomainValues) throws IllegalArgumentException {
        try {
            log.debug("In URLValidation checkBlackListUrl..");
            String host = URLValidation.getDecimalIp(URLValidation.getHostOfUrl(url));
            InetAddress inetAddress = InetAddress.getByName(host);
            String ipAddress = inetAddress.getHostAddress();
            if (URLValidation.isInternalIpAddress(inetAddress) || URLValidation.isInternalBlockedIp(ipAddress, blacklistDomainValues)) {
                log.error("Error occured..Invalid URL: Internal IPs are not supported");
                throw new IllegalArgumentException("Error loading data from " + url);
            }
        }
        catch (MalformedURLException | URISyntaxException | UnknownHostException e) {
            log.error("Error occured..Invalid URL: unknown host or invalid URL syntax");
            throw new IllegalArgumentException("Invalid URL: unknown host or invalid URL syntax");
        }
    }

    public static void checkBlackListUrl(String url) throws IllegalArgumentException {
        URLValidation.checkBlackListUrl(url, null);
    }

    public static String getHostOfUrl(String url) throws URISyntaxException {
        return new URI(url).getHost();
    }

    public static boolean isInternalBlockedIp(String ipAddress, String[] blacklistDomainValues) {
        if (blacklistDomainValues != null && blacklistDomainValues.length > 0) {
            blackSubnetList = Arrays.asList(blacklistDomainValues);
        }
        for (String subnet : blackSubnetList) {
            SubnetUtils utils = new SubnetUtils(subnet);
            if (!ipAddress.equals(subnet.split("/")[0]) && !utils.getInfo().isInRange(ipAddress)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInternalIpAddress(InetAddress addr) throws UnknownHostException, MalformedURLException {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            log.error("Error occured..", (Throwable)e);
            return false;
        }
    }

    private static String getDecimalIp(String ipAddress) throws UnknownHostException {
        String[] ipParts = ipAddress.split("\\.");
        String parsedIp = ipAddress;
        if (ipParts.length == 4) {
            try {
                parsedIp = String.join((CharSequence)".", URLValidation.getDecimalNumber(ipParts[0]), URLValidation.getDecimalNumber(ipParts[1]), URLValidation.getDecimalNumber(ipParts[2]), URLValidation.getDecimalNumber(ipParts[3]));
            }
            catch (NumberFormatException e) {
                parsedIp = ipAddress;
            }
        } else if (ipParts.length == 1 && ipParts[0].startsWith("0x")) {
            InetAddress ip = InetAddress.getByAddress(DatatypeConverter.parseHexBinary((String)ipParts[0].substring(2)));
            parsedIp = ip.getHostAddress();
        }
        return parsedIp;
    }

    private static String getDecimalNumber(String octOrDecNum) {
        Integer returnVal = 0;
        returnVal = octOrDecNum.startsWith("0") ? Integer.valueOf(Integer.parseInt(octOrDecNum, 8)) : Integer.valueOf(Integer.parseInt(octOrDecNum));
        return String.valueOf(returnVal);
    }
}

