/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.macro.Macro;

public class StorageFormatUtilities {
    public static void appendMacroStart(StringBuilder builder, String name) {
        builder.append("<ac:structured-macro ac:name=\"").append(name).append("\">\n");
    }

    public static void appendMacroEnd(StringBuilder builder) {
        builder.append("</ac:structured-macro>\n");
    }

    public static void appendParameter(StringBuilder builder, String name, String value) {
        builder.append("<ac:parameter ac:name=\"").append(name).append("\">").append(value).append("</ac:parameter>\n");
    }

    public static void appendParameter(StringBuilder builder, String name, boolean value) {
        builder.append("<ac:parameter ac:name=\"").append(name).append("\">").append(value ? "true" : "false").append("</ac:parameter>\n");
    }

    public static void appendPlainTextBody(StringBuilder builder, String body) {
        builder.append("<ac:plain-text-body>");
        StorageFormatUtilities.appendCDataSection(builder, body);
        builder.append("</ac:plain-text-body>\n");
    }

    public static void appendRichTextBodyStart(StringBuilder builder) {
        builder.append("<ac:rich-text-body>\n");
    }

    public static void appendRichTextBodyEnd(StringBuilder builder) {
        builder.append("</ac:rich-text-body>\n");
    }

    public static void appendOutputFormatType(StringBuilder builder, Macro.OutputType outputType) {
        builder.append("<ac:parameter ac:name=\"atlassian-macro-output-type\">").append(outputType).append("</ac:parameter>");
    }

    public static void appendCDataSection(StringBuilder builder, String body) {
        builder.append("<![CDATA[").append(body.replace("]]>", "]]]]><![CDATA[>") + "]]>");
    }
}

