/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.swift.confluence.macroutil.MacroInfo;
import org.swift.confluence.scriptutil.ScriptUtils;

public class FindReplaceUtilities {
    static final Pattern CURRENT_TIME_WITH_FORMAT = Pattern.compile("\\$current_time\\(([^)]+)\\)");

    public static boolean needFindReplace(MacroInfo info) {
        return null != info.getMacroParams().getString("find", null) && null != info.getMacroParams().getString("replace", null);
    }

    public static String findReplace(MacroInfo info, String text) throws MacroExecutionException {
        String find = info.getMacroParams().getString("find", "");
        String replace = info.getMacroParams().getString("replace", "");
        if (find.equals("") || replace.equals("")) {
            return text;
        }
        return FindReplaceUtilities.findReplace(text, find, FindReplaceUtilities.findReplaceAutomatic(info, replace, false));
    }

    public static StringReader findReplace(MacroInfo info, InputStream inputStream, String encoding) throws MacroExecutionException, IOException {
        return new StringReader(FindReplaceUtilities.findReplace(info, ScriptUtils.getStreamAsString(inputStream, encoding)));
    }

    public static String findReplace(String text, String find, String replace) throws MacroExecutionException {
        List<String> findList = ScriptUtils.csvDataAsList(find, ",", '\'', '\n');
        List<String> replaceList = ScriptUtils.csvDataAsList(replace, ",", '\'', '\n');
        String modified = text;
        try {
            for (int i = 0; i < findList.size() && i < replaceList.size(); ++i) {
                modified = FindReplaceUtilities.findReplace(modified, Pattern.compile(findList.get(i)), replaceList.get(i));
            }
        }
        catch (PatternSyntaxException exception) {
            throw new MacroExecutionException(exception.toString());
        }
        return modified;
    }

    public static String findReplace(String text, Pattern pattern, String replace) {
        StringBuffer builder = new StringBuffer(text.length());
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            matcher.appendReplacement(builder, replace);
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static String findReplaceAutomatic(MacroInfo info, String modified, boolean encode) throws MacroExecutionException {
        User user = info.getCurrentUser();
        if (user != null) {
            modified = StringUtils.replace((String)modified, (String)"$current_user_id", (String)user.getName());
            modified = StringUtils.replace((String)modified, (String)"$current_user_name", (String)FindReplaceUtilities.clean(user.getFullName(), encode));
            modified = StringUtils.replace((String)modified, (String)"$current_user_email", (String)FindReplaceUtilities.clean(user.getEmail(), encode));
        } else {
            modified = StringUtils.replace((String)modified, (String)"$current_user_id", (String)"");
            modified = StringUtils.replace((String)modified, (String)"$current_user_name", (String)"");
            modified = StringUtils.replace((String)modified, (String)"$current_user_email", (String)"");
        }
        if (info.getSpace() != null) {
            modified = StringUtils.replace((String)modified, (String)"$space_name", (String)FindReplaceUtilities.clean(info.getSpace().getName(), encode));
            modified = StringUtils.replace((String)modified, (String)"$space_key", (String)info.getSpace().getKey());
            modified = StringUtils.replace((String)modified, (String)"$page_title", (String)FindReplaceUtilities.clean(info.getConversionContext().getPageContext().getPageTitle(), encode));
            modified = StringUtils.replace((String)modified, (String)"$page_id", (String)info.getConversionContext().getPageContext().getEntity().getIdAsString());
            String baseUrl = GeneralUtil.getGlobalSettings().getBaseUrl();
            String tinyUrlId = new TinyUrl((AbstractPage)info.getContent()).getIdentifier();
            modified = StringUtils.replace((String)modified, (String)"$base_url", (String)baseUrl);
            modified = StringUtils.replace((String)modified, (String)"$page_tinyurl", (String)(baseUrl + "/x/" + tinyUrlId));
            String pageUrl = baseUrl + info.getContent().getUrlPath();
            modified = StringUtils.replace((String)modified, (String)"$page_url", (String)pageUrl);
        }
        if (modified.contains("$current_time")) {
            String defaultDateFormat = info.getMacroParams().getString("dateformat", "");
            DateFormat df = ScriptUtils.getDateFormat(defaultDateFormat, "");
            Calendar now = Calendar.getInstance();
            modified = FindReplaceUtilities.findReplaceCurrentTimeWithFormat(modified, now, defaultDateFormat, encode);
            modified = StringUtils.replace((String)modified, (String)"$current_time", (String)FindReplaceUtilities.clean(df.format(now.getTime()), encode));
        }
        return modified;
    }

    public static String findReplaceCurrentTimeWithFormat(String modified, Calendar now, String defaultDateFormat, boolean encode) throws MacroExecutionException {
        StringBuffer builder = new StringBuffer();
        Matcher matcher = CURRENT_TIME_WITH_FORMAT.matcher(modified);
        while (matcher.find()) {
            DateFormat dateFormat = ScriptUtils.getDateFormat(matcher.group(1), defaultDateFormat);
            String replace = FindReplaceUtilities.clean(dateFormat.format(now.getTime()), encode);
            matcher.appendReplacement(builder, replace);
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    public static String findReplaceAutomatic(MacroInfo info, String modified, UserAccessor userAccessor, SettingsManager settingsManager, BootstrapManager bootstrapManager) throws MacroExecutionException {
        User user = info.getCurrentUser();
        if (user != null) {
            modified = StringUtils.replace((String)modified, (String)"$current_user_timezone_offset", (String)ScriptUtils.getTimeZoneOffsetHours(userAccessor.getConfluenceUserPreferences(user).getTimeZone()));
            modified = StringUtils.replace((String)modified, (String)"$current_user_timezone_id", (String)userAccessor.getConfluenceUserPreferences(user).getTimeZone().getID());
        } else {
            modified = StringUtils.replace((String)modified, (String)"$current_user_timezone_offset", (String)ScriptUtils.getTimeZoneOffsetHours(settingsManager.getGlobalSettings().getTimeZone()));
            modified = StringUtils.replace((String)modified, (String)"$current_user_timezone_id", (String)settingsManager.getGlobalSettings().getTimeZone().getID());
        }
        modified = StringUtils.replace((String)modified, (String)"$confluence_home", (String)bootstrapManager.getConfluenceHome());
        return modified;
    }

    public static String clean(String value, boolean encode) {
        return encode ? GeneralUtil.htmlEncode((String)value) : value;
    }
}

