/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.macroutil;

import java.util.HashMap;
import java.util.Map;
import org.swift.confluence.scriptutil.exception.InvalidParameterException;

public class MacroParameterStorage {
    private final Map<String, String> parameters;
    private final Map<String, String> originalParameters;

    public MacroParameterStorage(Map<String, String> params) {
        this.cleanIndexedParams(params);
        this.originalParameters = params;
        this.parameters = this.toLowerCase(params);
    }

    private Map<String, String> toLowerCase(Map<String, String> params) {
        HashMap<String, String> lcParams = new HashMap<String, String>();
        for (Map.Entry<String, String> e : params.entrySet()) {
            lcParams.put(e.getKey().toLowerCase(), e.getValue());
        }
        return lcParams;
    }

    private void cleanIndexedParams(Map<String, String> params) {
        String value;
        int i = 0;
        do {
            String index;
            if ((value = params.get(index = String.valueOf(i++))) == null || value.indexOf(61) < 0) continue;
            params.remove(index);
        } while (value != null);
    }

    public Boolean getBoolean(String name, boolean def) {
        if (this.parameters.get(name = name.toLowerCase()) != null && (this.parameters.get(name).trim().toLowerCase().equalsIgnoreCase("true") || this.parameters.get(name).trim().toLowerCase().equalsIgnoreCase("false"))) {
            return Boolean.valueOf(this.parameters.get(name));
        }
        return def;
    }

    public Double getDouble(String name, double def) {
        name = name.toLowerCase();
        String value = this.parameters.get(name);
        try {
            if (value != null) {
                return Double.valueOf(value);
            }
            return def;
        }
        catch (NumberFormatException e) {
            throw new InvalidParameterException("Value for '" + name + "' is not a valid double: " + value, e);
        }
    }

    public Integer getInteger(String name, Integer def) {
        String value = this.parameters.get(name = name.toLowerCase());
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException("Value for '" + name + "' is not a valid integer: " + value, e);
            }
        }
        return def;
    }

    public Map<String, String> getParams() {
        return this.parameters;
    }

    public String getString(String name, String def) {
        if (this.parameters.get(name = name.toLowerCase()) != null) {
            return String.valueOf(this.parameters.get(name));
        }
        return def;
    }

    public Map<String, String> getOriginalParams() {
        return this.originalParameters;
    }
}

