/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.scriptutil;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class RunnableStreamReader
implements Runnable {
    private final InputStream stream;
    private final Type type;
    private List<String> list = null;
    private BufferedImage image = null;
    private byte[] bytes = null;
    private Exception exception = null;

    public RunnableStreamReader(InputStream stream, Type type) {
        this.stream = stream;
        this.type = type;
    }

    public List<String> getList() {
        return this.list;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public void run() {
        switch (this.type) {
            case TEXT: {
                this.readText();
                break;
            }
            case IMAGE: {
                this.readImage();
                break;
            }
            case BYTES: {
                this.readBytes();
            }
        }
    }

    public void readText() {
        this.list = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
        try {
            String line = reader.readLine();
            while (line != null) {
                this.list.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException exception) {
            this.exception = exception;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.stream);
        }
    }

    public void readBytes() {
        try {
            this.bytes = IOUtils.toByteArray((InputStream)this.stream);
        }
        catch (IOException exception) {
            this.exception = exception;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.stream);
        }
    }

    public void readImage() {
        try {
            this.image = ImageIO.read(this.stream);
        }
        catch (IOException exception) {
            this.exception = exception;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.stream);
        }
    }

    public static enum Type {
        TEXT,
        IMAGE,
        BYTES;

    }
}

