/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.macroutil;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swift.confluence.scriptutil.exception.InvalidParameterException;

public class RequestParameterStorage {
    protected static final Logger log = LoggerFactory.getLogger((String)"org.swift.confluence.scriptutil.ScriptUtils");
    private final HttpServletRequest request;

    public RequestParameterStorage(HttpServletRequest request) {
        this.request = request;
    }

    public Boolean getBoolean(String name, boolean def) {
        try {
            if (this.request.getParameter(name) != null) {
                return Boolean.valueOf(this.request.getParameter(name));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new InvalidParameterException(name, e);
        }
        return def;
    }

    public Double getDouble(String name, double def) {
        try {
            if (this.request.getParameter(name) != null) {
                return Double.valueOf(this.request.getParameter(name));
            }
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage());
            throw new InvalidParameterException("Value for '" + name + "' is not a valid double: " + this.request.getParameter(name), e);
        }
        return def;
    }

    public Integer getInteger(String name, Integer def) {
        try {
            if (this.request.getParameter(name) != null) {
                return Integer.valueOf(this.request.getParameter(name));
            }
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage());
            throw new InvalidParameterException("Value for '" + name + "' is not a valid Integer: " + this.request.getParameter(name), e);
        }
        return def;
    }

    public Map<String, String[]> getParams() {
        return this.request.getParameterMap();
    }

    public String getString(String name, String def) {
        try {
            if (this.request.getParameter(name) != null) {
                return String.valueOf(this.request.getParameter(name));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new InvalidParameterException(name, e);
        }
        return def;
    }

    public String[] getStringArray(String name, String[] def) {
        if (this.request.getParameter(name) != null) {
            return this.request.getParameterValues(name);
        }
        return def;
    }
}

