/*
 * Decompiled with CFR 0.152.
 */
package org.swift.confluence.macroutil;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import org.swift.confluence.macroutil.RequestInfo;

public class ConfluencePageInfo
extends RequestInfo {
    private static final ThreadLocal<ContentEntityObject> contentContext = new ThreadLocal();
    private ContentEntityObject content;

    public ConfluencePageInfo(ContentEntityObject content) {
        this.setContent(content);
    }

    public static ContentEntityObject getCurrentContent() {
        return contentContext.get();
    }

    protected void setContent(ContentEntityObject content) {
        this.content = content;
        contentContext.set(content);
    }

    public ContentEntityObject getContent() {
        return this.content;
    }

    public Space getSpace() {
        ContentEntityObject content = this.getContent();
        if (content instanceof SpaceContentEntityObject) {
            return ((SpaceContentEntityObject)content).getSpace();
        }
        return null;
    }

    public User getCurrentUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    @Override
    public void close() {
        super.close();
        if (contentContext.get() == this.content) {
            contentContext.remove();
        }
        this.content = null;
    }
}

